/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache.impl.idCache;

import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.lexer.Lexer;
import com.intellij.psi.impl.cache.impl.BaseFilterLexer;
import com.intellij.psi.impl.cache.impl.CacheUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlElementType;

public class XHtmlFilterLexer
extends BaseFilterLexer {
    public XHtmlFilterLexer(Lexer originalLexer, BaseFilterLexer.OccurrenceConsumer table) {
        super(originalLexer, table);
    }

    public void advance() {
        IElementType tokenType = this.getDelegate().getTokenType();
        if (tokenType == XmlElementType.XML_COMMENT_CHARACTERS) {
            this.scanWordsInToken(2, false, false);
            this.advanceTodoItemCountsInToken();
        } else if (tokenType == XmlElementType.XML_ATTRIBUTE_VALUE_TOKEN || tokenType == XmlElementType.XML_NAME || tokenType == XmlElementType.XML_TAG_NAME) {
            this.scanWordsInToken(24, tokenType == XmlElementType.XML_ATTRIBUTE_VALUE_TOKEN, false);
        } else if (tokenType.getLanguage() != XMLLanguage.INSTANCE && tokenType.getLanguage() != Language.ANY) {
            boolean inComments = CacheUtil.isInComments(tokenType);
            this.scanWordsInToken(inComments ? 2 : 24, true, false);
            if (inComments) {
                this.advanceTodoItemCountsInToken();
            }
        } else {
            this.scanWordsInToken(16, false, false);
        }
        this.getDelegate().advance();
    }
}

