/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.tree.IElementType;
import gnu.trove.TObjectIntHashMap;
import org.jetbrains.annotations.NonNls;

public class RecordUtil {
    @NonNls
    private static final String DEPRECATED_ANNOTATION_NAME = "Deprecated";
    @NonNls
    private static final String DEPRECATED_TAG = "@deprecated";
    private static final TObjectIntHashMap<String> ourModifierNameToFlagMap = new TObjectIntHashMap();

    private RecordUtil() {
    }

    public static boolean isDeprecatedByAnnotation(PsiElement element) {
        PsiModifierList modifierList;
        if (element instanceof PsiModifierListOwner && (modifierList = ((PsiModifierListOwner)element).getModifierList()) != null) {
            PsiAnnotation[] annotations;
            for (PsiAnnotation annotation : annotations = modifierList.getAnnotations()) {
                PsiJavaCodeReferenceElement nameElement = annotation.getNameReferenceElement();
                if (nameElement == null || !DEPRECATED_ANNOTATION_NAME.equals(nameElement.getReferenceName())) continue;
                return true;
            }
        }
        return false;
    }

    public static int packModifierList(PsiModifierList psiModifierList) {
        int packed = 0;
        if (psiModifierList.hasModifierProperty("abstract")) {
            packed |= 0x400;
        }
        if (psiModifierList.hasModifierProperty("final")) {
            packed |= 0x10;
        }
        if (psiModifierList.hasModifierProperty("native")) {
            packed |= 0x100;
        }
        if (psiModifierList.hasModifierProperty("static")) {
            packed |= 8;
        }
        if (psiModifierList.hasModifierProperty("synchronized")) {
            packed |= 0x20;
        }
        if (psiModifierList.hasModifierProperty("transient")) {
            packed |= 0x80;
        }
        if (psiModifierList.hasModifierProperty("volatile")) {
            packed |= 0x40;
        }
        if (psiModifierList.hasModifierProperty("private")) {
            packed |= 2;
        }
        if (psiModifierList.hasModifierProperty("protected")) {
            packed |= 4;
        }
        if (psiModifierList.hasModifierProperty("public")) {
            packed |= 1;
        }
        if (psiModifierList.hasModifierProperty("packageLocal")) {
            packed |= 0x1000;
        }
        if (psiModifierList.hasModifierProperty("strictfp")) {
            packed |= 0x800;
        }
        return packed;
    }

    public static boolean isDeprecatedByDocComment(PsiElement psiElement) {
        if (!(psiElement instanceof PsiDocCommentOwner)) {
            return false;
        }
        PsiDocCommentOwner owner = (PsiDocCommentOwner)psiElement;
        if (owner instanceof PsiCompiledElement) {
            return owner.isDeprecated();
        }
        ASTNode node = psiElement.getNode();
        ASTNode docNode = node.findChildByType((IElementType)JavaDocElementType.DOC_COMMENT);
        if (docNode == null || docNode.getText().indexOf(DEPRECATED_TAG) < 0) {
            return false;
        }
        PsiDocComment docComment = owner.getDocComment();
        return docComment != null && docComment.findTagByName("deprecated") != null;
    }

    private static void initMaps() {
        ourModifierNameToFlagMap.put((Object)"public", 1);
        ourModifierNameToFlagMap.put((Object)"protected", 4);
        ourModifierNameToFlagMap.put((Object)"private", 2);
        ourModifierNameToFlagMap.put((Object)"packageLocal", 4096);
        ourModifierNameToFlagMap.put((Object)"static", 8);
        ourModifierNameToFlagMap.put((Object)"abstract", 1024);
        ourModifierNameToFlagMap.put((Object)"final", 16);
        ourModifierNameToFlagMap.put((Object)"native", 256);
        ourModifierNameToFlagMap.put((Object)"synchronized", 32);
        ourModifierNameToFlagMap.put((Object)"transient", 128);
        ourModifierNameToFlagMap.put((Object)"volatile", 64);
        ourModifierNameToFlagMap.put((Object)"strictfp", 2048);
        ourModifierNameToFlagMap.put((Object)"interface", 512);
        ourModifierNameToFlagMap.put((Object)"deprecated", 8192);
        ourModifierNameToFlagMap.put((Object)"@Deprecated", 65536);
        ourModifierNameToFlagMap.put((Object)"enum", 16384);
        ourModifierNameToFlagMap.put((Object)"@", 32768);
    }

    public static boolean hasModifierProperty(String psiModifier, int packed) {
        return (ourModifierNameToFlagMap.get((Object)psiModifier) & packed) != 0;
    }

    static {
        RecordUtil.initMaps();
    }
}

