/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.artifacts;

import com.intellij.openapi.project.Project;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactAdapter;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.artifacts.ArtifactModel;
import com.intellij.packaging.artifacts.ArtifactPointer;
import com.intellij.packaging.artifacts.ArtifactPointerManager;
import com.intellij.packaging.impl.artifacts.ArtifactPointerImpl;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class ArtifactPointerManagerImpl
extends ArtifactPointerManager {
    private final Map<String, ArtifactPointerImpl> myUnresolvedPointers = new HashMap<String, ArtifactPointerImpl>();
    private final Map<Artifact, ArtifactPointerImpl> myPointers = new HashMap<Artifact, ArtifactPointerImpl>();
    private ArtifactManager myArtifactManager;

    public ArtifactPointerManagerImpl(Project project) {
        project.getMessageBus().connect().subscribe(ArtifactManager.TOPIC, (Object)new ArtifactAdapter(){

            public void artifactRemoved(@NotNull Artifact artifact) {
                if (artifact == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactPointerManagerImpl$1.artifactRemoved must not be null");
                }
                ArtifactPointerManagerImpl.this.disposePointer(artifact);
            }

            public void artifactAdded(@NotNull Artifact artifact) {
                ArtifactPointerImpl unresolved;
                if (artifact == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactPointerManagerImpl$1.artifactAdded must not be null");
                }
                ArtifactPointerImpl pointer = (ArtifactPointerImpl)ArtifactPointerManagerImpl.this.myPointers.get(artifact);
                if (pointer != null) {
                    pointer.setName(artifact.getName());
                }
                if ((unresolved = (ArtifactPointerImpl)ArtifactPointerManagerImpl.this.myUnresolvedPointers.remove(artifact.getName())) != null) {
                    unresolved.setArtifact(artifact);
                    if (pointer == null) {
                        ArtifactPointerManagerImpl.this.myPointers.put(artifact, unresolved);
                    }
                }
            }

            public void artifactChanged(@NotNull Artifact artifact, @NotNull String oldName) {
                ArtifactPointerImpl unresolved;
                if (artifact == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactPointerManagerImpl$1.artifactChanged must not be null");
                }
                if (oldName == null) {
                    throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactPointerManagerImpl$1.artifactChanged must not be null");
                }
                ArtifactPointerImpl pointer = (ArtifactPointerImpl)ArtifactPointerManagerImpl.this.myPointers.get(artifact);
                if (pointer != null) {
                    pointer.setName(artifact.getName());
                }
                if ((unresolved = (ArtifactPointerImpl)ArtifactPointerManagerImpl.this.myUnresolvedPointers.remove(artifact.getName())) != null) {
                    unresolved.setArtifact(artifact);
                    if (pointer == null) {
                        ArtifactPointerManagerImpl.this.myPointers.put(artifact, unresolved);
                    }
                }
            }
        });
    }

    public void setArtifactManager(ArtifactManager artifactManager) {
        this.myArtifactManager = artifactManager;
    }

    private void disposePointer(Artifact artifact) {
        ArtifactPointerImpl pointer = this.myPointers.remove(artifact);
        if (pointer != null) {
            pointer.setArtifact(null);
            this.myUnresolvedPointers.put(pointer.getArtifactName(), pointer);
        }
    }

    public ArtifactPointer createPointer(@NotNull String name) {
        Artifact artifact;
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactPointerManagerImpl.createPointer must not be null");
        }
        if (this.myArtifactManager != null && (artifact = this.myArtifactManager.findArtifact(name)) != null) {
            return this.createPointer(artifact);
        }
        ArtifactPointerImpl pointer = this.myUnresolvedPointers.get(name);
        if (pointer == null) {
            pointer = new ArtifactPointerImpl(name);
            this.myUnresolvedPointers.put(name, pointer);
        }
        return pointer;
    }

    public ArtifactPointer createPointer(@NotNull Artifact artifact) {
        if (artifact == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactPointerManagerImpl.createPointer must not be null");
        }
        ArtifactPointerImpl pointer = this.myPointers.get(artifact);
        if (pointer == null) {
            pointer = this.myUnresolvedPointers.get(artifact.getName());
            if (pointer != null) {
                pointer.setArtifact(artifact);
            } else {
                pointer = new ArtifactPointerImpl(artifact);
            }
            this.myPointers.put(artifact, pointer);
        }
        return pointer;
    }

    public ArtifactPointer createPointer(@NotNull Artifact artifact, @NotNull ArtifactModel artifactModel) {
        if (artifact == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactPointerManagerImpl.createPointer must not be null");
        }
        if (artifactModel == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactPointerManagerImpl.createPointer must not be null");
        }
        return this.createPointer(artifactModel.getOriginalArtifact(artifact));
    }

    public void disposePointers(List<Artifact> artifacts) {
        for (Artifact artifact : artifacts) {
            this.disposePointer(artifact);
        }
    }
}

