/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonHandler;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.openapi.wm.impl.status.InlineProgressIndicator;
import com.intellij.openapi.wm.impl.status.ProcessPopup;
import com.intellij.openapi.wm.impl.status.StatusBarImpl;
import com.intellij.openapi.wm.impl.status.StatusBarPatch;
import com.intellij.openapi.wm.impl.status.StatusBarTooltipper;
import com.intellij.openapi.wm.impl.status.TextPanel;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.Alarm;
import com.intellij.util.ui.AbstractLayoutManager;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;

public class InfoAndProgressPanel
extends JPanel
implements StatusBarPatch {
    private final ProcessPopup myPopup;
    private final TextPanel myInfoPanel = new TextPanel(true, new String[0]);
    private final ArrayList<ProgressIndicatorEx> myOriginals = new ArrayList();
    private final ArrayList<TaskInfo> myInfos = new ArrayList();
    private final Map<InlineProgressIndicator, ProgressIndicatorEx> myInline2Original = new HashMap<InlineProgressIndicator, ProgressIndicatorEx>();
    private final MultiValuesMap<ProgressIndicatorEx, InlineProgressIndicator> myOriginal2Inlines = new MultiValuesMap();
    private final MergingUpdateQueue myUpdateQueue;
    private final AsyncProcessIcon myProgressIcon;
    private final Alarm myQueryAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
    private boolean myShouldClosePopupAndOnProcessFinish;
    private final CompoundBorder myCompoundBorder;

    public InfoAndProgressPanel(StatusBar statusBar) {
        this.setOpaque(false);
        Border emptyBorder = BorderFactory.createEmptyBorder(0, 2, 0, 2);
        this.myInfoPanel.setBorder(emptyBorder);
        this.myInfoPanel.setOpaque(false);
        this.myCompoundBorder = BorderFactory.createCompoundBorder(new StatusBarImpl.SeparatorBorder.Left(), new EmptyBorder(0, 2, 0, 2));
        this.myProgressIcon = new AsyncProcessIcon("Background process");
        this.myProgressIcon.setOpaque(true);
        this.myProgressIcon.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (!InfoAndProgressPanel.this.myPopup.isShowing()) {
                    InfoAndProgressPanel.this.openProcessPopup();
                } else {
                    InfoAndProgressPanel.this.hideProcessPopup();
                }
            }
        });
        this.myProgressIcon.setCursor(Cursor.getPredefinedCursor(12));
        StatusBarTooltipper.install(this, (JComponent)this.myProgressIcon, statusBar);
        this.myUpdateQueue = new MergingUpdateQueue("Progress indicator", 50, true, MergingUpdateQueue.ANY_COMPONENT);
        this.myPopup = new ProcessPopup(this);
        this.restoreEmptyStatus();
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public String updateStatusBar(Editor selected, JComponent componentSelected) {
        return ActionsBundle.message((String)"action.ShowProcessWindow.double.click", (Object[])new Object[0]);
    }

    @Override
    public void clear() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProgress(ProgressIndicatorEx original, TaskInfo info) {
        ArrayList<ProgressIndicatorEx> arrayList = this.myOriginals;
        synchronized (arrayList) {
            boolean veryFirst = this.myOriginals.isEmpty();
            this.myOriginals.add(original);
            this.myInfos.add(info);
            InlineProgressIndicator expanded = this.createInlineDelegate(info, original, false);
            InlineProgressIndicator compact = this.createInlineDelegate(info, original, true);
            this.myPopup.addIndicator(expanded);
            this.myProgressIcon.resume();
            if (veryFirst && !this.myPopup.isShowing()) {
                this.buildInInlineIndicator(compact);
            } else {
                this.buildInProcessCount();
            }
            this.runQuery();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeProgress(InlineProgressIndicator progress) {
        ArrayList<ProgressIndicatorEx> arrayList = this.myOriginals;
        synchronized (arrayList) {
            if (!this.myInline2Original.containsKey(progress)) {
                return;
            }
            boolean last = this.myOriginals.size() == 1;
            boolean beforeLast = this.myOriginals.size() == 2;
            this.myPopup.removeIndicator(progress);
            ProgressIndicatorEx original = this.removeFromMaps(progress);
            if (this.myOriginals.contains(original)) {
                return;
            }
            if (last) {
                this.restoreEmptyStatus();
                if (this.myShouldClosePopupAndOnProcessFinish) {
                    this.hideProcessPopup();
                }
            } else if (this.myPopup.isShowing() || this.myOriginals.size() > 1) {
                this.buildInProcessCount();
            } else if (beforeLast) {
                this.buildInInlineIndicator(this.createInlineDelegate(this.myInfos.get(0), this.myOriginals.get(0), true));
            } else {
                this.restoreEmptyStatus();
            }
            this.runQuery();
        }
    }

    private ProgressIndicatorEx removeFromMaps(InlineProgressIndicator progress) {
        ProgressIndicatorEx original = this.myInline2Original.get(progress);
        this.myInline2Original.remove(progress);
        this.myOriginal2Inlines.remove((Object)original, (Object)progress);
        if (this.myOriginal2Inlines.get((Object)original) == null) {
            int originalIndex = this.myOriginals.indexOf(original);
            this.myOriginals.remove(originalIndex);
            this.myInfos.remove(originalIndex);
        }
        return original;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openProcessPopup() {
        ArrayList<ProgressIndicatorEx> arrayList = this.myOriginals;
        synchronized (arrayList) {
            if (this.myPopup.isShowing()) {
                return;
            }
            if (!this.myOriginals.isEmpty()) {
                this.myShouldClosePopupAndOnProcessFinish = true;
                this.buildInProcessCount();
            } else {
                this.myShouldClosePopupAndOnProcessFinish = false;
                this.restoreEmptyStatus();
            }
            this.myPopup.show();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void hideProcessPopup() {
        ArrayList<ProgressIndicatorEx> arrayList = this.myOriginals;
        synchronized (arrayList) {
            if (!this.myPopup.isShowing()) {
                return;
            }
            if (this.myOriginals.size() == 1) {
                this.buildInInlineIndicator(this.createInlineDelegate(this.myInfos.get(0), this.myOriginals.get(0), true));
            } else if (this.myOriginals.isEmpty()) {
                this.restoreEmptyStatus();
            } else {
                this.buildInProcessCount();
            }
            this.myPopup.hide();
        }
    }

    private void buildInProcessCount() {
        this.removeAll();
        this.setLayout(new BorderLayout());
        JPanel progressCountPanel = new JPanel(new BorderLayout(0, 2));
        String processWord = this.myOriginals.size() == 1 ? " process" : " processes";
        LinkLabel label = new LinkLabel(this.myOriginals.size() + processWord + " running...", null, new LinkListener(){

            public void linkSelected(LinkLabel aSource, Object aLinkData) {
                InfoAndProgressPanel.this.triggerPopupShowing();
            }
        });
        label.setOpaque(true);
        Wrapper labelComp = new Wrapper((JComponent)label);
        progressCountPanel.add((Component)labelComp, "Center");
        this.myProgressIcon.setBorder((Border)this.myCompoundBorder);
        progressCountPanel.add((Component)this.myProgressIcon, "West");
        this.add((Component)this.myInfoPanel, "Center");
        progressCountPanel.setBorder(new EmptyBorder(0, 0, 0, 4));
        this.add((Component)progressCountPanel, "East");
        this.revalidate();
        this.repaint();
    }

    private void buildInInlineIndicator(InlineProgressIndicator inline) {
        this.removeAll();
        this.setLayout((LayoutManager)((Object)new InlineLayout()));
        this.add(this.myInfoPanel);
        JPanel inlinePanel = new JPanel(new BorderLayout());
        inline.getComponent().setBorder(new EmptyBorder(0, 0, 0, 2));
        inlinePanel.add((Component)inline.getComponent(), "Center");
        this.myProgressIcon.setBorder((Border)this.myCompoundBorder);
        inlinePanel.add((Component)this.myProgressIcon, "West");
        inline.updateProgressNow();
        this.add(inlinePanel);
        this.myInfoPanel.revalidate();
        this.myInfoPanel.repaint();
    }

    public void setText(String text) {
        this.myInfoPanel.setText(text);
    }

    public BalloonHandler notifyByBalloon(MessageType type, String htmlBody, Icon icon, HyperlinkListener listener) {
        final Balloon balloon = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(htmlBody.replace("\n", "<br>"), icon != null ? icon : type.getDefaultIcon(), type.getPopupBackground(), listener).createBalloon();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                InfoAndProgressPanel comp = InfoAndProgressPanel.this;
                if (comp.isShowing()) {
                    int offset = ((Component)comp).getHeight() / 2;
                    Point point = new Point(((Component)comp).getWidth() - offset, ((Component)comp).getHeight() - offset);
                    balloon.show(new RelativePoint((Component)comp, point), Balloon.Position.above);
                } else {
                    JRootPane rootPane = SwingUtilities.getRootPane(comp);
                    if (rootPane != null && rootPane.isShowing()) {
                        Container contentPane = rootPane.getContentPane();
                        Rectangle bounds = contentPane.getBounds();
                        Point target = UIUtil.getCenterPoint((Rectangle)bounds, (Dimension)new Dimension(1, 1));
                        target.y = bounds.height - 3;
                        balloon.show(new RelativePoint((Component)contentPane, target), Balloon.Position.above);
                    }
                }
            }
        });
        return new BalloonHandler(){

            public void hide() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        balloon.hide();
                    }
                });
            }
        };
    }

    private InlineProgressIndicator createInlineDelegate(TaskInfo info, ProgressIndicatorEx original, boolean compact) {
        Collection inlines = this.myOriginal2Inlines.get((Object)original);
        if (inlines != null) {
            for (InlineProgressIndicator eachInline : inlines) {
                if (eachInline.isCompact() != compact) continue;
                return eachInline;
            }
        }
        MyInlineProgressIndicator inline = new MyInlineProgressIndicator(compact, info, original);
        this.myInline2Original.put(inline, original);
        this.myOriginal2Inlines.put((Object)original, (Object)inline);
        if (compact) {
            inline.getComponent().addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (!InfoAndProgressPanel.this.myPopup.isShowing()) {
                        InfoAndProgressPanel.this.openProcessPopup();
                    }
                }
            });
        }
        return inline;
    }

    private void triggerPopupShowing() {
        if (this.myPopup.isShowing()) {
            this.hideProcessPopup();
        } else {
            this.openProcessPopup();
        }
    }

    private void restoreEmptyStatus() {
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.add((Component)this.myInfoPanel, "Center");
        this.myProgressIcon.setBorder((Border)this.myCompoundBorder);
        this.add((Component)this.myProgressIcon, "East");
        this.myProgressIcon.suspend();
        this.myInfoPanel.revalidate();
        this.myInfoPanel.repaint();
    }

    public boolean isProcessWindowOpen() {
        return this.myPopup.isShowing();
    }

    public void setProcessWindowOpen(boolean open) {
        if (open) {
            this.openProcessPopup();
        } else {
            this.hideProcessPopup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runQuery() {
        if (this.getRootPane() == null) {
            return;
        }
        ArrayList<ProgressIndicatorEx> arrayList = this.myOriginals;
        synchronized (arrayList) {
            for (InlineProgressIndicator each : this.myInline2Original.keySet()) {
                each.updateProgress();
            }
        }
        this.myQueryAlarm.addRequest(new Runnable(){

            @Override
            public void run() {
                InfoAndProgressPanel.this.runQuery();
            }
        }, 2000);
    }

    private class MyInlineProgressIndicator
    extends InlineProgressIndicator {
        private final ProgressIndicatorEx myOriginal;
        private final TaskInfo myTask;

        public MyInlineProgressIndicator(boolean compact, TaskInfo task, ProgressIndicatorEx original) {
            super(compact, task);
            this.myOriginal = original;
            this.myTask = task;
            original.addStateDelegate(this);
        }

        @Override
        public void cancel() {
            super.cancel();
            this.updateProgress();
        }

        @Override
        public void stop() {
            super.stop();
            this.updateProgress();
        }

        @Override
        protected boolean isFinished() {
            return this.isFinished(this.myTask);
        }

        @Override
        public void finish(@NotNull TaskInfo task) {
            if (task == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/wm/impl/status/InfoAndProgressPanel$MyInlineProgressIndicator.finish must not be null");
            }
            super.finish(task);
            this.queueRunningUpdate(new Runnable(){

                @Override
                public void run() {
                    InfoAndProgressPanel.this.removeProgress(MyInlineProgressIndicator.this);
                    MyInlineProgressIndicator.this.dispose();
                }
            });
        }

        @Override
        protected void cancelRequest() {
            this.myOriginal.cancel();
        }

        @Override
        protected void queueProgressUpdate(final Runnable update) {
            InfoAndProgressPanel.this.myUpdateQueue.queue(new Update(this, false, 1){

                public void run() {
                    ApplicationManager.getApplication().invokeLater(update);
                }
            });
        }

        @Override
        protected void queueRunningUpdate(final Runnable update) {
            InfoAndProgressPanel.this.myUpdateQueue.queue(new Update(new Object(), false, 0){

                public void run() {
                    ApplicationManager.getApplication().invokeLater(update);
                }
            });
        }
    }

    private static class InlineLayout
    extends AbstractLayoutManager {
        private InlineLayout() {
        }

        public Dimension preferredLayoutSize(Container parent) {
            Dimension result = new Dimension();
            for (int i = 0; i < parent.getComponentCount(); ++i) {
                Dimension prefSize = parent.getComponent(i).getPreferredSize();
                result.width += prefSize.width;
                result.height = Math.max(prefSize.height, result.height);
            }
            return result;
        }

        public void layoutContainer(Container parent) {
            Dimension size = parent.getSize();
            int compWidth = size.width / parent.getComponentCount();
            int eachX = 0;
            for (int i = 0; i < parent.getComponentCount(); ++i) {
                Component each = parent.getComponent(i);
                if (i == parent.getComponentCount() - 1) {
                    compWidth = size.width - eachX;
                }
                each.setBounds(eachX, 0, compWidth, size.height);
                eachX += compWidth;
            }
        }
    }
}

