/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.Painter;
import com.intellij.openapi.ui.impl.GlassPaneDialogWrapperPeer;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.impl.IdeGlassPaneEx;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.lang.ref.WeakReference;
import java.util.EventListener;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuDragMouseEvent;

public class IdeGlassPaneImpl
extends JPanel
implements IdeGlassPaneEx,
IdeEventQueue.EventDispatcher,
Painter.Listener {
    private final Set<EventListener> myMouseListeners = new LinkedHashSet<EventListener>();
    private final JRootPane myRootPane;
    private final WeakReference<Component> myCurrentOverComponent = new WeakReference<Object>(null);
    private final WeakReference<Component> myMousePressedComponent = new WeakReference<Object>(null);
    private final Set<Painter> myPainters = new LinkedHashSet<Painter>();
    private final Map<Painter, Component> myPainter2Component = new LinkedHashMap<Painter, Component>();
    private boolean myPaintingActive;
    private boolean myPreprocessorActive;

    public IdeGlassPaneImpl(JRootPane rootPane) {
        this.myRootPane = rootPane;
        this.setOpaque(false);
        this.setVisible(false);
        this.setLayout(null);
    }

    @Override
    public boolean dispatch(AWTEvent e) {
        Window thisGlassWindow;
        MouseEvent me;
        Window eventWindow;
        boolean dispatched = false;
        if (e instanceof MouseEvent && (eventWindow = (me = (MouseEvent)e).getComponent() instanceof Window ? (Window)me.getComponent() : SwingUtilities.getWindowAncestor(me.getComponent())) != (thisGlassWindow = SwingUtilities.getWindowAncestor(this.myRootPane))) {
            return false;
        }
        if (e.getID() == 501 || e.getID() == 502 || e.getID() == 500) {
            dispatched = this.preprocess((MouseEvent)e, false);
        } else if (e.getID() == 503 || e.getID() == 506) {
            dispatched = this.preprocess((MouseEvent)e, true);
        } else if (e.getID() == 505 || e.getID() == 504) {
            dispatched = this.preprocess((MouseEvent)e, false);
        } else {
            return false;
        }
        if (this.isVisible() && this.getComponentCount() == 0) {
            boolean cursorSet = false;
            MouseEvent me2 = (MouseEvent)e;
            if (me2.getComponent() != null) {
                Component target;
                Point point = SwingUtilities.convertPoint(me2.getComponent(), me2.getPoint(), this.myRootPane.getContentPane());
                if (this.myRootPane.getMenuBar() != null && this.myRootPane.getMenuBar().isVisible()) {
                    point.y += this.myRootPane.getMenuBar().getHeight();
                }
                if ((target = SwingUtilities.getDeepestComponentAt(this.myRootPane.getContentPane().getParent(), point.x, point.y)) != null) {
                    this.setCursor(target.getCursor());
                    cursorSet = true;
                }
            }
            if (!cursorSet) {
                this.setCursor(Cursor.getDefaultCursor());
            }
        }
        return dispatched;
    }

    private boolean preprocess(MouseEvent e, boolean motion) {
        MouseEvent event = this.convertEvent(e, this.myRootPane);
        for (EventListener each : this.myMouseListeners) {
            if (motion && each instanceof MouseMotionListener) {
                IdeGlassPaneImpl.fireMouseMotion((MouseMotionListener)each, event);
            } else if (!motion && each instanceof MouseListener) {
                IdeGlassPaneImpl.fireMouseEvent((MouseListener)each, event);
            }
            if (!event.isConsumed()) continue;
            return true;
        }
        return false;
    }

    private MouseEvent convertEvent(MouseEvent e, Component target) {
        Point point = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), target);
        if (e instanceof MouseWheelEvent) {
            MouseWheelEvent mwe = (MouseWheelEvent)e;
            return new MouseWheelEvent(target, mwe.getID(), mwe.getWhen(), mwe.getModifiersEx(), point.x, point.y, mwe.getClickCount(), mwe.isPopupTrigger(), mwe.getScrollType(), mwe.getScrollAmount(), mwe.getWheelRotation());
        }
        if (e instanceof MenuDragMouseEvent) {
            MenuDragMouseEvent de = (MenuDragMouseEvent)e;
            return new MenuDragMouseEvent(target, de.getID(), de.getWhen(), de.getModifiersEx(), point.x, point.y, e.getClickCount(), e.isPopupTrigger(), de.getPath(), de.getMenuSelectionManager());
        }
        return new MouseEvent(target, e.getID(), e.getWhen(), e.getModifiersEx(), point.x, point.y, e.getClickCount(), e.isPopupTrigger(), e.getButton());
    }

    private static void fireMouseEvent(MouseListener listener, MouseEvent event) {
        switch (event.getID()) {
            case 501: {
                listener.mousePressed(event);
                break;
            }
            case 502: {
                listener.mouseReleased(event);
                break;
            }
            case 504: {
                listener.mouseEntered(event);
                break;
            }
            case 505: {
                listener.mouseExited(event);
                break;
            }
            case 500: {
                listener.mouseClicked(event);
            }
        }
    }

    private static void fireMouseMotion(MouseMotionListener listener, MouseEvent event) {
        switch (event.getID()) {
            case 506: {
                listener.mouseDragged(event);
            }
            case 503: {
                listener.mouseMoved(event);
            }
        }
    }

    public void addMousePreprocessor(MouseListener listener, Disposable parent) {
        this._addListener(listener, parent);
    }

    public void addMouseMotionPreprocessor(MouseMotionListener listener, Disposable parent) {
        this._addListener(listener, parent);
    }

    private void _addListener(final EventListener listener, Disposable parent) {
        this.myMouseListeners.add(listener);
        this.activateIfNeeded();
        Disposer.register((Disposable)parent, (Disposable)new Disposable(){

            public void dispose() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        IdeGlassPaneImpl.this.removeListener(listener);
                    }
                });
            }
        });
    }

    public void removeMousePreprocessor(MouseListener listener) {
        this.removeListener(listener);
    }

    public void removeMouseMotionPreprocessor(MouseMotionListener listener) {
        this.removeListener(listener);
    }

    private void removeListener(EventListener listener) {
        this.myMouseListeners.remove(listener);
        this.deactivateIfNeeded();
    }

    private void deactivateIfNeeded() {
        if (this.myPaintingActive && this.myPainters.size() == 0 && this.getComponentCount() == 0) {
            this.myPaintingActive = false;
        }
        if (this.myPreprocessorActive && this.myMouseListeners.size() == 0) {
            this.myPreprocessorActive = false;
        }
        this.applyActivationState();
    }

    private void activateIfNeeded() {
        if (!(this.myPaintingActive || this.myPainters.size() <= 0 && this.getComponentCount() <= 0)) {
            this.myPaintingActive = true;
        }
        if (!this.myPreprocessorActive && this.myMouseListeners.size() > 0) {
            this.myPreprocessorActive = true;
        }
        this.applyActivationState();
    }

    private void applyActivationState() {
        IdeEventQueue queue;
        if (this.isVisible() != this.myPaintingActive) {
            this.setVisible(this.myPaintingActive);
        }
        if (!(queue = IdeEventQueue.getInstance()).containsDispatcher(this) && this.myPreprocessorActive) {
            queue.addDispatcher(this, null);
        } else if (queue.containsDispatcher(this) && !this.myPreprocessorActive) {
            queue.removeDispatcher(this);
        }
    }

    public void addPainter(Component component, final Painter painter, Disposable parent) {
        this.myPainters.add(painter);
        this.myPainter2Component.put(painter, component == null ? this : component);
        painter.addListener((Painter.Listener)this);
        this.activateIfNeeded();
        Disposer.register((Disposable)parent, (Disposable)new Disposable(){

            public void dispose() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        IdeGlassPaneImpl.this.removePainter(painter);
                    }
                });
            }
        });
    }

    public void removePainter(Painter painter) {
        this.myPainters.remove(painter);
        this.myPainter2Component.remove(painter);
        painter.removeListener((Painter.Listener)this);
        this.deactivateIfNeeded();
    }

    @Override
    public Component add(Component comp) {
        Component result = super.add(comp);
        this.activateIfNeeded();
        return result;
    }

    @Override
    public void remove(Component comp) {
        super.remove(comp);
        this.deactivateIfNeeded();
    }

    @Override
    public boolean isInModalContext() {
        Component[] components;
        for (Component component : components = this.getComponents()) {
            if (!(component instanceof GlassPaneDialogWrapperPeer.TransparentLayeredPane)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.myPainters.size() == 0) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        for (Painter painter : this.myPainters) {
            Rectangle clip = g.getClipBounds();
            Component component = this.myPainter2Component.get(painter);
            if (component.getParent() == null) continue;
            Rectangle componentBounds = SwingUtilities.convertRectangle(component.getParent(), component.getBounds(), this);
            if (!painter.needsRepaint() || !clip.contains(componentBounds) && !clip.intersects(componentBounds)) continue;
            Point targetPoint = SwingUtilities.convertPoint(this, 0, 0, component);
            Rectangle targetRect = new Rectangle(targetPoint, component.getSize());
            g2d.translate(-targetRect.x, -targetRect.y);
            painter.paint(component, g2d);
            g2d.translate(targetRect.x, targetRect.y);
        }
    }

    public boolean hasPainters() {
        return this.myPainters.size() > 0;
    }

    public void onNeedsRepaint(Painter painter, JComponent dirtyComponent) {
        Rectangle rec;
        if (dirtyComponent != null && dirtyComponent.isShowing() && (rec = SwingUtilities.convertRectangle(dirtyComponent, dirtyComponent.getBounds(), this)) != null) {
            this.repaint(rec);
            return;
        }
        this.repaint();
    }

    public Component getTargetComponentFor(MouseEvent e) {
        Component candidate = this.findComponent(e, this.myRootPane.getLayeredPane());
        if (candidate != null) {
            return candidate;
        }
        candidate = this.findComponent(e, this.myRootPane.getContentPane());
        if (candidate != null) {
            return candidate;
        }
        return e.getComponent();
    }

    private Component findComponent(MouseEvent e, Container container) {
        Point lpPoint = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), container);
        Component lpComponent = SwingUtilities.getDeepestComponentAt(container, lpPoint.x, lpPoint.y);
        return lpComponent;
    }
}

