/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.ex.VirtualFileManagerEx;
import com.intellij.openapi.vfs.impl.local.LocalFileSystemImpl;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.RefreshQueueImpl;
import com.intellij.openapi.vfs.newvfs.RefreshSession;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.persistent.RefreshWorker;
import com.intellij.util.concurrency.Semaphore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class RefreshSessionImpl
extends RefreshSession {
    private final boolean myIsAsync;
    private final boolean myIsRecursive;
    private final Runnable myFinishRunnable;
    private List<VirtualFile> myWorkQueue = new ArrayList<VirtualFile>();
    private List<VFileEvent> myEvents = new ArrayList<VFileEvent>();
    private final Semaphore mySemaphore = new Semaphore();
    private volatile boolean iHaveEventsToFire;

    public RefreshSessionImpl(boolean isAsync, boolean reqursively, Runnable finishRunnable) {
        this.myIsRecursive = reqursively;
        this.myFinishRunnable = finishRunnable;
        this.myIsAsync = isAsync;
    }

    public RefreshSessionImpl(List<VFileEvent> events) {
        this.myIsAsync = false;
        this.myIsRecursive = false;
        this.myFinishRunnable = null;
        this.myEvents = new ArrayList<VFileEvent>(events);
    }

    public void addAllFiles(Collection<VirtualFile> files) {
        this.myWorkQueue.addAll(files);
    }

    public void addFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/newvfs/RefreshSessionImpl.addFile must not be null");
        }
        this.myWorkQueue.add(file);
    }

    public boolean isAsynchronous() {
        return this.myIsAsync;
    }

    public void launch() {
        this.mySemaphore.down();
        ((RefreshQueueImpl)RefreshQueue.getInstance()).execute(this);
    }

    public void scan() {
        boolean hasEventsToFire;
        List<VirtualFile> workQueue = this.myWorkQueue;
        this.myWorkQueue = new ArrayList<VirtualFile>();
        boolean bl = hasEventsToFire = this.myFinishRunnable != null || !this.myEvents.isEmpty();
        if (!workQueue.isEmpty()) {
            ((LocalFileSystemImpl)LocalFileSystem.getInstance()).markSuspicousFilesDirty(workQueue);
            for (VirtualFile file : workQueue) {
                NewVirtualFile nvf = (NewVirtualFile)file;
                if (!this.myIsAsync && !this.myIsRecursive) {
                    nvf.markDirty();
                }
                RefreshWorker worker = new RefreshWorker(file, this.myIsRecursive);
                worker.scan();
                List<VFileEvent> events = worker.getEvents();
                this.myEvents.addAll(events);
                if (events.isEmpty()) continue;
                hasEventsToFire = true;
            }
        }
        this.iHaveEventsToFire = hasEventsToFire;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireEvents(boolean hasWriteAction) {
        try {
            if (!this.iHaveEventsToFire) {
                return;
            }
            if (hasWriteAction) {
                this.fireEventsInWriteAction();
            } else {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        RefreshSessionImpl.this.fireEventsInWriteAction();
                    }
                });
            }
        }
        finally {
            this.mySemaphore.up();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEventsInWriteAction() {
        VirtualFileManagerEx manager = (VirtualFileManagerEx)VirtualFileManager.getInstance();
        manager.fireBeforeRefreshStart(this.myIsAsync);
        try {
            while (!this.myWorkQueue.isEmpty() || !this.myEvents.isEmpty()) {
                ManagingFS.getInstance().processEvents(this.mergeEventsAndReset());
                this.scan();
            }
        }
        finally {
            try {
                manager.fireAfterRefreshFinish(this.myIsAsync);
            }
            finally {
                if (this.myFinishRunnable != null) {
                    this.myFinishRunnable.run();
                }
            }
        }
    }

    public void waitFor() {
        this.mySemaphore.waitFor();
    }

    private List<VFileEvent> mergeEventsAndReset() {
        LinkedHashSet<VFileEvent> mergedEvents = new LinkedHashSet<VFileEvent>(this.myEvents);
        ArrayList<VFileEvent> events = new ArrayList<VFileEvent>(mergedEvents);
        this.myEvents = new ArrayList<VFileEvent>();
        return events;
    }
}

