/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.http;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.impl.http.FileDownloadingAdapter;
import com.intellij.openapi.vfs.impl.http.HttpFileSystemImpl;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFile;
import com.intellij.openapi.vfs.impl.http.RemoteFileInfo;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.ArrayUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class VirtualFileImpl
extends HttpVirtualFile {
    private final HttpFileSystemImpl myFileSystem;
    @Nullable
    private final RemoteFileInfo myFileInfo;
    private FileType myInitialFileType;
    private final String myPath;
    private final String myParentPath;
    private final String myName;

    VirtualFileImpl(HttpFileSystemImpl fileSystem, String path, @Nullable RemoteFileInfo fileInfo) {
        this.myFileSystem = fileSystem;
        this.myPath = path;
        this.myFileInfo = fileInfo;
        if (this.myFileInfo != null) {
            int lastSlash;
            this.myFileInfo.addDownloadingListener(new FileDownloadingAdapter(){

                @Override
                public void fileDownloaded(final VirtualFile localFile) {
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            VirtualFileImpl file = VirtualFileImpl.this;
                            FileDocumentManager.getInstance().reloadFiles(new VirtualFile[]{file});
                            if (!localFile.getFileType().equals(VirtualFileImpl.this.myInitialFileType)) {
                                VFilePropertyChangeEvent event = new VFilePropertyChangeEvent((Object)this, (VirtualFile)file, "name", (Object)file.getName(), (Object)file.getName(), false);
                                BulkFileListener publisher = (BulkFileListener)ApplicationManager.getApplication().getMessageBus().asyncPublisher(VirtualFileManager.VFS_CHANGES);
                                publisher.after(Collections.singletonList(event));
                            }
                        }
                    });
                }
            });
            int end = path.indexOf("?");
            if (end != -1) {
                path = path.substring(0, end);
            }
            if ((lastSlash = (path = StringUtil.trimEnd((String)path, (String)"/")).lastIndexOf(47)) == -1) {
                this.myParentPath = null;
                this.myName = path;
            } else {
                this.myParentPath = path.substring(0, lastSlash);
                this.myName = path.substring(lastSlash + 1);
            }
        } else {
            int lastSlash = path.lastIndexOf(47);
            if (lastSlash == path.length() - 1) {
                this.myParentPath = null;
                this.myName = path;
            } else {
                int prevSlash = path.lastIndexOf(47, lastSlash - 1);
                if (prevSlash < 0) {
                    this.myParentPath = path.substring(0, lastSlash + 1);
                    this.myName = path.substring(lastSlash + 1);
                } else {
                    this.myParentPath = path.substring(0, lastSlash);
                    this.myName = path.substring(lastSlash + 1);
                }
            }
        }
    }

    @Override
    @Nullable
    public RemoteFileInfo getFileInfo() {
        return this.myFileInfo;
    }

    @NotNull
    public VirtualFileSystem getFileSystem() {
        HttpFileSystemImpl httpFileSystemImpl = this.myFileSystem;
        if (httpFileSystemImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/impl/http/VirtualFileImpl.getFileSystem must not return null");
        }
        return httpFileSystemImpl;
    }

    public String getPath() {
        return this.myPath;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/impl/http/VirtualFileImpl.getName must not return null");
        }
        return string;
    }

    public VirtualFile getParent() {
        if (this.myParentPath == null) {
            return null;
        }
        return this.myFileSystem.findFileByPath(this.myParentPath, true);
    }

    public boolean isWritable() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public boolean isDirectory() {
        return this.myFileInfo == null;
    }

    public VirtualFile[] getChildren() {
        if (this.myFileInfo == null) {
            return EMPTY_ARRAY;
        }
        throw new UnsupportedOperationException();
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public FileType getFileType() {
        FileType fileType;
        if (this.myFileInfo == null) {
            fileType = super.getFileType();
            if (fileType == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/impl/http/VirtualFileImpl.getFileType must not return null");
            return fileType;
        }
        VirtualFile localFile = this.myFileInfo.getLocalFile();
        if (localFile != null) {
            fileType = localFile.getFileType();
            if (fileType == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/impl/http/VirtualFileImpl.getFileType must not return null");
            return fileType;
        }
        FileType fileType2 = super.getFileType();
        if (this.myInitialFileType == null) {
            this.myInitialFileType = fileType2;
        }
        if ((fileType = fileType2) != null) return fileType;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/impl/http/VirtualFileImpl.getFileType must not return null");
    }

    public InputStream getInputStream() throws IOException {
        VirtualFile localFile;
        if (this.myFileInfo != null && (localFile = this.myFileInfo.getLocalFile()) != null) {
            return localFile.getInputStream();
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    public OutputStream getOutputStream(Object requestor, long newModificationStamp, long newTimeStamp) throws IOException {
        VirtualFile localFile;
        if (this.myFileInfo != null && (localFile = this.myFileInfo.getLocalFile()) != null) {
            OutputStream outputStream = localFile.getOutputStream(requestor, newModificationStamp, newTimeStamp);
            if (outputStream == null) {
                throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/impl/http/VirtualFileImpl.getOutputStream must not return null");
            }
            return outputStream;
        }
        throw new UnsupportedOperationException();
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public byte[] contentsToByteArray() throws IOException {
        byte[] byArray;
        if (this.myFileInfo == null) {
            throw new UnsupportedOperationException();
        }
        VirtualFile localFile = this.myFileInfo.getLocalFile();
        if (localFile != null) {
            byArray = localFile.contentsToByteArray();
            if (byArray == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/impl/http/VirtualFileImpl.contentsToByteArray must not return null");
            return byArray;
        }
        byArray = ArrayUtil.EMPTY_BYTE_ARRAY;
        if (ArrayUtil.EMPTY_BYTE_ARRAY != null) return byArray;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/impl/http/VirtualFileImpl.contentsToByteArray must not return null");
    }

    public long getTimeStamp() {
        return 0L;
    }

    public long getModificationStamp() {
        return 0L;
    }

    public long getLength() {
        return -1L;
    }

    public void refresh(boolean asynchronous, boolean recursive, Runnable postRunnable) {
        if (this.myFileInfo != null) {
            this.myFileInfo.refresh(postRunnable);
        } else if (postRunnable != null) {
            postRunnable.run();
        }
    }
}

