/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.update;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vcs.update.FileOrDirectoryTreeNode;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleTextAttributes;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;

public class DirectoryTreeNode
extends FileOrDirectoryTreeNode {
    private static final Icon OPEN_ICON = IconLoader.getIcon((String)"/nodes/folderOpen.png");
    private static final Icon COLLAPSED_ICON = IconLoader.getIcon((String)"/nodes/folder.png");

    public DirectoryTreeNode(String path, Project project, String parentPath) {
        super(path, SimpleTextAttributes.ERROR_ATTRIBUTES, project, parentPath);
    }

    @Override
    protected int getItemsCount() {
        int result = 0;
        for (int i = 0; i < this.getChildCount(); ++i) {
            result += ((FileOrDirectoryTreeNode)this.getChildAt(i)).getItemsCount();
        }
        return result;
    }

    @Override
    protected boolean showStatistics() {
        return true;
    }

    @Override
    public Icon getIcon(boolean expanded) {
        return expanded ? OPEN_ICON : COLLAPSED_ICON;
    }

    @Override
    public Collection<VirtualFile> getVirtualFiles() {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (int i = 0; i < this.getChildCount(); ++i) {
            FileOrDirectoryTreeNode child = (FileOrDirectoryTreeNode)this.getChildAt(i);
            result.addAll(child.getVirtualFiles());
        }
        return result;
    }

    @Override
    public Collection<File> getFiles() {
        ArrayList<File> result = new ArrayList<File>();
        for (int i = 0; i < this.getChildCount(); ++i) {
            FileOrDirectoryTreeNode child = (FileOrDirectoryTreeNode)this.getChildAt(i);
            result.addAll(child.getFiles());
        }
        return result;
    }
}

