/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.CommonBundle;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.committed.AbstractCalledLater;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesBrowser;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesTableModel;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.util.AsynchConsumer;
import java.awt.Component;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;

public class ChangesBrowserDialog
extends DialogWrapper {
    private Project myProject;
    private CommittedChangesTableModel myChanges;
    private Mode myMode;
    private CommittedChangesBrowser myCommittedChangesBrowser;
    private AsynchConsumer<List<CommittedChangeList>> myAppender;

    public ChangesBrowserDialog(Project project, CommittedChangesTableModel changes, Mode mode) {
        super(project, true);
        this.initDialog(project, changes, mode);
    }

    public ChangesBrowserDialog(Project project, Component parent, CommittedChangesTableModel changes, Mode mode) {
        super(parent, true);
        this.initDialog(project, changes, mode);
    }

    private void initDialog(Project project, CommittedChangesTableModel changes, Mode mode) {
        this.myProject = project;
        this.myChanges = changes;
        this.myMode = mode;
        this.setTitle(VcsBundle.message((String)"dialog.title.changes.browser", (Object[])new Object[0]));
        this.setCancelButtonText(CommonBundle.getCloseButtonText());
        ModalityState currentState = ModalityState.current();
        if (mode != Mode.Choose && ModalityState.NON_MODAL.equals(currentState)) {
            this.setModal(false);
        }
        this.myAppender = new AsynchConsumer<List<CommittedChangeList>>(){

            public void finished() {
                new AbstractCalledLater(ChangesBrowserDialog.this.myProject, ModalityState.stateForComponent((Component)ChangesBrowserDialog.this.myCommittedChangesBrowser)){

                    @Override
                    public void run() {
                        ChangesBrowserDialog.this.myCommittedChangesBrowser.stopLoading();
                    }
                }.callMe();
            }

            public void consume(final List<CommittedChangeList> committedChangeLists) {
                new AbstractCalledLater(ChangesBrowserDialog.this.myProject, ModalityState.stateForComponent((Component)ChangesBrowserDialog.this.myCommittedChangesBrowser)){

                    @Override
                    public void run() {
                        boolean selectFirst = ChangesBrowserDialog.this.myChanges.getRowCount() == 0 && !committedChangeLists.isEmpty();
                        ChangesBrowserDialog.this.myChanges.addRows(committedChangeLists);
                        if (selectFirst) {
                            ChangesBrowserDialog.this.myCommittedChangesBrowser.selectFirstIfAny();
                        } else {
                            ChangesBrowserDialog.this.myCommittedChangesBrowser.resortKeepSelection();
                        }
                    }
                }.callMe();
            }
        };
        this.init();
    }

    public AsynchConsumer<List<CommittedChangeList>> getAppender() {
        return this.myAppender;
    }

    public void startLoading() {
        this.myCommittedChangesBrowser.startLoading();
    }

    protected String getDimensionServiceKey() {
        return "VCS.ChangesBrowserDialog";
    }

    protected JComponent createCenterPanel() {
        this.myCommittedChangesBrowser = new CommittedChangesBrowser(this.myProject, this.myChanges);
        return this.myCommittedChangesBrowser;
    }

    protected void dispose() {
        super.dispose();
        this.myCommittedChangesBrowser.dispose();
    }

    protected void createDefaultActions() {
        super.createDefaultActions();
        if (this.myMode == Mode.Browse) {
            this.getOKAction().putValue("Name", VcsBundle.message((String)"button.search.again", (Object[])new Object[0]));
        }
    }

    protected Action[] createActions() {
        if (this.myMode == Mode.Simple) {
            return new Action[]{this.getCancelAction()};
        }
        return super.createActions();
    }

    public CommittedChangeList getSelectedChangeList() {
        return this.myCommittedChangesBrowser.getSelectedChangeList();
    }

    public static enum Mode {
        Simple,
        Browse,
        Choose;

    }
}

