/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.RepositoryHelper;
import com.intellij.ide.startup.StartupActionScriptManager;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.UrlConnectionUtil;
import com.intellij.util.io.ZipUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class PluginDownloader {
    private static final Logger LOG = Logger.getInstance((String)("#" + PluginDownloader.class.getName()));
    @NonNls
    private static final String FILENAME = "filename=";
    private final String myPluginId;
    private final String myPluginUrl;
    private String myPluginVersion;
    private String myFileName;
    private String myPluginName;
    private File myFile;
    private File myOldFile;

    public PluginDownloader(String pluginId, String pluginUrl, String pluginVersion) {
        this.myPluginId = pluginId;
        this.myPluginUrl = pluginUrl;
        this.myPluginVersion = pluginVersion;
    }

    public PluginDownloader(String pluginId, String pluginUrl, String pluginVersion, String fileName, String pluginName) {
        this.myPluginId = pluginId;
        this.myPluginUrl = pluginUrl;
        this.myPluginVersion = pluginVersion;
        this.myFileName = fileName;
        this.myPluginName = pluginName;
    }

    public boolean prepareToInstall() throws IOException {
        return this.prepareToInstall(new ProgressIndicatorBase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean prepareToInstall(ProgressIndicator pi) throws IOException {
        IdeaPluginDescriptor ideaPluginDescriptor = null;
        if (PluginManager.isPluginInstalled((PluginId)PluginId.getId((String)this.myPluginId))) {
            ideaPluginDescriptor = PluginManager.getPlugin((PluginId)PluginId.getId((String)this.myPluginId));
            LOG.assertTrue(ideaPluginDescriptor != null);
            if (this.myPluginVersion != null && StringUtil.compareVersionNumbers((String)ideaPluginDescriptor.getVersion(), (String)this.myPluginVersion) >= 0) {
                LOG.info("Plugin " + this.myPluginId + ": current version (max) " + this.myPluginVersion);
                return false;
            }
            this.myOldFile = ideaPluginDescriptor.getPath();
        }
        String errorMessage = IdeBundle.message((String)"unknown.error", (Object[])new Object[0]);
        try {
            this.myFile = this.downloadPlugin(pi);
        }
        catch (IOException ex) {
            this.myFile = null;
            errorMessage = ex.getMessage();
        }
        if (this.myFile == null) {
            final String errorMessage1 = errorMessage;
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    Messages.showErrorDialog((String)IdeBundle.message((String)"error.plugin.was.not.installed", (Object[])new Object[]{PluginDownloader.this.getPluginName(), errorMessage1}), (String)IdeBundle.message((String)"title.failed.to.download", (Object[])new Object[0]));
                }
            });
            return false;
        }
        IdeaPluginDescriptorImpl descriptor = PluginManager.loadDescriptorFromJar((File)this.myFile);
        if (descriptor == null && this.myFile.getName().endsWith(".zip")) {
            File outputDir = FileUtil.createTempDirectory((String)"plugin", (String)"");
            try {
                ZipUtil.extract((File)this.myFile, (File)outputDir, (FilenameFilter)new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return true;
                    }
                });
                descriptor = PluginManager.loadDescriptor((File)new File(outputDir, FileUtil.getNameWithoutExtension((File)this.myFile)), (String)"plugin.xml");
            }
            finally {
                FileUtil.delete((File)outputDir);
            }
        }
        if (descriptor != null) {
            this.myPluginVersion = descriptor.getVersion();
            if (ideaPluginDescriptor != null && StringUtil.compareVersionNumbers((String)ideaPluginDescriptor.getVersion(), (String)descriptor.getVersion()) >= 0) {
                LOG.info("Plugin " + this.myPluginId + ": current version (max) " + this.myPluginVersion);
                return false;
            }
        }
        return true;
    }

    public void install() throws IOException {
        LOG.assertTrue(this.myFile != null);
        if (this.myOldFile != null) {
            StartupActionScriptManager.DeleteCommand deleteOld = new StartupActionScriptManager.DeleteCommand(this.myOldFile);
            StartupActionScriptManager.addActionCommand((StartupActionScriptManager.ActionCommand)deleteOld);
        }
        if (this.myFile.getName().endsWith(".jar")) {
            StartupActionScriptManager.CopyCommand copyPlugin = new StartupActionScriptManager.CopyCommand(this.myFile, new File(PathManager.getPluginsPath() + File.separator + this.myFile.getName()));
            StartupActionScriptManager.addActionCommand((StartupActionScriptManager.ActionCommand)copyPlugin);
        } else {
            String unzipPath = ZipUtil.isZipContainsFolder((File)this.myFile) ? PathManager.getPluginsPath() : PathManager.getPluginsPath() + File.separator + this.getPluginName();
            StartupActionScriptManager.UnzipCommand unzip = new StartupActionScriptManager.UnzipCommand(this.myFile, new File(unzipPath));
            StartupActionScriptManager.addActionCommand((StartupActionScriptManager.ActionCommand)unzip);
        }
        StartupActionScriptManager.DeleteCommand deleteTemp = new StartupActionScriptManager.DeleteCommand(this.myFile);
        StartupActionScriptManager.addActionCommand((StartupActionScriptManager.ActionCommand)deleteTemp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File downloadPlugin(ProgressIndicator pi) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)new URL(this.myPluginUrl).openConnection();
        try {
            pi.setText(IdeBundle.message((String)"progress.connecting", (Object[])new Object[0]));
            InputStream is = UrlConnectionUtil.getConnectionInputStream(connection, pi);
            if (is == null) {
                throw new IOException("Failed to open connection");
            }
            pi.setText(IdeBundle.message((String)"progress.downloading.plugin", (Object[])new Object[]{this.getPluginName()}));
            File pluginsTemp = new File(PathManager.getPluginTempPath());
            if (!pluginsTemp.exists()) {
                pluginsTemp.mkdirs();
            }
            File file = File.createTempFile("plugin", "download", pluginsTemp);
            int responseCode = connection.getResponseCode();
            switch (responseCode) {
                case 200: {
                    break;
                }
                default: {
                    throw new IOException(IdeBundle.message((String)"error.connection.failed.with.http.code.N", (Object[])new Object[]{responseCode}));
                }
            }
            pi.setIndeterminate(connection.getContentLength() == -1);
            OutputStream fos = null;
            try {
                fos = new BufferedOutputStream(new FileOutputStream(file, false));
                StreamUtil.copyStreamContent((InputStream)is, (OutputStream)fos);
            }
            finally {
                if (fos != null) {
                    fos.close();
                }
                is.close();
            }
            if (this.myFileName == null) {
                String contentDisposition = connection.getHeaderField("Content-Disposition");
                if (contentDisposition == null || contentDisposition.indexOf(FILENAME) < 0) {
                    String usedURL = connection.getURL().toString();
                    int startPos = usedURL.lastIndexOf("/");
                    this.myFileName = usedURL.substring(startPos + 1);
                    if (this.myFileName.length() == 0 || this.myFileName.contains("?")) {
                        this.myFileName = this.myPluginUrl.substring(this.myPluginUrl.lastIndexOf("/") + 1);
                    }
                } else {
                    int startIdx = contentDisposition.indexOf(FILENAME);
                    this.myFileName = contentDisposition.substring(startIdx + FILENAME.length(), contentDisposition.length());
                    if (this.myFileName.startsWith("\"") && this.myFileName.endsWith("\"")) {
                        this.myFileName = this.myFileName.substring(1, this.myFileName.length() - 1);
                    }
                    if (this.myFileName.indexOf(92) >= 0 || this.myFileName.indexOf(47) >= 0 || this.myFileName.indexOf(File.separatorChar) >= 0 || this.myFileName.indexOf(34) >= 0) {
                        FileUtil.delete((File)file);
                        throw new IOException("Invalid filename returned by server");
                    }
                }
            }
            File newFile = new File(file.getParentFile(), this.myFileName);
            FileUtil.rename((File)file, (File)newFile);
            File file2 = newFile;
            return file2;
        }
        finally {
            connection.disconnect();
        }
    }

    public String getPluginId() {
        return this.myPluginId;
    }

    public String getFileName() {
        if (this.myFileName == null) {
            this.myFileName = this.myPluginUrl.substring(this.myPluginUrl.lastIndexOf("/") + 1);
        }
        return this.myFileName;
    }

    public String getPluginName() {
        if (this.myPluginName == null) {
            this.myPluginName = FileUtil.getNameWithoutExtension((String)this.getFileName());
        }
        return this.myPluginName;
    }

    public String getPluginVersion() {
        return this.myPluginVersion;
    }

    public static void updateFromRepository(String pluginId, @Nullable String pluginVersion) throws IOException {
        String url = RepositoryHelper.DOWNLOAD_URL + URLEncoder.encode(pluginId, "UTF8") + "&build=" + ApplicationInfo.getInstance().getBuild().asString();
        PluginDownloader downloader = new PluginDownloader(pluginId, url, pluginVersion);
        if (downloader.prepareToInstall()) {
            downloader.install();
        }
    }
}

