/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.LibrarySourceItem;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.ModuleGroupItem;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.ModuleOutputSourceItem;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.ModuleSourceItemGroup;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.elements.FileCopyPackagingElement;
import com.intellij.packaging.impl.elements.ModuleOutputElementType;
import com.intellij.packaging.impl.elements.ModuleOutputPackagingElement;
import com.intellij.packaging.impl.elements.PackagingElementFactoryImpl;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.PackagingSourceItem;
import com.intellij.packaging.ui.PackagingSourceItemsProvider;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ModulesAndLibrariesSourceItemsProvider
extends PackagingSourceItemsProvider {
    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Collection<? extends PackagingSourceItem> getSourceItems(@NotNull ArtifactEditorContext editorContext, @NotNull Artifact artifact, PackagingSourceItem parent) {
        Collection<? extends PackagingSourceItem> collection;
        if (editorContext == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/ModulesAndLibrariesSourceItemsProvider.getSourceItems must not be null");
        }
        if (artifact == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/ModulesAndLibrariesSourceItemsProvider.getSourceItems must not be null");
        }
        if (parent == null) {
            collection = ModulesAndLibrariesSourceItemsProvider.createModuleItems(editorContext, artifact, ArrayUtil.EMPTY_STRING_ARRAY);
            if (collection == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/ModulesAndLibrariesSourceItemsProvider.getSourceItems must not return null");
            return collection;
        }
        if (parent instanceof ModuleGroupItem) {
            collection = ModulesAndLibrariesSourceItemsProvider.createModuleItems(editorContext, artifact, ((ModuleGroupItem)parent).getPath());
            if (collection == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/ModulesAndLibrariesSourceItemsProvider.getSourceItems must not return null");
            return collection;
        }
        if (parent instanceof ModuleSourceItemGroup) {
            collection = ModulesAndLibrariesSourceItemsProvider.createClasspathItems(editorContext, artifact, ((ModuleSourceItemGroup)parent).getModule());
            if (collection == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/ModulesAndLibrariesSourceItemsProvider.getSourceItems must not return null");
            return collection;
        }
        collection = Collections.emptyList();
        if (collection != null) return collection;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/ModulesAndLibrariesSourceItemsProvider.getSourceItems must not return null");
    }

    private static Collection<? extends PackagingSourceItem> createClasspathItems(ArtifactEditorContext editorContext, Artifact artifact, @NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/ModulesAndLibrariesSourceItemsProvider.createClasspathItems must not be null");
        }
        ArrayList<PackagingSourceItem> items = new ArrayList<PackagingSourceItem>();
        ModuleRootModel rootModel = editorContext.getModulesProvider().getRootModel(module);
        ArrayList<Library> libraries = new ArrayList<Library>();
        for (OrderEntry orderEntry : rootModel.getOrderEntries()) {
            if (!(orderEntry instanceof LibraryOrderEntry)) continue;
            LibraryOrderEntry libraryEntry = (LibraryOrderEntry)orderEntry;
            Library library = libraryEntry.getLibrary();
            DependencyScope scope = libraryEntry.getScope();
            if (library == null || scope == DependencyScope.TEST || scope == DependencyScope.PROVIDED) continue;
            libraries.add(library);
        }
        for (Module module2 : ModulesAndLibrariesSourceItemsProvider.getNotAddedModules(editorContext, artifact, module)) {
            items.add(new ModuleOutputSourceItem(module2));
        }
        for (Library library : ModulesAndLibrariesSourceItemsProvider.getNotAddedLibraries(editorContext, artifact, libraries)) {
            items.add(new LibrarySourceItem(library));
        }
        return items;
    }

    private static Collection<? extends PackagingSourceItem> createModuleItems(ArtifactEditorContext editorContext, Artifact artifact, @NotNull String[] groupPath) {
        if (groupPath == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/ModulesAndLibrariesSourceItemsProvider.createModuleItems must not be null");
        }
        Module[] modules = editorContext.getModulesProvider().getModules();
        ArrayList<PackagingSourceItem> items = new ArrayList<PackagingSourceItem>();
        HashSet<Object> groups = new HashSet<Object>();
        for (Module module : modules) {
            Object[] path = ModuleManager.getInstance((Project)editorContext.getProject()).getModuleGroupPath(module);
            if (path == null) {
                path = ArrayUtil.EMPTY_STRING_ARRAY;
            }
            if (Comparing.equal((Object[])path, (Object[])groupPath)) {
                items.add(new ModuleSourceItemGroup(module));
                continue;
            }
            if (!ArrayUtil.startsWith((Object[])path, (Object[])groupPath)) continue;
            groups.add(path[groupPath.length]);
        }
        for (String string : groups) {
            items.add(0, new ModuleGroupItem((String[])ArrayUtil.append((Object[])groupPath, (Object)string)));
        }
        return items;
    }

    @NotNull
    private static List<? extends Module> getNotAddedModules(final @NotNull ArtifactEditorContext context, @NotNull Artifact artifact, Module ... allModules) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/ModulesAndLibrariesSourceItemsProvider.getNotAddedModules must not be null");
        }
        if (artifact == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/ModulesAndLibrariesSourceItemsProvider.getNotAddedModules must not be null");
        }
        final HashSet<Module> modules = new HashSet<Module>(Arrays.asList(allModules));
        ArtifactUtil.processPackagingElements(artifact, ModuleOutputElementType.MODULE_OUTPUT_ELEMENT_TYPE, new Processor<ModuleOutputPackagingElement>(){

            public boolean process(ModuleOutputPackagingElement moduleOutputPackagingElement) {
                modules.remove(moduleOutputPackagingElement.findModule((PackagingElementResolvingContext)context));
                return true;
            }
        }, (PackagingElementResolvingContext)context, true);
        ArrayList<Module> arrayList = new ArrayList<Module>(modules);
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/ModulesAndLibrariesSourceItemsProvider.getNotAddedModules must not return null");
        }
        return arrayList;
    }

    private static List<? extends Library> getNotAddedLibraries(@NotNull ArtifactEditorContext context, @NotNull Artifact artifact, List<Library> librariesList) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/ModulesAndLibrariesSourceItemsProvider.getNotAddedLibraries must not be null");
        }
        if (artifact == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/ModulesAndLibrariesSourceItemsProvider.getNotAddedLibraries must not be null");
        }
        final HashSet roots = new HashSet();
        ArtifactUtil.processPackagingElements(artifact, PackagingElementFactoryImpl.FILE_COPY_ELEMENT_TYPE, new Processor<FileCopyPackagingElement>(){

            public boolean process(FileCopyPackagingElement fileCopyPackagingElement) {
                VirtualFile root = fileCopyPackagingElement.getLibraryRoot();
                if (root != null) {
                    roots.add(root);
                }
                return true;
            }
        }, (PackagingElementResolvingContext)context, true);
        ArrayList<Library> result = new ArrayList<Library>();
        for (Library library : librariesList) {
            if (roots.containsAll(Arrays.asList(library.getFiles(OrderRootType.CLASSES)))) continue;
            result.add(library);
        }
        return result;
    }
}

