/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleComponent;
import com.intellij.openapi.module.ModuleConfigurationEditor;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ui.configuration.ClasspathEditor;
import com.intellij.openapi.roots.ui.configuration.ContentEntriesEditor;
import com.intellij.openapi.roots.ui.configuration.ModuleConfigurationEditorProvider;
import com.intellij.openapi.roots.ui.configuration.ModuleConfigurationState;
import com.intellij.openapi.roots.ui.configuration.ModuleElementsEditor;
import com.intellij.openapi.roots.ui.configuration.OutputEditor;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class DefaultModuleEditorsProvider
implements ModuleComponent,
ModuleConfigurationEditorProvider {
    @NotNull
    public String getComponentName() {
        if ("DefaultModuleEditorsProvider" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/ui/configuration/DefaultModuleEditorsProvider.getComponentName must not return null");
        }
        return "DefaultModuleEditorsProvider";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    public void projectOpened() {
    }

    public void projectClosed() {
    }

    public void moduleAdded() {
    }

    public ModuleConfigurationEditor[] createEditors(ModuleConfigurationState state) {
        ModifiableRootModel rootModel = state.getRootModel();
        Module module = rootModel.getModule();
        String moduleName = module.getName();
        ArrayList<ModuleElementsEditor> editors = new ArrayList<ModuleElementsEditor>();
        editors.add(new ContentEntriesEditor(moduleName, state));
        editors.add(new OutputEditor(state));
        editors.add(new ClasspathEditor(state));
        return editors.toArray(new ModuleConfigurationEditor[editors.size()]);
    }
}

