/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.AppTopics;
import com.intellij.ProjectTopics;
import com.intellij.ide.caches.CacheUpdater;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationAdapter;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.components.impl.stores.BatchUpdateListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileTypeEvent;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.impl.ModuleImpl;
import com.intellij.openapi.module.impl.scopes.JdkScope;
import com.intellij.openapi.module.impl.scopes.LibraryRuntimeClasspathScope;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.DumbServiceImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectExtension;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.RootProvider;
import com.intellij.openapi.roots.WatchedRootsProvider;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.roots.impl.ModuleRootEventImpl;
import com.intellij.openapi.roots.impl.ModuleRootManagerImpl;
import com.intellij.openapi.roots.impl.ProjectFileIndexImpl;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileManagerListener;
import com.intellij.openapi.vfs.ex.VirtualFileManagerAdapter;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerListener;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ConcurrentHashMap;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ProjectRootManagerImpl
extends ProjectRootManagerEx
implements ProjectComponent,
JDOMExternalizable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.projectRoots.impl.ProjectRootManagerImpl");
    @NonNls
    private static final String PROJECT_JDK_NAME_ATTR = "project-jdk-name";
    @NonNls
    private static final String PROJECT_JDK_TYPE_ATTR = "project-jdk-type";
    private final ProjectEx myProject;
    private final ProjectFileIndex myProjectFileIndex;
    private final EventDispatcher<ProjectRootManagerEx.ProjectJdkListener> myProjectJdkEventDispatcher = EventDispatcher.create(ProjectRootManagerEx.ProjectJdkListener.class);
    private final MyVirtualFilePointerListener myVirtualFilePointerListener = new MyVirtualFilePointerListener();
    private ApplicationListener myApplicationListener;
    private String myProjectJdkName;
    private String myProjectJdkType;
    private final List<CacheUpdater> myRootsChangeUpdaters = new ArrayList<CacheUpdater>();
    private final List<CacheUpdater> myRefreshCacheUpdaters = new ArrayList<CacheUpdater>();
    private long myModificationCount = 0L;
    private Set<LocalFileSystem.WatchRequest> myRootsToWatch = new HashSet();
    @NonNls
    private static final String ATTRIBUTE_VERSION = "version";
    private final Map<List<Module>, GlobalSearchScope> myLibraryScopes = new ConcurrentHashMap();
    private final Map<String, GlobalSearchScope> myJdkScopes = new HashMap();
    private boolean myStartupActivityPerformed = false;
    private final MessageBusConnection myConnection;
    private final VirtualFileManagerAdapter myVFSListener;
    private final BatchUpdateListener myHandler;
    private final StartupManager myStartupManager;
    private final BatchSession myRootsChanged = new BatchSession(false);
    private final BatchSession myFileTypesChanged = new BatchSession(true);
    private final Map<ModuleRootListener, MessageBusConnection> myListenerAdapters = new HashMap();
    private boolean myMergedCallStarted = false;
    private boolean myMergedCallHasRootChange = false;
    private int myRootsChangesDepth = 0;
    private boolean isFiringEvent = false;
    private int myInsideRefresh = 0;
    private boolean myPointerChangesDetected = false;
    private final Map<LibraryTable, LibraryTableMultilistener> myLibraryTableMultilisteners = new HashMap();
    private JdkTableMultilistener myJdkTableMultilistener = null;
    private final Map<RootProvider, RootSetChangedMulticaster> myRegisteredRootProviderListeners = new HashMap();

    public static ProjectRootManagerImpl getInstanceImpl(Project project) {
        return (ProjectRootManagerImpl)ProjectRootManagerImpl.getInstance((Project)project);
    }

    public ProjectRootManagerImpl(Project project, FileTypeManager fileTypeManager, DirectoryIndex directoryIndex, StartupManager startupManager) {
        this.myStartupManager = startupManager;
        this.myProject = (ProjectEx)project;
        this.myConnection = project.getMessageBus().connect();
        this.myConnection.subscribe(AppTopics.FILE_TYPES, (Object)new FileTypeListener(){

            public void beforeFileTypesChanged(FileTypeEvent event) {
                ProjectRootManagerImpl.this.beforeRootsChange(true);
            }

            public void fileTypesChanged(FileTypeEvent event) {
                ProjectRootManagerImpl.this.rootsChanged(true);
            }
        });
        this.myVFSListener = new VirtualFileManagerAdapter(){

            @Override
            public void afterRefreshFinish(boolean asynchonous) {
                ProjectRootManagerImpl.this.doUpdateOnRefresh();
            }
        };
        VirtualFileManager.getInstance().addVirtualFileManagerListener((VirtualFileManagerListener)this.myVFSListener);
        this.myProjectFileIndex = new ProjectFileIndexImpl(this.myProject, directoryIndex, fileTypeManager);
        startupManager.registerStartupActivity(new Runnable(){

            @Override
            public void run() {
                ProjectRootManagerImpl.this.myStartupActivityPerformed = true;
            }
        });
        this.myHandler = new BatchUpdateListener(){

            @Override
            public void onBatchUpdateStarted() {
                ProjectRootManagerImpl.this.myRootsChanged.levelUp();
                ProjectRootManagerImpl.this.myFileTypesChanged.levelUp();
            }

            @Override
            public void onBatchUpdateFinished() {
                ProjectRootManagerImpl.this.myRootsChanged.levelDown();
                ProjectRootManagerImpl.this.myFileTypesChanged.levelDown();
            }
        };
    }

    @Override
    public void registerRootsChangeUpdater(CacheUpdater updater) {
        this.myRootsChangeUpdaters.add(updater);
    }

    @Override
    public void unregisterRootsChangeUpdater(CacheUpdater updater) {
        boolean removed = this.myRootsChangeUpdaters.remove(updater);
        LOG.assertTrue(removed);
    }

    @Override
    public void registerRefreshUpdater(CacheUpdater updater) {
        this.myRefreshCacheUpdaters.add(updater);
    }

    @Override
    public void unregisterRefreshUpdater(CacheUpdater updater) {
        boolean removed = this.myRefreshCacheUpdaters.remove(updater);
        LOG.assertTrue(removed);
    }

    public void multiCommit(ModifiableRootModel[] rootModels) {
        ModuleRootManagerImpl.multiCommit(rootModels, ModuleManager.getInstance((Project)this.myProject).getModifiableModel());
    }

    public void multiCommit(ModifiableModuleModel moduleModel, ModifiableRootModel[] rootModels) {
        ModuleRootManagerImpl.multiCommit(rootModels, moduleModel);
    }

    public VirtualFilePointerListener getVirtualFilePointerListener() {
        return this.myVirtualFilePointerListener;
    }

    @NotNull
    public ProjectFileIndex getFileIndex() {
        ProjectFileIndex projectFileIndex = this.myProjectFileIndex;
        if (projectFileIndex == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/ProjectRootManagerImpl.getFileIndex must not return null");
        }
        return projectFileIndex;
    }

    public void addModuleRootListener(ModuleRootListener listener) {
        MessageBusConnection connection = this.myProject.getMessageBus().connect();
        this.myListenerAdapters.put(listener, connection);
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)listener);
    }

    public void addModuleRootListener(ModuleRootListener listener, Disposable parentDisposable) {
        MessageBusConnection connection = this.myProject.getMessageBus().connect(parentDisposable);
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)listener);
    }

    public void removeModuleRootListener(ModuleRootListener listener) {
        MessageBusConnection connection = this.myListenerAdapters.remove(listener);
        if (connection != null) {
            connection.disconnect();
        }
    }

    @NotNull
    public VirtualFile[] getContentRoots() {
        Module[] modules;
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (Module module : modules = this.getModuleManager().getModules()) {
            VirtualFile[] contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots();
            result.addAll(Arrays.asList(contentRoots));
        }
        VirtualFile[] virtualFileArray = VfsUtil.toVirtualFileArray(result);
        if (virtualFileArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/ProjectRootManagerImpl.getContentRoots must not return null");
        }
        return virtualFileArray;
    }

    public VirtualFile[] getContentSourceRoots() {
        Module[] modules;
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (Module module : modules = this.getModuleManager().getModules()) {
            VirtualFile[] sourceRoots = ModuleRootManager.getInstance((Module)module).getSourceRoots();
            result.addAll(Arrays.asList(sourceRoots));
        }
        return VfsUtil.toVirtualFileArray(result);
    }

    public VirtualFile[] getFilesFromAllModules(OrderRootType type) {
        Module[] modules;
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (Module module : modules = this.getModuleManager().getSortedModules()) {
            VirtualFile[] files = ModuleRootManager.getInstance((Module)module).getFiles(type);
            result.addAll(Arrays.asList(files));
        }
        return VfsUtil.toVirtualFileArray(result);
    }

    public VirtualFile[] getContentRootsFromAllModules() {
        Module[] modules;
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (Module module : modules = this.getModuleManager().getSortedModules()) {
            VirtualFile[] files = ModuleRootManager.getInstance((Module)module).getContentRoots();
            result.addAll(Arrays.asList(files));
        }
        result.add(this.myProject.getBaseDir());
        return VfsUtil.toVirtualFileArray(result);
    }

    public Sdk getProjectJdk() {
        if (this.myProjectJdkName != null) {
            return ProjectJdkTable.getInstance().findJdk(this.myProjectJdkName, this.myProjectJdkType);
        }
        return null;
    }

    public String getProjectJdkName() {
        return this.myProjectJdkName;
    }

    public void setProjectJdk(Sdk projectJdk) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (projectJdk != null) {
            this.myProjectJdkName = projectJdk.getName();
            this.myProjectJdkType = projectJdk.getSdkType().getName();
        } else {
            this.myProjectJdkName = null;
            this.myProjectJdkType = null;
        }
        this.mergeRootsChangesDuring(new Runnable(){

            @Override
            public void run() {
                ((ProjectRootManagerEx.ProjectJdkListener)ProjectRootManagerImpl.this.myProjectJdkEventDispatcher.getMulticaster()).projectJdkChanged();
            }
        });
    }

    public void setProjectJdkName(String name) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this.myProjectJdkName = name;
        this.mergeRootsChangesDuring(new Runnable(){

            @Override
            public void run() {
                ((ProjectRootManagerEx.ProjectJdkListener)ProjectRootManagerImpl.this.myProjectJdkEventDispatcher.getMulticaster()).projectJdkChanged();
            }
        });
    }

    @Override
    public void addProjectJdkListener(ProjectRootManagerEx.ProjectJdkListener listener) {
        this.myProjectJdkEventDispatcher.addListener((EventListener)listener);
    }

    @Override
    public void removeProjectJdkListener(ProjectRootManagerEx.ProjectJdkListener listener) {
        this.myProjectJdkEventDispatcher.removeListener((EventListener)listener);
    }

    public void projectOpened() {
        this.addRootsToWatch();
        this.myApplicationListener = new ApplicationListener();
        ApplicationManager.getApplication().addApplicationListener((com.intellij.openapi.application.ApplicationListener)this.myApplicationListener);
    }

    public void projectClosed() {
        LocalFileSystem.getInstance().removeWatchedRoots(this.myRootsToWatch);
        ApplicationManager.getApplication().removeApplicationListener((com.intellij.openapi.application.ApplicationListener)this.myApplicationListener);
    }

    @NotNull
    public String getComponentName() {
        if ("ProjectRootManager" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/ProjectRootManagerImpl.getComponentName must not return null");
        }
        return "ProjectRootManager";
    }

    public void initComponent() {
        this.myConnection.subscribe(BatchUpdateListener.TOPIC, (Object)this.myHandler);
    }

    public void disposeComponent() {
        VirtualFileManager.getInstance().removeVirtualFileManagerListener((VirtualFileManagerListener)this.myVFSListener);
        if (this.myJdkTableMultilistener != null) {
            this.myJdkTableMultilistener.uninstallListner(false);
            this.myJdkTableMultilistener = null;
        }
        this.myConnection.disconnect();
    }

    public void readExternal(Element element) throws InvalidDataException {
        for (ProjectExtension extension : (ProjectExtension[])Extensions.getExtensions(ProjectExtension.EP_NAME, (AreaInstance)this.myProject)) {
            extension.readExternal(element);
        }
        this.myProjectJdkName = element.getAttributeValue(PROJECT_JDK_NAME_ATTR);
        this.myProjectJdkType = element.getAttributeValue(PROJECT_JDK_TYPE_ATTR);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        element.setAttribute(ATTRIBUTE_VERSION, "2");
        for (ProjectExtension extension : (ProjectExtension[])Extensions.getExtensions(ProjectExtension.EP_NAME, (AreaInstance)this.myProject)) {
            extension.writeExternal(element);
        }
        if (this.myProjectJdkName != null) {
            element.setAttribute(PROJECT_JDK_NAME_ATTR, this.myProjectJdkName);
        }
        if (this.myProjectJdkType != null) {
            element.setAttribute(PROJECT_JDK_TYPE_ATTR, this.myProjectJdkType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mergeRootsChangesDuring(@NotNull Runnable runnable) {
        block6: {
            block5: {
                block4: {
                    if (runnable == null) {
                        throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/impl/ProjectRootManagerImpl.mergeRootsChangesDuring must not be null");
                    }
                    if (this.getBatchSession((boolean)false).myBatchLevel != 0 || this.myMergedCallStarted) break block5;
                    LOG.assertTrue(this.myRootsChangesDepth == 0, (Object)("Merged rootsChanged not allowed inside rootsChanged, rootsChanged level == " + this.myRootsChangesDepth));
                    this.myMergedCallStarted = true;
                    this.myMergedCallHasRootChange = false;
                    try {
                        runnable.run();
                        if (!this.myMergedCallHasRootChange) break block4;
                        LOG.assertTrue(this.myRootsChangesDepth == 1, (Object)("myMergedCallDepth = " + this.myRootsChangesDepth));
                    }
                    catch (Throwable throwable) {
                        if (this.myMergedCallHasRootChange) {
                            LOG.assertTrue(this.myRootsChangesDepth == 1, (Object)("myMergedCallDepth = " + this.myRootsChangesDepth));
                            this.getBatchSession(false).rootsChanged(true);
                        }
                        this.myMergedCallStarted = false;
                        this.myMergedCallHasRootChange = false;
                        throw throwable;
                    }
                    this.getBatchSession(false).rootsChanged(true);
                }
                this.myMergedCallStarted = false;
                this.myMergedCallHasRootChange = false;
                break block6;
            }
            runnable.run();
        }
    }

    private void clearScopesCaches() {
        this.clearScopesCachesForModules();
        this.myJdkScopes.clear();
        this.myLibraryScopes.clear();
    }

    @Override
    public void clearScopesCachesForModules() {
        Module[] modules;
        for (Module module : modules = ModuleManager.getInstance((Project)this.myProject).getModules()) {
            ((ModuleRootManagerImpl)ModuleRootManager.getInstance((Module)module)).dropCaches();
            ((ModuleImpl)module).clearScopesCache();
        }
    }

    @Override
    public void beforeRootsChange(boolean filetypes) {
        if (this.myProject.isDisposed()) {
            return;
        }
        this.getBatchSession(filetypes).beforeRootsChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void makeRootsChange(@NotNull Runnable runnable, boolean filetypes, boolean fireEvents) {
        if (runnable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/impl/ProjectRootManagerImpl.makeRootsChange must not be null");
        }
        if (this.myProject.isDisposed()) {
            return;
        }
        BatchSession session = this.getBatchSession(filetypes);
        if (fireEvents) {
            session.beforeRootsChanged();
        }
        try {
            runnable.run();
        }
        finally {
            if (fireEvents) {
                session.rootsChanged(false);
            }
        }
    }

    @Override
    public void rootsChanged(boolean filetypes) {
        this.getBatchSession(filetypes).rootsChanged(false);
    }

    private BatchSession getBatchSession(boolean filetypes) {
        return filetypes ? this.myFileTypesChanged : this.myRootsChanged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fireBeforeRootsChanged(boolean filetypes) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        LOG.assertTrue(!this.isFiringEvent, (Object)"Do not use API that changes roots from roots events. Try using invoke later or something else.");
        if (this.myMergedCallStarted) {
            LOG.assertTrue(!filetypes, (Object)"Filetypes change is not supported inside merged call");
        }
        if (this.myRootsChangesDepth++ == 0) {
            if (this.myMergedCallStarted) {
                this.myMergedCallHasRootChange = true;
                ++this.myRootsChangesDepth;
            }
            this.isFiringEvent = true;
            try {
                ((ModuleRootListener)this.myProject.getMessageBus().syncPublisher(ProjectTopics.PROJECT_ROOTS)).beforeRootsChange((ModuleRootEvent)new ModuleRootEventImpl(this.myProject, filetypes));
            }
            finally {
                this.isFiringEvent = false;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fireRootsChanged(boolean filetypes) {
        if (this.myProject.isDisposed()) {
            return false;
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        LOG.assertTrue(!this.isFiringEvent, (Object)"Do not use API that changes roots from roots events. Try using invoke later or something else.");
        if (this.myMergedCallStarted) {
            LOG.assertTrue(!filetypes, (Object)"Filetypes change is not supported inside merged call");
        }
        --this.myRootsChangesDepth;
        if (this.myRootsChangesDepth > 0) {
            return false;
        }
        this.clearScopesCaches();
        ++this.myModificationCount;
        this.isFiringEvent = true;
        try {
            ((ModuleRootListener)this.myProject.getMessageBus().syncPublisher(ProjectTopics.PROJECT_ROOTS)).rootsChanged((ModuleRootEvent)new ModuleRootEventImpl(this.myProject, filetypes));
        }
        finally {
            this.isFiringEvent = false;
        }
        this.doSynchronizeRoots();
        this.addRootsToWatch();
        return true;
    }

    public Project getProject() {
        return this.myProject;
    }

    @Override
    public GlobalSearchScope getScopeForLibraryUsedIn(List<Module> modulesLibraryIsUsedIn) {
        GlobalSearchScope scope = this.myLibraryScopes.get(modulesLibraryIsUsedIn);
        if (scope == null) {
            scope = !modulesLibraryIsUsedIn.isEmpty() ? new LibraryRuntimeClasspathScope(this.myProject, modulesLibraryIsUsedIn) : new LibrariesOnlyScope(GlobalSearchScope.allScope((Project)this.myProject));
            this.myLibraryScopes.put(modulesLibraryIsUsedIn, scope);
        }
        return scope;
    }

    @Override
    public GlobalSearchScope getScopeForJdk(JdkOrderEntry jdkOrderEntry) {
        String jdk = jdkOrderEntry.getJdkName();
        if (jdk == null) {
            return GlobalSearchScope.allScope((Project)this.myProject);
        }
        GlobalSearchScope scope = this.myJdkScopes.get(jdk);
        if (scope == null) {
            scope = new JdkScope(this.myProject, jdkOrderEntry);
            this.myJdkScopes.put(jdk, scope);
        }
        return scope;
    }

    private void doSynchronizeRoots() {
        if (!this.myStartupActivityPerformed) {
            return;
        }
        DumbServiceImpl.getInstance(this.myProject).queueCacheUpdate(this.myRootsChangeUpdaters);
    }

    private void doUpdateOnRefresh() {
        if (ApplicationManager.getApplication().isUnitTestMode() && !this.myStartupActivityPerformed) {
            return;
        }
        this.myStartupManager.runWhenProjectIsInitialized((Runnable)new DumbAwareRunnable(){

            public void run() {
                DumbServiceImpl.getInstance(ProjectRootManagerImpl.this.myProject).queueCacheUpdate(ProjectRootManagerImpl.this.myRefreshCacheUpdaters);
            }
        });
    }

    private void addRootsToWatch() {
        ModuleRootManager moduleRootManager;
        Module[] modules;
        if (this.myProject.isDefault()) {
            return;
        }
        HashSet rootPaths = new HashSet();
        for (Module module : modules = ModuleManager.getInstance((Project)this.myProject).getModules()) {
            ModuleRootManager moduleRootManager2 = ModuleRootManager.getInstance((Module)module);
            String[] contentRootUrls = moduleRootManager2.getContentRootUrls();
            rootPaths.addAll(ProjectRootManagerImpl.getRootsToTrack(contentRootUrls));
            rootPaths.add(module.getModuleFilePath());
        }
        for (Module module : (WatchedRootsProvider[])Extensions.getExtensions((ExtensionPointName)WatchedRootsProvider.EP_NAME, (AreaInstance)this.myProject)) {
            rootPaths.addAll(module.getRootsToWatch());
        }
        String projectFile = this.myProject.getStateStore().getProjectFilePath();
        rootPaths.add(projectFile);
        VirtualFile baseDir = this.myProject.getBaseDir();
        if (baseDir != null) {
            rootPaths.add(baseDir.getPath());
        }
        for (Module module : modules) {
            OrderEntry[] orderEntries;
            moduleRootManager = ModuleRootManager.getInstance((Module)module);
            for (OrderEntry entry : orderEntries = moduleRootManager.getOrderEntries()) {
                if (entry instanceof LibraryOrderEntry) {
                    Library library = ((LibraryOrderEntry)entry).getLibrary();
                    for (OrderRootType orderRootType : OrderRootType.getAllTypes()) {
                        rootPaths.addAll(ProjectRootManagerImpl.getRootsToTrack(library, orderRootType));
                    }
                    continue;
                }
                if (!(entry instanceof JdkOrderEntry)) continue;
                for (OrderRootType orderRootType : OrderRootType.getAllTypes()) {
                    rootPaths.addAll(ProjectRootManagerImpl.getRootsToTrack(entry, orderRootType));
                }
            }
        }
        for (Module module : modules) {
            moduleRootManager = ModuleRootManager.getInstance((Module)module);
            String explodedDirectory = moduleRootManager.getExplodedDirectoryUrl();
            if (explodedDirectory == null) continue;
            rootPaths.add(ProjectRootManagerImpl.extractLocalPath(explodedDirectory));
        }
        Set newRootsToWatch = LocalFileSystem.getInstance().addRootsToWatch((Collection)rootPaths, true);
        LocalFileSystem.getInstance().removeWatchedRoots(this.myRootsToWatch);
        this.myRootsToWatch = newRootsToWatch;
    }

    private static Collection<String> getRootsToTrack(Library library, OrderRootType rootType) {
        return library != null ? ProjectRootManagerImpl.getRootsToTrack(library.getUrls(rootType)) : Collections.emptyList();
    }

    private static Collection<String> getRootsToTrack(OrderEntry library, OrderRootType rootType) {
        return library != null ? ProjectRootManagerImpl.getRootsToTrack(library.getUrls(rootType)) : Collections.emptyList();
    }

    private static List<String> getRootsToTrack(String[] urls) {
        ArrayList<String> result = new ArrayList<String>(urls.length);
        for (String url : urls) {
            String protocol;
            if (url == null || (protocol = VirtualFileManager.extractProtocol((String)url)) != null && !"jar".equals(protocol) && !"file".equals(protocol)) continue;
            result.add(ProjectRootManagerImpl.extractLocalPath(url));
        }
        return result;
    }

    public static String extractLocalPath(String url) {
        String path = VfsUtil.urlToPath((String)url);
        int jarSeparatorIndex = path.indexOf("!/");
        if (jarSeparatorIndex > 0) {
            return path.substring(0, jarSeparatorIndex);
        }
        return path;
    }

    private ModuleManager getModuleManager() {
        return ModuleManager.getInstance((Project)this.myProject);
    }

    void addRootSetChangedListener(RootProvider.RootSetChangedListener rootSetChangedListener, RootProvider provider) {
        RootSetChangedMulticaster multicaster = this.myRegisteredRootProviderListeners.get(provider);
        if (multicaster == null) {
            multicaster = new RootSetChangedMulticaster(provider);
        }
        multicaster.addListener(rootSetChangedListener);
    }

    void removeRootSetChangedListener(RootProvider.RootSetChangedListener rootSetChangedListener, RootProvider provider) {
        RootSetChangedMulticaster multicaster = this.myRegisteredRootProviderListeners.get(provider);
        if (multicaster != null) {
            multicaster.removeListener(rootSetChangedListener);
        }
    }

    void addListenerForTable(LibraryTable.Listener libraryListener, LibraryTable libraryTable) {
        LibraryTableMultilistener multilistener = this.myLibraryTableMultilisteners.get(libraryTable);
        if (multilistener == null) {
            multilistener = new LibraryTableMultilistener(libraryTable);
        }
        multilistener.addListener(libraryListener);
    }

    void removeListenerForTable(LibraryTable.Listener libraryListener, LibraryTable libraryTable) {
        LibraryTableMultilistener multilistener = this.myLibraryTableMultilisteners.get(libraryTable);
        if (multilistener == null) {
            multilistener = new LibraryTableMultilistener(libraryTable);
        }
        multilistener.removeListener(libraryListener);
    }

    void addJdkTableListener(ProjectJdkTable.Listener jdkTableListener) {
        this.getJdkTableMultiListener().addListener(jdkTableListener);
    }

    private JdkTableMultilistener getJdkTableMultiListener() {
        if (this.myJdkTableMultilistener == null) {
            this.myJdkTableMultilistener = new JdkTableMultilistener();
        }
        return this.myJdkTableMultilistener;
    }

    void removeJdkTableListener(ProjectJdkTable.Listener jdkTableListener) {
        if (this.myJdkTableMultilistener == null) {
            return;
        }
        this.myJdkTableMultilistener.removeListener(jdkTableListener);
    }

    public long getModificationCount() {
        return this.myModificationCount;
    }

    private class RootSetChangedMulticaster
    implements RootProvider.RootSetChangedListener {
        private final EventDispatcher<RootProvider.RootSetChangedListener> myDispatcher = EventDispatcher.create(RootProvider.RootSetChangedListener.class);
        private final RootProvider myProvider;

        private RootSetChangedMulticaster(RootProvider provider) {
            this.myProvider = provider;
            provider.addRootSetChangedListener((RootProvider.RootSetChangedListener)this);
            ProjectRootManagerImpl.this.myRegisteredRootProviderListeners.put(this.myProvider, this);
        }

        private void addListener(RootProvider.RootSetChangedListener listener) {
            this.myDispatcher.addListener((EventListener)listener);
        }

        private void removeListener(RootProvider.RootSetChangedListener listener) {
            this.myDispatcher.removeListener((EventListener)listener);
            if (!this.myDispatcher.hasListeners()) {
                this.myProvider.removeRootSetChangedListener((RootProvider.RootSetChangedListener)this);
                ProjectRootManagerImpl.this.myRegisteredRootProviderListeners.remove(this.myProvider);
            }
        }

        public void rootSetChanged(final RootProvider wrapper) {
            LOG.assertTrue(this.myProvider.equals(wrapper));
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ((RootProvider.RootSetChangedListener)RootSetChangedMulticaster.this.myDispatcher.getMulticaster()).rootSetChanged(wrapper);
                }
            };
            ProjectRootManagerImpl.this.mergeRootsChangesDuring(runnable);
        }
    }

    private class JdkTableMultilistener
    implements ProjectJdkTable.Listener {
        final EventDispatcher<ProjectJdkTable.Listener> myDispatcher = EventDispatcher.create(ProjectJdkTable.Listener.class);
        final Set<ProjectJdkTable.Listener> myListeners = new HashSet();

        private JdkTableMultilistener() {
            ProjectJdkTable.getInstance().addListener((ProjectJdkTable.Listener)this);
        }

        private void addListener(ProjectJdkTable.Listener listener) {
            this.myDispatcher.addListener((EventListener)listener);
            this.myListeners.add(listener);
        }

        private void removeListener(ProjectJdkTable.Listener listener) {
            this.myDispatcher.removeListener((EventListener)listener);
            this.myListeners.remove(listener);
            this.uninstallListner(true);
        }

        public void jdkAdded(final Sdk jdk) {
            ProjectRootManagerImpl.this.mergeRootsChangesDuring(new Runnable(){

                @Override
                public void run() {
                    ((ProjectJdkTable.Listener)JdkTableMultilistener.this.myDispatcher.getMulticaster()).jdkAdded(jdk);
                }
            });
        }

        public void jdkRemoved(final Sdk jdk) {
            ProjectRootManagerImpl.this.mergeRootsChangesDuring(new Runnable(){

                @Override
                public void run() {
                    ((ProjectJdkTable.Listener)JdkTableMultilistener.this.myDispatcher.getMulticaster()).jdkRemoved(jdk);
                }
            });
        }

        public void jdkNameChanged(final Sdk jdk, final String previousName) {
            ProjectRootManagerImpl.this.mergeRootsChangesDuring(new Runnable(){

                @Override
                public void run() {
                    ((ProjectJdkTable.Listener)JdkTableMultilistener.this.myDispatcher.getMulticaster()).jdkNameChanged(jdk, previousName);
                }
            });
            String currentName = ProjectRootManagerImpl.this.getProjectJdkName();
            if (previousName != null && previousName.equals(currentName)) {
                ProjectRootManagerImpl.this.myProjectJdkName = jdk.getName();
                ProjectRootManagerImpl.this.myProjectJdkType = jdk.getSdkType().getName();
            }
        }

        public void uninstallListner(boolean soft) {
            if (!soft || !this.myDispatcher.hasListeners()) {
                ProjectJdkTable.getInstance().removeListener((ProjectJdkTable.Listener)this);
            }
        }
    }

    private class LibraryTableMultilistener
    implements LibraryTable.Listener {
        final Set<LibraryTable.Listener> myListeners = new HashSet();
        private final LibraryTable myLibraryTable;

        private LibraryTableMultilistener(LibraryTable libraryTable) {
            this.myLibraryTable = libraryTable;
            this.myLibraryTable.addListener((LibraryTable.Listener)this);
            ProjectRootManagerImpl.this.myLibraryTableMultilisteners.put(this.myLibraryTable, this);
        }

        private void addListener(LibraryTable.Listener listener) {
            this.myListeners.add(listener);
        }

        private void removeListener(LibraryTable.Listener listener) {
            this.myListeners.remove(listener);
            if (this.myListeners.isEmpty()) {
                this.myLibraryTable.removeListener((LibraryTable.Listener)this);
                ProjectRootManagerImpl.this.myLibraryTableMultilisteners.remove(this.myLibraryTable);
            }
        }

        public void afterLibraryAdded(final Library newLibrary) {
            ProjectRootManagerImpl.this.mergeRootsChangesDuring(new Runnable(){

                @Override
                public void run() {
                    for (LibraryTable.Listener listener : LibraryTableMultilistener.this.myListeners) {
                        listener.afterLibraryAdded(newLibrary);
                    }
                }
            });
        }

        public void afterLibraryRenamed(final Library library) {
            ProjectRootManagerImpl.this.mergeRootsChangesDuring(new Runnable(){

                @Override
                public void run() {
                    for (LibraryTable.Listener listener : LibraryTableMultilistener.this.myListeners) {
                        listener.afterLibraryRenamed(library);
                    }
                }
            });
        }

        public void beforeLibraryRemoved(final Library library) {
            ProjectRootManagerImpl.this.mergeRootsChangesDuring(new Runnable(){

                @Override
                public void run() {
                    for (LibraryTable.Listener listener : LibraryTableMultilistener.this.myListeners) {
                        listener.beforeLibraryRemoved(library);
                    }
                }
            });
        }

        public void afterLibraryRemoved(final Library library) {
            ProjectRootManagerImpl.this.mergeRootsChangesDuring(new Runnable(){

                @Override
                public void run() {
                    for (LibraryTable.Listener listener : LibraryTableMultilistener.this.myListeners) {
                        listener.afterLibraryRemoved(library);
                    }
                }
            });
        }
    }

    private class ApplicationListener
    extends ApplicationAdapter {
        private ApplicationListener() {
        }

        public void beforeWriteActionStart(Object action) {
            ProjectRootManagerImpl.this.myInsideRefresh++;
        }

        public void writeActionFinished(Object action) {
            if (--ProjectRootManagerImpl.this.myInsideRefresh == 0 && ProjectRootManagerImpl.this.myPointerChangesDetected) {
                ProjectRootManagerImpl.this.myPointerChangesDetected = false;
                ((ModuleRootListener)ProjectRootManagerImpl.this.myProject.getMessageBus().syncPublisher(ProjectTopics.PROJECT_ROOTS)).rootsChanged((ModuleRootEvent)new ModuleRootEventImpl(ProjectRootManagerImpl.this.myProject, false));
                ProjectRootManagerImpl.this.doSynchronizeRoots();
                ProjectRootManagerImpl.this.addRootsToWatch();
            }
        }
    }

    private class MyVirtualFilePointerListener
    implements VirtualFilePointerListener {
        private MyVirtualFilePointerListener() {
        }

        public void beforeValidityChanged(VirtualFilePointer[] pointers) {
            if (!ProjectRootManagerImpl.this.myProject.isDisposed()) {
                if (ProjectRootManagerImpl.this.myInsideRefresh == 0) {
                    ProjectRootManagerImpl.this.beforeRootsChange(false);
                } else if (!ProjectRootManagerImpl.this.myPointerChangesDetected) {
                    ProjectRootManagerImpl.this.myPointerChangesDetected = true;
                    ((ModuleRootListener)ProjectRootManagerImpl.this.myProject.getMessageBus().syncPublisher(ProjectTopics.PROJECT_ROOTS)).beforeRootsChange((ModuleRootEvent)new ModuleRootEventImpl(ProjectRootManagerImpl.this.myProject, false));
                }
            }
        }

        public void validityChanged(VirtualFilePointer[] pointers) {
            if (!ProjectRootManagerImpl.this.myProject.isDisposed()) {
                if (ProjectRootManagerImpl.this.myInsideRefresh > 0) {
                    ProjectRootManagerImpl.this.clearScopesCaches();
                } else {
                    ProjectRootManagerImpl.this.rootsChanged(false);
                }
            }
        }
    }

    private static class LibrariesOnlyScope
    extends GlobalSearchScope {
        private final GlobalSearchScope myOriginal;

        public LibrariesOnlyScope(GlobalSearchScope original) {
            super(original.getProject());
            this.myOriginal = original;
        }

        public boolean contains(VirtualFile file) {
            return this.myOriginal.contains(file);
        }

        public int compare(VirtualFile file1, VirtualFile file2) {
            return this.myOriginal.compare(file1, file2);
        }

        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/impl/ProjectRootManagerImpl$LibrariesOnlyScope.isSearchInModuleContent must not be null");
            }
            return false;
        }

        public boolean isSearchInLibraries() {
            return true;
        }
    }

    class BatchSession {
        int myBatchLevel = 0;
        boolean myChanged = false;
        final boolean myFileTypes;

        protected BatchSession(boolean fileTypes) {
            this.myFileTypes = fileTypes;
        }

        void levelUp() {
            if (this.myBatchLevel == 0) {
                this.myChanged = false;
            }
            ++this.myBatchLevel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void levelDown() {
            --this.myBatchLevel;
            if (this.myChanged && this.myBatchLevel == 0) {
                try {
                    this.fireChange();
                }
                finally {
                    this.myChanged = false;
                }
            }
        }

        boolean fireChange() {
            return ProjectRootManagerImpl.this.fireRootsChanged(this.myFileTypes);
        }

        public void beforeRootsChanged() {
            if ((this.myBatchLevel == 0 || !this.myChanged) && ProjectRootManagerImpl.this.fireBeforeRootsChanged(this.myFileTypes)) {
                this.myChanged = true;
            }
        }

        public void rootsChanged(boolean force) {
            if (this.myBatchLevel == 0 && this.fireChange()) {
                this.myChanged = false;
            }
        }
    }
}

