/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes.impl;

import com.intellij.CommonBundle;
import com.intellij.application.options.ExportSchemeAction;
import com.intellij.application.options.SchemesToImportPopup;
import com.intellij.ide.highlighter.custom.SyntaxTable;
import com.intellij.ide.highlighter.custom.impl.ReadFileType;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.FileTypesBundle;
import com.intellij.openapi.fileTypes.UserFileType;
import com.intellij.openapi.fileTypes.ex.FileTypeManagerEx;
import com.intellij.openapi.fileTypes.impl.AbstractFileType;
import com.intellij.openapi.fileTypes.impl.FileTypeAssocTable;
import com.intellij.openapi.fileTypes.impl.FileTypeManagerImpl;
import com.intellij.openapi.fileTypes.impl.FileTypePatternDialog;
import com.intellij.openapi.fileTypes.impl.FileTypeRenderer;
import com.intellij.openapi.fileTypes.impl.ImportedFileType;
import com.intellij.openapi.options.BaseConfigurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemesManager;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.templateLanguages.TemplateDataLanguagePatterns;
import com.intellij.ui.ListScrollingUtil;
import com.intellij.ui.ListUtil;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.Nullable;

public class FileTypeConfigurable
extends BaseConfigurable
implements SearchableConfigurable {
    private RecognizedFileTypes myRecognizedFileType;
    private PatternsPanel myPatterns;
    private FileTypePanel myFileTypePanel;
    private HashSet<FileType> myTempFileTypes;
    private final FileTypeManagerImpl myManager;
    private FileTypeAssocTable<FileType> myTempPatternsTable;
    private FileTypeAssocTable<Language> myTempTemplateDataLanguages;
    private final Map<UserFileType, UserFileType> myOriginalToEditedMap = new HashMap<UserFileType, UserFileType>();

    public FileTypeConfigurable(FileTypeManager fileTypeManager) {
        this.myManager = (FileTypeManagerImpl)fileTypeManager;
    }

    public String getDisplayName() {
        return FileTypesBundle.message("filetype.settings.title", new Object[0]);
    }

    public JComponent createComponent() {
        this.myFileTypePanel = new FileTypePanel();
        this.myRecognizedFileType = this.myFileTypePanel.myRecognizedFileType;
        this.myPatterns = this.myFileTypePanel.myPatterns;
        this.myRecognizedFileType.attachActions(this);
        this.myRecognizedFileType.myFileTypesList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                FileTypeConfigurable.this.updateExtensionList();
            }
        });
        this.myPatterns.attachActions(this);
        this.myFileTypePanel.myIgnoreFilesField.setColumns(30);
        return this.myFileTypePanel.getComponent();
    }

    private void updateFileTypeList() {
        FileType[] types = this.myTempFileTypes.toArray(new FileType[this.myTempFileTypes.size()]);
        Arrays.sort(types, new Comparator(){

            public int compare(Object o1, Object o2) {
                FileType fileType1 = (FileType)o1;
                FileType fileType2 = (FileType)o2;
                return fileType1.getDescription().compareToIgnoreCase(fileType2.getDescription());
            }
        });
        this.myRecognizedFileType.setFileTypes(types);
    }

    public Icon getIcon() {
        return IconLoader.getIcon((String)"/general/configurableFileTypes.png");
    }

    private static FileType[] getModifiableFileTypes() {
        FileType[] registeredFileTypes = FileTypeManager.getInstance().getRegisteredFileTypes();
        ArrayList<FileType> result = new ArrayList<FileType>();
        for (FileType fileType : registeredFileTypes) {
            if (fileType.isReadOnly()) continue;
            result.add(fileType);
        }
        return result.toArray(new FileType[result.size()]);
    }

    public void apply() throws ConfigurationException {
        Set<UserFileType> modifiedUserTypes = this.myOriginalToEditedMap.keySet();
        for (UserFileType oldType : modifiedUserTypes) {
            UserFileType newType = this.myOriginalToEditedMap.get(oldType);
            oldType.copyFrom(newType);
        }
        this.myOriginalToEditedMap.clear();
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                if (!FileTypeConfigurable.this.myManager.isIgnoredFilesListEqualToCurrent(FileTypeConfigurable.this.myFileTypePanel.myIgnoreFilesField.getText())) {
                    FileTypeConfigurable.this.myManager.setIgnoredFilesList(FileTypeConfigurable.this.myFileTypePanel.myIgnoreFilesField.getText());
                }
                FileTypeConfigurable.this.myManager.setPatternsTable(FileTypeConfigurable.this.myTempFileTypes, FileTypeConfigurable.this.myTempPatternsTable);
                TemplateDataLanguagePatterns.getInstance().setAssocTable(FileTypeConfigurable.this.myTempTemplateDataLanguages);
            }
        });
    }

    public void reset() {
        this.myTempPatternsTable = this.myManager.getExtensionMap().copy();
        this.myTempTemplateDataLanguages = TemplateDataLanguagePatterns.getInstance().getAssocTable();
        this.myTempFileTypes = new HashSet<FileType>(Arrays.asList(FileTypeConfigurable.getModifiableFileTypes()));
        this.myOriginalToEditedMap.clear();
        this.updateFileTypeList();
        this.updateExtensionList();
        this.myFileTypePanel.myIgnoreFilesField.setText(this.myManager.getIgnoredFilesList());
    }

    public boolean isModified() {
        if (!this.myManager.isIgnoredFilesListEqualToCurrent(this.myFileTypePanel.myIgnoreFilesField.getText())) {
            return true;
        }
        HashSet<FileType> types = new HashSet<FileType>(Arrays.asList(FileTypeConfigurable.getModifiableFileTypes()));
        return !this.myTempPatternsTable.equals(this.myManager.getExtensionMap()) || !this.myTempFileTypes.equals(types) || !this.myOriginalToEditedMap.isEmpty() || !this.myTempTemplateDataLanguages.equals(TemplateDataLanguagePatterns.getInstance().getAssocTable());
    }

    public void disposeUIResources() {
        if (this.myFileTypePanel != null) {
            this.myFileTypePanel.dispose();
        }
        this.myFileTypePanel = null;
        this.myRecognizedFileType = null;
        this.myPatterns = null;
    }

    private void updateExtensionList() {
        FileType type = this.myRecognizedFileType.getSelectedFileType();
        if (type == null) {
            return;
        }
        ArrayList<String> extensions = new ArrayList<String>();
        List<FileNameMatcher> assocs = this.myTempPatternsTable.getAssociations(type);
        for (FileNameMatcher assoc : assocs) {
            extensions.add(assoc.getPresentableString());
        }
        this.myPatterns.clearList();
        Collections.sort(extensions);
        for (String extension : extensions) {
            this.myPatterns.addPattern(extension);
        }
        this.myPatterns.ensureSelectionExists();
    }

    private void editFileType() {
        FileType fileType = this.myRecognizedFileType.getSelectedFileType();
        if (!FileTypeConfigurable.canBeModified(fileType)) {
            return;
        }
        UserFileType ftToEdit = this.myOriginalToEditedMap.get(fileType);
        if (ftToEdit == null) {
            ftToEdit = ((UserFileType)fileType).clone();
        }
        TypeEditor<UserFileType> editor = new TypeEditor<UserFileType>(this.myRecognizedFileType.myEditButton, ftToEdit, FileTypesBundle.message("filetype.edit.existing.title", new Object[0]));
        editor.show();
        if (editor.isOK()) {
            this.myOriginalToEditedMap.put((UserFileType)fileType, ftToEdit);
        }
    }

    private void removeFileType() {
        FileType fileType = this.myRecognizedFileType.getSelectedFileType();
        if (fileType == null) {
            return;
        }
        this.myTempFileTypes.remove(fileType);
        this.myOriginalToEditedMap.remove(fileType);
        this.myTempPatternsTable.removeAllAssociations(fileType);
        this.updateFileTypeList();
        this.updateExtensionList();
    }

    private static boolean canBeModified(FileType fileType) {
        return fileType instanceof AbstractFileType && !(fileType instanceof ImportedFileType);
    }

    private void addFileType() {
        AbstractFileType type = new AbstractFileType(new SyntaxTable());
        TypeEditor<AbstractFileType> editor = new TypeEditor<AbstractFileType>(this.myRecognizedFileType.myAddButton, type, FileTypesBundle.message("filetype.edit.new.title", new Object[0]));
        editor.show();
        if (editor.isOK()) {
            this.myTempFileTypes.add((FileType)type);
            this.updateFileTypeList();
            this.updateExtensionList();
            this.myRecognizedFileType.selectFileType((FileType)type);
        }
    }

    private void editPattern() {
        String item = this.myPatterns.getSelectedItem();
        if (item == null) {
            return;
        }
        this.editPattern(item);
    }

    private void editPattern(@Nullable String item) {
        FileType type = this.myRecognizedFileType.getSelectedFileType();
        if (type == null) {
            return;
        }
        String title = item == null ? FileTypesBundle.message("filetype.edit.add.pattern.title", new Object[0]) : FileTypesBundle.message("filetype.edit.edit.pattern.title", new Object[0]);
        Language oldLanguage = item == null ? null : this.myTempTemplateDataLanguages.findAssociatedFileType(item);
        FileTypePatternDialog dialog = new FileTypePatternDialog(item, type, oldLanguage);
        DialogBuilder builder = new DialogBuilder((Component)this.myPatterns);
        builder.setPreferedFocusComponent((JComponent)dialog.getPatternField());
        builder.setCenterPanel((JComponent)dialog.getMainPanel());
        builder.setTitle(title);
        builder.showModal(true);
        if (builder.getDialogWrapper().isOK()) {
            String pattern = dialog.getPatternField().getText();
            if (StringUtil.isEmpty((String)pattern)) {
                return;
            }
            FileNameMatcher matcher = FileTypeManager.parseFromString((String)pattern);
            FileType registeredFileType = this.findExistingFileType(matcher);
            if (registeredFileType != null && registeredFileType != type) {
                if (registeredFileType.isReadOnly()) {
                    Messages.showMessageDialog((Component)this.myPatterns.myAddButton, (String)FileTypesBundle.message("filetype.edit.add.pattern.exists.error", registeredFileType.getDescription()), (String)title, (Icon)Messages.getErrorIcon());
                    return;
                }
                if (0 == Messages.showDialog((Component)this.myPatterns.myAddButton, (String)FileTypesBundle.message("filetype.edit.add.pattern.exists.message", registeredFileType.getDescription()), (String)FileTypesBundle.message("filetype.edit.add.pattern.exists.title", new Object[0]), (String[])new String[]{FileTypesBundle.message("filetype.edit.add.pattern.reassign.button", new Object[0]), CommonBundle.getCancelButtonText()}, (int)0, (Icon)Messages.getQuestionIcon())) {
                    this.myTempPatternsTable.removeAssociation(matcher, registeredFileType);
                    this.myTempTemplateDataLanguages.removeAssociation(matcher, oldLanguage);
                } else {
                    return;
                }
            }
            if (item != null) {
                FileNameMatcher oldMatcher = FileTypeManager.parseFromString((String)item);
                this.myTempPatternsTable.removeAssociation(oldMatcher, type);
                this.myTempTemplateDataLanguages.removeAssociation(oldMatcher, oldLanguage);
            }
            this.myTempPatternsTable.addAssociation(matcher, type);
            this.myTempTemplateDataLanguages.addAssociation(matcher, dialog.getTemplateDataLanguage());
            this.updateExtensionList();
            int index = this.myPatterns.getListModel().indexOf(matcher.getPresentableString());
            if (index >= 0) {
                ListScrollingUtil.selectItem((JList)this.myPatterns.myPatternsList, (int)index);
            }
            this.myPatterns.myPatternsList.requestFocus();
        }
    }

    private void addPattern() {
        this.editPattern(null);
    }

    @Nullable
    public FileType findExistingFileType(FileNameMatcher matcher) {
        FileType fileTypeByExtension = this.myTempPatternsTable.findAssociatedFileType(matcher);
        if (fileTypeByExtension != null && fileTypeByExtension != FileTypes.UNKNOWN) {
            return fileTypeByExtension;
        }
        FileType registeredFileType = FileTypeManager.getInstance().getFileTypeByExtension(matcher.getPresentableString());
        if (registeredFileType != FileTypes.UNKNOWN && registeredFileType.isReadOnly()) {
            return registeredFileType;
        }
        return null;
    }

    @Nullable
    public FileType addNewPattern(FileType type, String pattern) {
        FileNameMatcher matcher = FileTypeManager.parseFromString((String)pattern);
        FileType existing = this.findExistingFileType(matcher);
        if (existing != null) {
            return existing;
        }
        this.myTempPatternsTable.addAssociation(matcher, type);
        this.myPatterns.addPatternAndSelect(pattern);
        this.myPatterns.myPatternsList.requestFocus();
        return null;
    }

    private void removePattern() {
        FileType type = this.myRecognizedFileType.getSelectedFileType();
        if (type == null) {
            return;
        }
        String extension = this.myPatterns.removeSelected();
        if (extension == null) {
            return;
        }
        FileNameMatcher matcher = FileTypeManager.parseFromString((String)extension);
        this.myTempPatternsTable.removeAssociation(matcher, type);
        this.myPatterns.myPatternsList.requestFocus();
    }

    public String getHelpTopic() {
        return "preferences.fileTypes";
    }

    private void importFileType(FileType type) {
        ReadFileType readFileType = (ReadFileType)type;
        ImportedFileType actualType = new ImportedFileType(readFileType.getSyntaxTable(), readFileType.getExternalInfo());
        actualType.setDescription(readFileType.getDescription());
        actualType.setName(readFileType.getName());
        actualType.readOriginalMatchers(readFileType.getElement());
        for (FileNameMatcher matcher : actualType.getOriginalPatterns()) {
            this.myTempPatternsTable.addAssociation(matcher, (FileType)actualType);
        }
        this.myTempFileTypes.add((FileType)actualType);
        this.updateFileTypeList();
        this.updateExtensionList();
        this.myRecognizedFileType.selectFileType(type);
    }

    public String getId() {
        return this.getHelpTopic();
    }

    @Nullable
    public Runnable enableSearch(String option) {
        return null;
    }

    private static class TypeEditor<T extends UserFileType<T>>
    extends DialogWrapper {
        private final T myFileType;
        private final SettingsEditor<T> myEditor;

        public TypeEditor(Component parent, T fileType, String title) {
            super(parent, false);
            this.myFileType = fileType;
            this.myEditor = fileType.getEditor();
            this.setTitle(title);
            this.init();
            Disposer.register((Disposable)this.myDisposable, this.myEditor);
        }

        protected void init() {
            super.init();
            this.myEditor.resetFrom(this.myFileType);
        }

        protected JComponent createCenterPanel() {
            return this.myEditor.getComponent();
        }

        protected void doOKAction() {
            try {
                this.myEditor.applyTo(this.myFileType);
            }
            catch (ConfigurationException e) {
                Messages.showErrorDialog((Component)this.getContentPane(), (String)e.getMessage(), (String)e.getTitle());
                return;
            }
            super.doOKAction();
        }

        protected String getHelpId() {
            return "reference.dialogs.newfiletype";
        }
    }

    private static class FileTypePanel {
        private JPanel myWholePanel;
        private RecognizedFileTypes myRecognizedFileType;
        private PatternsPanel myPatterns;
        private JTextField myIgnoreFilesField;

        private FileTypePanel() {
            this.$$$setupUI$$$();
        }

        public JComponent getComponent() {
            return this.myWholePanel;
        }

        public void dispose() {
            this.myRecognizedFileType.setFileTypes(FileType.EMPTY_ARRAY);
            this.myPatterns.clearList();
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JTextField jTextField;
            RecognizedFileTypes recognizedFileTypes;
            PatternsPanel patternsPanel;
            JPanel jPanel;
            this.myWholePanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            this.myPatterns = patternsPanel = new PatternsPanel();
            jPanel.add((Component)patternsPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 7, null, null, null));
            this.myRecognizedFileType = recognizedFileTypes = new RecognizedFileTypes();
            jPanel.add((Component)recognizedFileTypes, new GridConstraints(0, 0, 1, 1, 8, 3, 7, 7, null, null, null));
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 2, 0, 0), -1, -1, false, false));
            jPanel.add((Component)jPanel2, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            JLabel jLabel = new JLabel();
            this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/IdeBundle").getString("editbox.ignore.files.and.folders"));
            jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myIgnoreFilesField = jTextField = new JTextField();
            jTextField.setText(".dependency-info;CVS;RCS;SCCS;rcs;");
            jTextField.setFocusCycleRoot(false);
            jTextField.setOpaque(true);
            jPanel2.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 7, 0, new Dimension(-1, 20), new Dimension(-1, 20), null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myWholePanel;
        }

        private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            jLabel.setText(stringBuffer.toString());
            if (bl) {
                jLabel.setDisplayedMnemonic(c);
                jLabel.setDisplayedMnemonicIndex(n);
            }
        }
    }

    public static class PatternsPanel
    extends JPanel {
        private JList myPatternsList;
        private JButton myAddButton;
        private JButton myRemoveButton;
        private JPanel myWholePanel;
        private JButton myEditButton;

        public PatternsPanel() {
            super(new BorderLayout());
            this.$$$setupUI$$$();
            this.add((Component)this.myWholePanel, "Center");
            this.myPatternsList.setCellRenderer(new ExtensionRenderer());
            this.myPatternsList.setModel(new DefaultListModel());
            this.myPatternsList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    PatternsPanel.this.myRemoveButton.setEnabled(PatternsPanel.this.myPatternsList.getSelectedIndex() != -1 && PatternsPanel.this.getListModel().size() > 0);
                }
            });
        }

        public void attachActions(final FileTypeConfigurable controller) {
            this.myAddButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    controller.addPattern();
                }
            });
            this.myEditButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    controller.editPattern();
                }
            });
            this.myRemoveButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    controller.removePattern();
                }
            });
        }

        public JComponent getComponent() {
            return this.myWholePanel;
        }

        public void clearList() {
            this.getListModel().clear();
            this.myPatternsList.clearSelection();
        }

        private DefaultListModel getListModel() {
            return (DefaultListModel)this.myPatternsList.getModel();
        }

        public void addPattern(String pattern) {
            this.getListModel().addElement(pattern);
        }

        public void ensureSelectionExists() {
            ListScrollingUtil.ensureSelectionExists((JList)this.myPatternsList);
        }

        public void addPatternAndSelect(String pattern) {
            this.addPattern(pattern);
            ListScrollingUtil.selectItem((JList)this.myPatternsList, (int)(this.getListModel().getSize() - 1));
        }

        public boolean isListEmpty() {
            return this.getListModel().size() == 0;
        }

        public String removeSelected() {
            Object selectedValue = this.myPatternsList.getSelectedValue();
            if (selectedValue == null) {
                return null;
            }
            ListUtil.removeSelectedItems((JList)this.myPatternsList);
            return (String)selectedValue;
        }

        public String getDefaultExtension() {
            return (String)this.getListModel().getElementAt(0);
        }

        public String getSelectedItem() {
            return (String)this.myPatternsList.getSelectedValue();
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JButton jButton;
            JButton jButton2;
            JButton jButton3;
            JList jList;
            JPanel jPanel;
            this.myWholePanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResourceBundle.getBundle("messages/FileTypesBundle").getString("filetype.registered.patterns.group"), 0, 0, null, null));
            JScrollPane jScrollPane = new JScrollPane();
            jPanel.add((Component)jScrollPane, new GridConstraints(0, 0, 4, 1, 0, 3, 7, 7, new Dimension(80, 80), new Dimension(200, 150), null));
            this.myPatternsList = jList = new JList();
            jList.setSelectionMode(0);
            jScrollPane.setViewportView(jList);
            this.myAddButton = jButton3 = new JButton();
            this.$$$loadButtonText$$$(jButton3, ResourceBundle.getBundle("messages/FileTypesBundle").getString("filetype.registered.pattern.add.button"));
            jPanel.add((Component)jButton3, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
            this.myRemoveButton = jButton2 = new JButton();
            this.$$$loadButtonText$$$(jButton2, ResourceBundle.getBundle("messages/FileTypesBundle").getString("filetype.registered.pattern.remove.button"));
            jPanel.add((Component)jButton2, new GridConstraints(2, 1, 1, 1, 0, 1, 3, 0, null, null, null));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(3, 1, 1, 1, 0, 2, 1, 6, null, null, null));
            this.myEditButton = jButton = new JButton();
            jButton.setText("Edit...");
            jButton.setMnemonic('I');
            jButton.setDisplayedMnemonicIndex(2);
            jPanel.add((Component)jButton, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myWholePanel;
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }

    public static class RecognizedFileTypes
    extends JPanel {
        private JList myFileTypesList;
        private JButton myAddButton;
        private JButton myEditButton;
        private JButton myRemoveButton;
        private JPanel myWholePanel;
        private JButton myExportButton;
        private JButton myImportButton;

        public RecognizedFileTypes() {
            super(new BorderLayout());
            this.$$$setupUI$$$();
            this.add((Component)this.myWholePanel, "Center");
            this.myFileTypesList.setCellRenderer(new FileTypeRenderer(new FileTypeRenderer.FileTypeListProvider(){

                @Override
                public Iterable<FileType> getCurrentFileTypeList() {
                    ArrayList<FileType> result = new ArrayList<FileType>();
                    for (int i = 0; i < RecognizedFileTypes.this.myFileTypesList.getModel().getSize(); ++i) {
                        result.add((FileType)RecognizedFileTypes.this.myFileTypesList.getModel().getElementAt(i));
                    }
                    return result;
                }
            }));
            this.myFileTypesList.setModel(new DefaultListModel());
            if (this.getSchemesManager().isImportAvailable()) {
                this.myImportButton.setVisible(true);
            }
            if (this.getSchemesManager().isExportAvailable()) {
                this.myExportButton.setVisible(true);
            }
        }

        private SchemesManager<FileType, AbstractFileType> getSchemesManager() {
            return ((FileTypeManagerEx)FileTypeManager.getInstance()).getSchemesManager();
        }

        public void attachActions(final FileTypeConfigurable controller) {
            this.myAddButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    controller.addFileType();
                }
            });
            this.myEditButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    controller.editFileType();
                }
            });
            this.myFileTypesList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    FileType fileType = RecognizedFileTypes.this.getSelectedFileType();
                    boolean b = FileTypeConfigurable.canBeModified(fileType);
                    RecognizedFileTypes.this.myEditButton.setEnabled(b);
                    RecognizedFileTypes.this.myRemoveButton.setEnabled(b);
                    boolean shared = RecognizedFileTypes.this.getSchemesManager().isShared((Scheme)fileType);
                    RecognizedFileTypes.this.myExportButton.setEnabled(b && !shared);
                    if (shared) {
                        RecognizedFileTypes.this.myRemoveButton.setEnabled(true);
                    }
                }
            });
            this.myRemoveButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    controller.removeFileType();
                }
            });
            this.myFileTypesList.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        controller.editFileType();
                    }
                }
            });
            this.myImportButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    new SchemesToImportPopup<FileType, AbstractFileType>((Component)RecognizedFileTypes.this.myWholePanel){

                        @Override
                        protected void onSchemeSelected(AbstractFileType scheme) {
                            controller.importFileType((FileType)scheme);
                        }
                    }.show(RecognizedFileTypes.this.getSchemesManager(), RecognizedFileTypes.this.collectRegisteredFileTypes());
                }
            });
            this.myExportButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FileType selected = (FileType)RecognizedFileTypes.this.myFileTypesList.getSelectedValue();
                    if (selected instanceof AbstractFileType) {
                        ExportSchemeAction.doExport((AbstractFileType)selected, RecognizedFileTypes.this.getSchemesManager());
                    }
                }
            });
        }

        private Collection<FileType> collectRegisteredFileTypes() {
            HashSet<FileType> result = new HashSet<FileType>();
            for (int i = 0; i < this.myFileTypesList.getModel().getSize(); ++i) {
                result.add((FileType)this.myFileTypesList.getModel().getElementAt(i));
            }
            return result;
        }

        public FileType getSelectedFileType() {
            return (FileType)this.myFileTypesList.getSelectedValue();
        }

        public JComponent getComponent() {
            return this.myWholePanel;
        }

        public void setFileTypes(FileType[] types) {
            DefaultListModel listModel = (DefaultListModel)this.myFileTypesList.getModel();
            listModel.clear();
            for (FileType type : types) {
                if (type == FileTypes.UNKNOWN) continue;
                listModel.addElement(type);
            }
            ListScrollingUtil.ensureSelectionExists((JList)this.myFileTypesList);
        }

        public int getSelectedIndex() {
            return this.myFileTypesList.getSelectedIndex();
        }

        public void setSelectionIndex(int selectedIndex) {
            this.myFileTypesList.setSelectedIndex(selectedIndex);
        }

        public void selectFileType(FileType fileType) {
            this.myFileTypesList.setSelectedValue(fileType, true);
            this.myFileTypesList.requestFocus();
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JButton jButton;
            JButton jButton2;
            JButton jButton3;
            JButton jButton4;
            JButton jButton5;
            JList jList;
            JPanel jPanel;
            this.myWholePanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResourceBundle.getBundle("messages/FileTypesBundle").getString("filetypes.recognized.group"), 0, 0, null, null));
            JScrollPane jScrollPane = new JScrollPane();
            jPanel.add((Component)jScrollPane, new GridConstraints(0, 0, 6, 1, 0, 3, 7, 7, new Dimension(80, 80), new Dimension(200, 150), null));
            this.myFileTypesList = jList = new JList();
            jList.setSelectionMode(0);
            jScrollPane.setViewportView(jList);
            this.myEditButton = jButton5 = new JButton();
            this.$$$loadButtonText$$$(jButton5, ResourceBundle.getBundle("messages/FileTypesBundle").getString("filetypes.recognized.edit.button"));
            jPanel.add((Component)jButton5, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 0, null, null, null));
            this.myAddButton = jButton4 = new JButton();
            this.$$$loadButtonText$$$(jButton4, ResourceBundle.getBundle("messages/FileTypesBundle").getString("filetypes.recognized.add.button"));
            jPanel.add((Component)jButton4, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
            this.myRemoveButton = jButton3 = new JButton();
            this.$$$loadButtonText$$$(jButton3, ResourceBundle.getBundle("messages/FileTypesBundle").getString("filetypes.recognized.remove.button"));
            jPanel.add((Component)jButton3, new GridConstraints(2, 1, 1, 1, 0, 1, 3, 0, null, null, null));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(5, 1, 1, 1, 0, 2, 1, 6, null, null, null));
            this.myExportButton = jButton2 = new JButton();
            ((Component)jButton2).setVisible(false);
            jButton2.setText("Share...");
            jButton2.setMnemonic('S');
            jButton2.setDisplayedMnemonicIndex(0);
            jPanel.add((Component)jButton2, new GridConstraints(3, 1, 1, 1, 0, 1, 3, 0, null, null, null));
            this.myImportButton = jButton = new JButton();
            ((Component)jButton).setVisible(false);
            jButton.setText("Import Shared...");
            jButton.setMnemonic('I');
            jButton.setDisplayedMnemonicIndex(0);
            ((Component)jButton).setEnabled(true);
            jPanel.add((Component)jButton, new GridConstraints(4, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myWholePanel;
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }

    private static class ExtensionRenderer
    extends DefaultListCellRenderer {
        private ExtensionRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            this.setText(" " + this.getText());
            return this;
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(0, 20);
        }
    }
}

