/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors.impl;

import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.ex.DefaultColorSchemesManager;
import com.intellij.openapi.editor.colors.impl.AbstractColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.options.ExternalInfo;
import com.intellij.openapi.options.ExternalizableScheme;
import com.intellij.openapi.util.Comparing;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;

public class EditorColorsSchemeImpl
extends AbstractColorsScheme
implements ExternalizableScheme {
    private final ExternalInfo myExternalInfo = new ExternalInfo();

    public EditorColorsSchemeImpl(EditorColorsScheme parenScheme, DefaultColorSchemesManager defaultColorSchemesManager) {
        super(parenScheme, defaultColorSchemesManager);
    }

    public void setAttributes(TextAttributesKey key, TextAttributes attributes) {
        if (!Comparing.equal((Object)attributes, (Object)this.getAttributes(key))) {
            this.myAttributesMap.put(key, attributes);
        }
    }

    public void setColor(ColorKey key, Color color) {
        if (!Comparing.equal((Object)color, (Object)this.getColor(key))) {
            this.myColorsMap.put(key, color);
        }
    }

    public TextAttributes getAttributes(TextAttributesKey key) {
        if (this.myAttributesMap.containsKey(key)) {
            return (TextAttributes)this.myAttributesMap.get(key);
        }
        return this.myParentScheme.getAttributes(key);
    }

    public Color getColor(ColorKey key) {
        if (this.myColorsMap.containsKey(key)) {
            return (Color)this.myColorsMap.get(key);
        }
        return this.myParentScheme.getColor(key);
    }

    @Override
    public Object clone() {
        EditorColorsSchemeImpl newScheme = new EditorColorsSchemeImpl(this.myParentScheme, DefaultColorSchemesManager.getInstance());
        this.copyTo(newScheme);
        newScheme.setName(this.getName());
        return newScheme;
    }

    @NotNull
    public ExternalInfo getExternalInfo() {
        ExternalInfo externalInfo = this.myExternalInfo;
        if (externalInfo == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/colors/impl/EditorColorsSchemeImpl.getExternalInfo must not return null");
        }
        return externalInfo;
    }
}

