/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;

public class PasteFromX11Action
extends EditorAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.editor.actions.PasteFromX11Action");

    public PasteFromX11Action() {
        super((EditorActionHandler)new Handler());
    }

    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        DataContext dataContext = e.getDataContext();
        Editor editor = (Editor)PlatformDataKeys.EDITOR.getData(dataContext);
        if (editor == null || !SystemInfo.X11PasteEnabledSystem) {
            presentation.setEnabled(false);
        } else {
            boolean rightPlace = true;
            InputEvent inputEvent = e.getInputEvent();
            if (inputEvent instanceof MouseEvent) {
                rightPlace = editor.getMouseEventArea((MouseEvent)inputEvent) == EditorMouseEventArea.EDITING_AREA;
            }
            presentation.setEnabled(rightPlace);
        }
    }

    public static class Handler
    extends EditorWriteActionHandler {
        public void executeWriteAction(Editor editor, DataContext dataContext) {
            Clipboard clip = editor.getComponent().getToolkit().getSystemSelection();
            if (clip != null) {
                Transferable res;
                block3: {
                    res = null;
                    try {
                        res = clip.getContents(null);
                    }
                    catch (Exception e) {
                        if (ApplicationManager.getApplication().isHeadlessEnvironment()) break block3;
                        LOG.info((Throwable)e);
                        Messages.showErrorDialog((Project)editor.getProject(), (String)("Cannot paste from X11 clipboard: " + e.getLocalizedMessage()), (String)"Cannot Paste");
                        return;
                    }
                }
                editor.putUserData(EditorEx.LAST_PASTED_REGION, (Object)EditorModificationUtil.pasteFromTransferrable((Transferable)res, (Editor)editor));
            }
        }
    }
}

