/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ComponentConfig;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.StateStorageOperation;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.stores.ProjectStoreImpl;
import com.intellij.openapi.components.impl.stores.StateStorageManagerImpl;
import com.intellij.openapi.components.impl.stores.XmlElementStorage;
import com.intellij.openapi.project.Project;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

class ProjectStateStorageManager
extends StateStorageManagerImpl {
    protected final Project myProject;
    @NonNls
    protected static final String ROOT_TAG_NAME = "project";

    public ProjectStateStorageManager(TrackingPathMacroSubstitutor macroSubstitutor, Project project) {
        super(macroSubstitutor, ROOT_TAG_NAME, (Disposable)project, project.getPicoContainer());
        this.myProject = project;
    }

    @Override
    protected XmlElementStorage.StorageData createStorageData(String storageSpec) {
        if (storageSpec.equals("$PROJECT_FILE$")) {
            return this.createIprStorageData();
        }
        if (storageSpec.equals("$WORKSPACE_FILE$")) {
            return this.createWsStorageData();
        }
        return new ProjectStoreImpl.ProjectStorageData(ROOT_TAG_NAME, this.myProject);
    }

    public XmlElementStorage.StorageData createWsStorageData() {
        return new ProjectStoreImpl.WsStorageData(ROOT_TAG_NAME, this.myProject);
    }

    public XmlElementStorage.StorageData createIprStorageData() {
        return new ProjectStoreImpl.IprStorageData(ROOT_TAG_NAME, this.myProject);
    }

    @Override
    protected String getOldStorageSpec(Object component, String componentName, StateStorageOperation operation) throws StateStorage.StateStorageException {
        ComponentConfig config = this.myProject.getConfig(component.getClass());
        assert (config != null) : "Couldn't find old storage for " + component.getClass().getName();
        String macro = "PROJECT_FILE";
        boolean workspace = ProjectStateStorageManager.isWorkspace(config.options);
        if (workspace) {
            macro = "WORKSPACE_FILE";
        }
        String name = "$" + macro + "$";
        StateStorage storage = this.getFileStateStorage(name);
        if (operation == StateStorageOperation.READ && storage != null && workspace && !storage.hasState(component, componentName, Element.class, false)) {
            name = "$PROJECT_FILE$";
        }
        return name;
    }

    @Override
    protected String getVersionsFilePath() {
        return PathManager.getConfigPath() + "/componentVersions/" + ROOT_TAG_NAME + this.myProject.getLocationHash() + ".xml";
    }

    private static boolean isWorkspace(Map options) {
        return options != null && Boolean.parseBoolean((String)options.get("workspace"));
    }
}

