/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.openapi.actionSystem.ActionButtonComponent;
import com.intellij.openapi.actionSystem.ex.ActionButtonLook;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;

public class IdeaActionButtonLook
extends ActionButtonLook {
    @Override
    public void paintBackground(Graphics g, JComponent component, int state) {
        Dimension dimension = component.getSize();
        if (state != 0) {
            if (state == 1) {
                g.setColor(new Color(181, 190, 214));
                g.fillRect(0, 0, dimension.width, dimension.height);
            } else {
                g.setColor(new Color(130, 146, 185));
                g.fillRect(0, 0, dimension.width, dimension.height);
            }
        }
        if (state == -1) {
            g.setColor(new Color(130, 146, 185));
            g.fillRect(0, 0, dimension.width, dimension.height);
        }
    }

    @Override
    public void paintBorder(Graphics g, JComponent component, int state) {
        if (state == 0) {
            return;
        }
        Rectangle rectangle = new Rectangle(component.getWidth(), component.getHeight());
        Color color = new Color(8, 36, 107);
        g.setColor(color);
        UIUtil.drawLine((Graphics)g, (int)rectangle.x, (int)rectangle.y, (int)rectangle.x, (int)(rectangle.y + rectangle.height - 1));
        UIUtil.drawLine((Graphics)g, (int)rectangle.x, (int)rectangle.y, (int)(rectangle.x + rectangle.width - 1), (int)rectangle.y);
        UIUtil.drawLine((Graphics)g, (int)(rectangle.x + rectangle.width - 1), (int)rectangle.y, (int)(rectangle.x + rectangle.width - 1), (int)(rectangle.y + rectangle.height - 1));
        UIUtil.drawLine((Graphics)g, (int)rectangle.x, (int)(rectangle.y + rectangle.height - 1), (int)(rectangle.x + rectangle.width - 1), (int)(rectangle.y + rectangle.height - 1));
    }

    @Override
    public void paintIcon(Graphics g, ActionButtonComponent actionButton, Icon icon) {
        int width = icon.getIconWidth();
        int height = icon.getIconHeight();
        int x = (int)Math.ceil((actionButton.getWidth() - width) / 2);
        int y = (int)Math.ceil((actionButton.getHeight() - height) / 2);
        this.paintIconAt(g, actionButton, icon, x, y);
    }

    @Override
    public void paintIconAt(Graphics g, ActionButtonComponent button, Icon icon, int x, int y) {
        if (button.getPopState() == -1) {
            ++x;
            ++y;
        }
        icon.paintIcon(null, g, x, y);
    }
}

