/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lifecycle;

import com.intellij.lifecycle.AtomicSectionsAware;
import com.intellij.lifecycle.ScheduledSlowlyClosingAlarm;
import com.intellij.lifecycle.SlowlyClosingAlarm;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class ControlledAlarmFactory {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lifecycle.ControlledAlarmFactory");

    private ControlledAlarmFactory() {
    }

    public static SlowlyClosingAlarm createOnOwnThread(@NotNull Project project, @NotNull String name) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lifecycle/ControlledAlarmFactory.createOnOwnThread must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/lifecycle/ControlledAlarmFactory.createOnOwnThread must not be null");
        }
        return new SlowlyClosingAlarm(project, name);
    }

    public static SlowlyClosingAlarm createOnSharedThread(@NotNull Project project, @NotNull String name, @NotNull ExecutorService executor) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lifecycle/ControlledAlarmFactory.createOnSharedThread must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/lifecycle/ControlledAlarmFactory.createOnSharedThread must not be null");
        }
        if (executor == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/lifecycle/ControlledAlarmFactory.createOnSharedThread must not be null");
        }
        return new SlowlyClosingAlarm(project, name, ControlledAlarmFactory.createExecutorWrapper(executor), true);
    }

    public static ScheduledSlowlyClosingAlarm createScheduledOnSharedThread(@NotNull Project project, @NotNull String name, @NotNull ScheduledExecutorService executor) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lifecycle/ControlledAlarmFactory.createScheduledOnSharedThread must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/lifecycle/ControlledAlarmFactory.createScheduledOnSharedThread must not be null");
        }
        if (executor == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/lifecycle/ControlledAlarmFactory.createScheduledOnSharedThread must not be null");
        }
        return new ScheduledSlowlyClosingAlarm(project, name, new MyScheduledExecutorServiceWrapper(executor), true);
    }

    public static SlowlyClosingAlarm createOnApplicationPooledThread(@NotNull Project project, @NotNull String name) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lifecycle/ControlledAlarmFactory.createOnApplicationPooledThread must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/lifecycle/ControlledAlarmFactory.createOnApplicationPooledThread must not be null");
        }
        return new SlowlyClosingAlarm(project, name, new MyApplicationPooledThreadExecutorWrapper(), true);
    }

    static MyExecutorWrapper createExecutorWrapper(ExecutorService executorService) {
        return new MyExecutorServiceWrapper(executorService);
    }

    public static ProgressIndicator createProgressIndicator(final AtomicSectionsAware atomicSectionsAware) {
        return new EmptyProgressIndicator(){

            public boolean isCanceled() {
                return atomicSectionsAware.shouldExitAsap();
            }

            public void checkCanceled() {
                atomicSectionsAware.checkShouldExit();
            }
        };
    }

    private static class MyApplicationPooledThreadExecutorWrapper
    implements MyExecutorWrapper {
        private Application myApplication = ApplicationManager.getApplication();

        private MyApplicationPooledThreadExecutorWrapper() {
        }

        @Override
        public Future<?> submit(Runnable runnable) {
            return this.myApplication.executeOnPooledThread(runnable);
        }

        @Override
        public void shutdown() {
        }

        @Override
        public Future<?> schedule(Runnable runnable, long delay, TimeUnit timeUnit) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean supportsScheduling() {
            return false;
        }
    }

    private static class MyScheduledExecutorServiceWrapper
    implements MyExecutorWrapper {
        private final ScheduledExecutorService myScheduledExecutorService;

        public MyScheduledExecutorServiceWrapper(ScheduledExecutorService scheduledExecutorService) {
            this.myScheduledExecutorService = scheduledExecutorService;
        }

        @Override
        public Future<?> submit(Runnable runnable) {
            return this.myScheduledExecutorService.submit(runnable);
        }

        @Override
        public void shutdown() {
            this.myScheduledExecutorService.shutdown();
        }

        @Override
        public Future<?> schedule(Runnable runnable, long delay, TimeUnit timeUnit) {
            return this.myScheduledExecutorService.schedule(runnable, delay, timeUnit);
        }

        @Override
        public boolean supportsScheduling() {
            return true;
        }
    }

    private static class MyExecutorServiceWrapper
    implements MyExecutorWrapper {
        private final ExecutorService myExecutorService;

        public MyExecutorServiceWrapper(ExecutorService executorService) {
            this.myExecutorService = executorService;
        }

        @Override
        public Future<?> submit(Runnable runnable) {
            return this.myExecutorService.submit(runnable);
        }

        @Override
        public void shutdown() {
            this.myExecutorService.shutdown();
        }

        @Override
        public Future<?> schedule(Runnable runnable, long delay, TimeUnit timeUnit) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean supportsScheduling() {
            return false;
        }
    }

    static interface MyExecutorWrapper {
        public Future<?> submit(Runnable var1);

        public void shutdown();

        public Future<?> schedule(Runnable var1, long var2, TimeUnit var4);

        public boolean supportsScheduling();
    }
}

