/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scopeView;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.SelectInTarget;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.ide.scopeView.ScopePaneSelectInTarget;
import com.intellij.ide.scopeView.ScopeTreeViewPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.packageDependencies.ui.PackageDependenciesNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopeManager;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.ui.PopupHandler;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ScopeViewPane
extends AbstractProjectViewPane {
    @NonNls
    public static final String ID = "Scope";
    private final ProjectView myProjectView;
    private ScopeTreeViewPanel myViewPanel;
    private final DependencyValidationManager myDependencyValidationManager;
    private final NamedScopeManager myNamedScopeManager;
    private final NamedScopesHolder.ScopeListener myScopeListener;
    public static final Icon ICON = IconLoader.getIcon((String)"/general/ideOptions.png");

    public ScopeViewPane(Project project, ProjectView projectView, DependencyValidationManager dependencyValidationManager, NamedScopeManager namedScopeManager) {
        super(project);
        this.myProjectView = projectView;
        this.myDependencyValidationManager = dependencyValidationManager;
        this.myNamedScopeManager = namedScopeManager;
        this.myScopeListener = new NamedScopesHolder.ScopeListener(){
            Alarm refreshProjectViewAlarm = new Alarm();

            public void scopesChanged() {
                this.refreshProjectViewAlarm.cancelAllRequests();
                this.refreshProjectViewAlarm.addRequest(new Runnable(){

                    @Override
                    public void run() {
                        if (ScopeViewPane.this.myProject.isDisposed()) {
                            return;
                        }
                        ScopeViewPane.this.myProjectView.removeProjectPane(ScopeViewPane.this);
                        ScopeViewPane.this.myProjectView.addProjectPane(ScopeViewPane.this);
                    }
                }, 10);
            }
        };
        this.myDependencyValidationManager.addScopeListener(this.myScopeListener);
        this.myNamedScopeManager.addScopeListener(this.myScopeListener);
    }

    @Override
    public String getTitle() {
        return IdeBundle.message((String)"scope.view.title", (Object[])new Object[0]);
    }

    @Override
    public Icon getIcon() {
        return ICON;
    }

    @Override
    @NotNull
    public String getId() {
        if (ID == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/scopeView/ScopeViewPane.getId must not return null");
        }
        return ID;
    }

    @Override
    public JComponent createComponent() {
        this.myViewPanel = new ScopeTreeViewPanel(this.myProject);
        Disposer.register((Disposable)this, (Disposable)this.myViewPanel);
        this.myViewPanel.initListeners();
        this.updateFromRoot(true);
        this.myTree = this.myViewPanel.getTree();
        PopupHandler.installPopupHandler((JComponent)((Object)this.myTree), (String)"ScopeViewPopupMenu", (String)"ScopeViewPopup");
        this.enableDnD();
        return this.myViewPanel.getPanel();
    }

    @Override
    public void dispose() {
        this.myViewPanel = null;
        this.myDependencyValidationManager.removeScopeListener(this.myScopeListener);
        this.myNamedScopeManager.removeScopeListener(this.myScopeListener);
        super.dispose();
    }

    @Override
    @NotNull
    public String[] getSubIds() {
        Object[] scopes = this.myDependencyValidationManager.getScopes();
        scopes = (NamedScope[])ArrayUtil.mergeArrays((Object[])scopes, (Object[])this.myNamedScopeManager.getScopes(), NamedScope.class);
        String[] ids = new String[scopes.length];
        for (int i = 0; i < scopes.length; ++i) {
            Object scope = scopes[i];
            ids[i] = scope.getName();
        }
        if (ids == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/scopeView/ScopeViewPane.getSubIds must not return null");
        }
        return ids;
    }

    @Override
    @NotNull
    public String getPresentableSubIdName(@NotNull String subId) {
        if (subId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/scopeView/ScopeViewPane.getPresentableSubIdName must not be null");
        }
        String string = subId;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/scopeView/ScopeViewPane.getPresentableSubIdName must not return null");
        }
        return string;
    }

    @Override
    public void addToolbarActions(DefaultActionGroup actionGroup) {
        actionGroup.add(ActionManager.getInstance().getAction("ScopeView.EditScopes"));
    }

    @Override
    public ActionCallback updateFromRoot(boolean restoreExpandedPaths) {
        this.myViewPanel.selectScope(NamedScopesHolder.getScope((Project)this.myProject, (String)this.getSubId()));
        return new ActionCallback.Done();
    }

    @Override
    public void select(Object element, VirtualFile file, boolean requestFocus) {
        String name;
        if (file == null) {
            return;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file);
        if (psiFile == null) {
            return;
        }
        if (!(element instanceof PsiElement)) {
            return;
        }
        ArrayList<Object> allScopes = new ArrayList<Object>();
        allScopes.addAll(Arrays.asList(this.myDependencyValidationManager.getScopes()));
        allScopes.addAll(Arrays.asList(this.myNamedScopeManager.getScopes()));
        for (int i = 0; i < allScopes.size(); ++i) {
            NamedScope namedScope = (NamedScope)allScopes.get(i);
            name = namedScope.getName();
            if (!name.equals(this.getSubId())) continue;
            allScopes.set(i, allScopes.get(0));
            allScopes.set(0, namedScope);
            break;
        }
        for (NamedScope namedScope : allScopes) {
            name = namedScope.getName();
            PackageSet packageSet = namedScope.getValue();
            if (packageSet == null || !this.changeView(packageSet, (PsiElement)element, psiFile, name, (NamedScopesHolder)this.myNamedScopeManager, requestFocus) && !this.changeView(packageSet, (PsiElement)element, psiFile, name, (NamedScopesHolder)this.myDependencyValidationManager, requestFocus)) continue;
            break;
        }
    }

    private boolean changeView(PackageSet packageSet, PsiElement element, PsiFile psiFile, String name, NamedScopesHolder holder, boolean requestFocus) {
        if (packageSet.contains(psiFile, holder)) {
            if (!name.equals(this.getSubId())) {
                this.myProjectView.changeView(this.getId(), name);
            }
            this.myViewPanel.selectNode(element, psiFile, requestFocus);
            return true;
        }
        return false;
    }

    @Override
    public int getWeight() {
        return 3;
    }

    @Override
    public void installComparator() {
        this.myViewPanel.setSortByType();
    }

    @Override
    public SelectInTarget createSelectInTarget() {
        return new ScopePaneSelectInTarget(this.myProject);
    }

    @Override
    protected Object exhumeElementFromNode(DefaultMutableTreeNode node) {
        if (node instanceof PackageDependenciesNode) {
            return ((PackageDependenciesNode)node).getPsiElement();
        }
        return super.exhumeElementFromNode(node);
    }

    @Override
    public Object getData(String dataId) {
        Object data = super.getData(dataId);
        if (data != null) {
            return data;
        }
        return this.myViewPanel != null ? this.myViewPanel.getData(dataId) : null;
    }
}

