/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.ui.UIUtil;
import java.awt.event.KeyEvent;
import javax.swing.plaf.TreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public abstract class ProjectViewTree
extends DnDAwareTree {
    protected ProjectViewTree(TreeModel newModel) {
        super(newModel);
        if (SystemInfo.isMac) {
            this.setUI((TreeUI)new UIUtil.LeglessTreeUi());
        }
        NodeRenderer renderer = new NodeRenderer();
        renderer.setOpaque(false);
        renderer.setIconOpaque(false);
        this.setCellRenderer((TreeCellRenderer)renderer);
    }

    public void setUI(TreeUI ui) {
        TreeUI actualUI = ui;
        if (SystemInfo.isMac && !(ui instanceof UIUtil.LeglessTreeUi)) {
            actualUI = new UIUtil.LeglessTreeUi();
        }
        super.setUI(actualUI);
    }

    public void processKeyEvent(KeyEvent e) {
        TreePath path = this.getSelectionPath();
        if (path != null) {
            if (e.getKeyCode() == 37) {
                if (this.isExpanded(path)) {
                    this.collapsePath(path);
                    return;
                }
            } else if (e.getKeyCode() == 39 && this.isCollapsed(path)) {
                this.expandPath(path);
                return;
            }
        }
        super.processKeyEvent(e);
    }

    public final int getToggleClickCount() {
        NodeDescriptor descriptor;
        Object userObject;
        DefaultMutableTreeNode node = this.getSelectedNode();
        if (node != null && (userObject = node.getUserObject()) instanceof NodeDescriptor && !(descriptor = (NodeDescriptor)userObject).expandOnDoubleClick()) {
            return -1;
        }
        return super.getToggleClickCount();
    }

    public abstract DefaultMutableTreeNode getSelectedNode();
}

