/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates;

import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.util.Key;
import java.util.Collection;
import java.util.Properties;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class FileTemplateManager {
    public static final Key<Properties> DEFAULT_TEMPLATE_PROPERTIES = Key.create((String)"DEFAULT_TEMPLATE_PROPERTIES");
    public static final int RECENT_TEMPLATES_SIZE = 25;
    @NonNls
    public static final String INTERNAL_HTML_TEMPLATE_NAME = "Html";
    @NonNls
    public static final String INTERNAL_XHTML_TEMPLATE_NAME = "Xhtml";
    @NonNls
    public static final String FILE_HEADER_TEMPLATE_NAME = "File Header";

    public static FileTemplateManager getInstance() {
        return (FileTemplateManager)ServiceManager.getService(FileTemplateManager.class);
    }

    @NotNull
    public abstract FileTemplate[] getAllTemplates();

    public abstract FileTemplate getTemplate(@NotNull @NonNls String var1);

    @NotNull
    public abstract Properties getDefaultProperties();

    @NotNull
    public abstract FileTemplate addTemplate(@NotNull @NonNls String var1, @NotNull @NonNls String var2);

    public abstract void removeTemplate(@NotNull FileTemplate var1, boolean var2);

    public abstract void removeInternal(@NotNull FileTemplate var1);

    @NotNull
    public abstract Collection<String> getRecentNames();

    public abstract void addRecentName(@NotNull @NonNls String var1);

    public abstract void saveAll();

    public abstract FileTemplate getInternalTemplate(@NotNull @NonNls String var1);

    @NotNull
    public abstract FileTemplate[] getInternalTemplates();

    public abstract FileTemplate getJ2eeTemplate(@NotNull @NonNls String var1);

    public abstract FileTemplate getCodeTemplate(@NotNull @NonNls String var1);

    @NotNull
    public abstract FileTemplate[] getAllPatterns();

    public abstract FileTemplate addPattern(@NotNull @NonNls String var1, @NotNull @NonNls String var2);

    @NotNull
    public abstract FileTemplate[] getAllCodeTemplates();

    @NotNull
    public abstract FileTemplate[] getAllJ2eeTemplates();

    @NotNull
    public abstract FileTemplate addCodeTemplate(@NotNull @NonNls String var1, @NotNull @NonNls String var2);

    @NotNull
    public abstract FileTemplate addJ2eeTemplate(@NotNull @NonNls String var1, @NotNull @NonNls String var2);

    public abstract void removePattern(@NotNull FileTemplate var1, boolean var2);

    public abstract void removeCodeTemplate(@NotNull FileTemplate var1, boolean var2);

    public abstract void removeJ2eeTemplate(@NotNull FileTemplate var1, boolean var2);

    @NotNull
    public abstract String internalTemplateToSubject(@NotNull @NonNls String var1);

    @NotNull
    public abstract String localizeInternalTemplateName(FileTemplate var1);

    public abstract FileTemplate getPattern(@NotNull @NonNls String var1);

    @NotNull
    public abstract FileTemplate getDefaultTemplate(@NotNull @NonNls String var1);

    public abstract FileTemplate addInternal(@NotNull @NonNls String var1, @NotNull @NonNls String var2);
}

