/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;

public class CloseEditorAction
extends AnAction
implements DumbAware {
    public void actionPerformed(AnActionEvent e) {
        VirtualFile file;
        Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
        FileEditorManagerEx editorManager = (FileEditorManagerEx)FileEditorManager.getInstance((Project)project);
        EditorWindow window = (EditorWindow)e.getData(EditorWindow.DATA_KEY);
        if (window == null) {
            window = editorManager.getCurrentWindow();
            file = window.getSelectedFile();
        } else {
            file = (VirtualFile)e.getData(PlatformDataKeys.VIRTUAL_FILE);
        }
        if (file != null) {
            editorManager.closeFile(file, window);
        }
    }

    public void update(AnActionEvent event) {
        EditorWindow window;
        Presentation presentation = event.getPresentation();
        Project project = (Project)event.getData(PlatformDataKeys.PROJECT);
        if (project == null) {
            presentation.setEnabled(false);
            return;
        }
        if ("EditorPopup".equals(event.getPlace()) || "EditorTabPopup".equals(event.getPlace())) {
            presentation.setText(IdeBundle.message((String)"action.close", (Object[])new Object[0]));
        }
        if ((window = (EditorWindow)event.getData(EditorWindow.DATA_KEY)) == null) {
            window = ((FileEditorManagerEx)FileEditorManager.getInstance((Project)project)).getCurrentWindow();
        }
        presentation.setEnabled(window != null && window.getTabCount() > 0);
    }
}

