/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core.storage;

import com.intellij.history.core.storage.Stream;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.integration.IdeaGateway;
import java.io.IOException;

public abstract class Content {
    public void write(Stream s) throws IOException {
    }

    public abstract byte[] getBytes();

    public byte[] getBytesIfAvailable() {
        return this.isAvailable() ? this.getBytes() : null;
    }

    public String getString(Entry e, IdeaGateway gw) {
        return gw.stringFromBytes(this.getBytes(), e.getPath());
    }

    public abstract boolean isAvailable();

    public abstract void purge();

    public String toString() {
        return new String(this.getBytes());
    }

    public boolean equals(Object o) {
        return o != null && this.getClass().equals(o.getClass());
    }
}

