/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting.templateLanguages;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.templateLanguages.BlockUtil;
import com.intellij.formatting.templateLanguages.BlockWithParent;
import com.intellij.formatting.templateLanguages.TemplateLanguageBlock;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.formatter.common.AbstractBlock;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataLanguageBlockWrapper
implements ASTBlock,
BlockWithParent {
    private final Block myOriginal;
    private final Indent myIndent;
    private List<Block> myBlocks;
    private List<TemplateLanguageBlock> myTlBlocks;
    private BlockWithParent myParent;
    private DataLanguageBlockWrapper myRightHandWrapper;
    private Spacing mySpacing;

    private DataLanguageBlockWrapper(@NotNull Block original, @Nullable Indent indent) {
        if (original == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/formatting/templateLanguages/DataLanguageBlockWrapper.<init> must not be null");
        }
        assert (!(original instanceof DataLanguageBlockWrapper) && !(original instanceof TemplateLanguageBlock));
        this.myOriginal = original;
        this.myIndent = indent;
    }

    @NotNull
    public TextRange getTextRange() {
        TextRange textRange = this.myOriginal.getTextRange();
        if (textRange == null) {
            throw new IllegalStateException("@NotNull method com/intellij/formatting/templateLanguages/DataLanguageBlockWrapper.getTextRange must not return null");
        }
        return textRange;
    }

    @NotNull
    public List<Block> getSubBlocks() {
        if (this.myBlocks == null) {
            this.myBlocks = this.buildBlocks();
        }
        List<Block> list = this.myBlocks;
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/formatting/templateLanguages/DataLanguageBlockWrapper.getSubBlocks must not return null");
        }
        return list;
    }

    private List<Block> buildBlocks() {
        assert (this.myBlocks == null);
        if (this.isLeaf()) {
            return AbstractBlock.EMPTY;
        }
        List<DataLanguageBlockWrapper> subWrappers = BlockUtil.buildChildWrappers(this.myOriginal);
        List<ASTBlock> children = this.myTlBlocks == null ? new ArrayList<DataLanguageBlockWrapper>(subWrappers) : (subWrappers.size() == 0 ? (subWrappers.size() > 0 ? this.myTlBlocks : BlockUtil.splitBlockIntoFragments(this.myOriginal, this.myTlBlocks)) : BlockUtil.mergeBlocks(this.myTlBlocks, subWrappers));
        return BlockUtil.setParent(children, this);
    }

    public Wrap getWrap() {
        return this.myOriginal.getWrap();
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        ChildAttributes childAttributes = this.myOriginal.getChildAttributes(newChildIndex);
        if (childAttributes == null) {
            throw new IllegalStateException("@NotNull method com/intellij/formatting/templateLanguages/DataLanguageBlockWrapper.getChildAttributes must not return null");
        }
        return childAttributes;
    }

    public Indent getIndent() {
        return this.myOriginal.getIndent();
    }

    public Alignment getAlignment() {
        return this.myOriginal.getAlignment();
    }

    @Nullable
    public Spacing getSpacing(Block child1, Block child2) {
        if (child1 instanceof DataLanguageBlockWrapper && child2 instanceof DataLanguageBlockWrapper) {
            return this.myOriginal.getSpacing(((DataLanguageBlockWrapper)child1).myOriginal, ((DataLanguageBlockWrapper)child2).myOriginal);
        }
        return null;
    }

    public boolean isIncomplete() {
        return this.myOriginal.isIncomplete();
    }

    public boolean isLeaf() {
        return this.myTlBlocks == null && this.myOriginal.isLeaf();
    }

    void addTlChild(TemplateLanguageBlock tlBlock) {
        assert (this.myBlocks == null);
        if (this.myTlBlocks == null) {
            this.myTlBlocks = new ArrayList<TemplateLanguageBlock>(5);
        }
        this.myTlBlocks.add(tlBlock);
        tlBlock.setParent(this);
    }

    Block getOriginal() {
        return this.myOriginal;
    }

    public String toString() {
        String tlBlocksInfo = " TlBlocks " + (this.myTlBlocks == null ? "0" : Integer.valueOf(this.myTlBlocks.size())) + "|" + this.getTextRange() + "|";
        return tlBlocksInfo + this.myOriginal.toString();
    }

    @Nullable
    public static DataLanguageBlockWrapper create(@NotNull Block original, @Nullable Indent indent) {
        if (original == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/formatting/templateLanguages/DataLanguageBlockWrapper.create must not be null");
        }
        boolean doesntNeedWrapper = original instanceof ASTBlock && ((ASTBlock)original).getNode() instanceof OuterLanguageElement;
        return doesntNeedWrapper ? null : new DataLanguageBlockWrapper(original, indent);
    }

    @Nullable
    public ASTNode getNode() {
        return this.myOriginal instanceof ASTBlock ? ((ASTBlock)this.myOriginal).getNode() : null;
    }

    @Override
    public BlockWithParent getParent() {
        return this.myParent;
    }

    @Override
    public void setParent(BlockWithParent parent) {
        this.myParent = parent;
    }

    public void setRightHandSpacing(DataLanguageBlockWrapper rightHandWrapper, Spacing spacing) {
        this.myRightHandWrapper = rightHandWrapper;
        this.mySpacing = spacing;
    }

    @Nullable
    public Spacing getRightHandSpacing(DataLanguageBlockWrapper rightHandWrapper) {
        return this.myRightHandWrapper == rightHandWrapper ? this.mySpacing : null;
    }
}

