/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Block;
import com.intellij.lang.ASTNode;
import java.io.PrintStream;
import java.util.List;

public class BlockDebugUtil {
    public static void dumpBlockTree(PrintStream out, Block block) {
        out.println("--- BLOCK TREE DUMP ---");
        BlockDebugUtil.dumpBlockTree(out, block, "", true);
        out.println("--- END OF DUMP ---\n\n");
    }

    public static void dumpBlock(PrintStream out, Block block) {
        BlockDebugUtil.dumpBlockTree(out, block, "", false);
    }

    private static void dumpBlockTree(PrintStream out, Block block, String indent, boolean withChildren) {
        List<Block> subBlocks;
        ASTNode node;
        if (block == null) {
            return;
        }
        out.print(indent + block.getClass().getSimpleName());
        if (block.getIndent() != null) {
            out.print(" " + block.getIndent());
        } else {
            out.print(" <NO INDENT>");
        }
        out.print(" " + block.getTextRange() + " ");
        if (block instanceof ASTBlock && (node = ((ASTBlock)block).getNode()) != null) {
            out.print(" " + node.getElementType());
            String text = node.getText();
            int eolPos = text.indexOf(10);
            if (eolPos > 0) {
                text = text.substring(0, eolPos) + "...";
            }
            out.print(" \"" + text + "\"");
        }
        out.println();
        if (withChildren && (subBlocks = BlockDebugUtil.getSubBlocks(block)) != null && subBlocks.size() > 0) {
            out.println(indent + "{");
            for (Block child : subBlocks) {
                BlockDebugUtil.dumpBlockTree(out, child, indent + "    ", true);
            }
            out.println(indent + "}");
        }
    }

    private static List<Block> getSubBlocks(Block root) {
        return root.getSubBlocks();
    }
}

