/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl.ui.actions;

import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeRegistry;
import com.intellij.facet.impl.ui.FacetEditorFacade;
import com.intellij.facet.impl.ui.actions.AddFacetAction;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import java.util.Arrays;
import java.util.Comparator;
import org.jetbrains.annotations.Nullable;

public class AddFacetActionGroup
extends ActionGroup {
    private final boolean myFromPopup;
    private final FacetEditorFacade myEditor;
    private AnAction[] myCachedChildren;

    public AddFacetActionGroup(String groupName, boolean fromPopup, FacetEditorFacade editor) {
        super(groupName, true);
        this.myFromPopup = fromPopup;
        this.myEditor = editor;
    }

    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        if (this.myCachedChildren == null) {
            FacetType[] types = FacetTypeRegistry.getInstance().getFacetTypes();
            Arrays.sort(types, new Comparator<FacetType>(){

                @Override
                public int compare(FacetType o1, FacetType o2) {
                    return o1.getPresentableName().compareTo(o2.getPresentableName());
                }
            });
            this.myCachedChildren = new AnAction[types.length];
            for (int i = 0; i < types.length; ++i) {
                this.myCachedChildren[i] = new AddFacetAction(this.myEditor, types[i]);
            }
        }
        return this.myCachedChildren;
    }

    public void update(AnActionEvent e) {
        boolean visible = this.isVisible();
        if (this.myFromPopup) {
            e.getPresentation().setVisible(visible);
        } else {
            e.getPresentation().setEnabled(visible);
        }
    }

    private boolean isVisible() {
        for (FacetType type : FacetTypeRegistry.getInstance().getFacetTypes()) {
            if (!AddFacetAction.isVisible(this.myEditor, type)) continue;
            return true;
        }
        return false;
    }
}

