/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner.ui.statistics;

import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.execution.testframework.TestsUIUtil;
import com.intellij.execution.testframework.sm.SMRunnerUtil;
import com.intellij.execution.testframework.sm.runner.SMTRunnerEventsAdapter;
import com.intellij.execution.testframework.sm.runner.SMTRunnerEventsListener;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.sm.runner.ui.PropagateSelectionHandler;
import com.intellij.execution.testframework.sm.runner.ui.statistics.ColumnTest;
import com.intellij.execution.testframework.sm.runner.ui.statistics.StatisticsTableModel;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.TableUtil;
import com.intellij.ui.table.TableView;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.ListTableModel;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StatisticsPanel
implements DataProvider {
    public static final Icon STATISTICS_TAB_ICON = TestsUIUtil.loadIcon("testStatistics");
    public static final DataKey<StatisticsPanel> SM_TEST_RUNNER_STATISTICS = DataKey.create((String)"SM_TEST_RUNNER_STATISTICS");
    private TableView<SMTestProxy> myStatisticsTableView;
    private JPanel myContentPane;
    private final StatisticsTableModel myTableModel;
    private final List<PropagateSelectionHandler> myPropagateSelectionHandlers;
    private final Project myProject;
    private final TestFrameworkRunningModel myFrameworkRunningModel;

    public StatisticsPanel(Project project, TestFrameworkRunningModel model) {
        this.$$$setupUI$$$();
        this.myPropagateSelectionHandlers = new ArrayList<PropagateSelectionHandler>();
        this.myProject = project;
        this.myTableModel = new StatisticsTableModel();
        this.myStatisticsTableView.setModel((ListTableModel)this.myTableModel);
        this.myFrameworkRunningModel = model;
        final Runnable gotoSuiteOrParentAction = this.createGotoSuiteOrParentAction();
        this.myStatisticsTableView.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    gotoSuiteOrParentAction.run();
                }
            }
        });
        KeyStroke shiftEnterKey = KeyStroke.getKeyStroke(10, 1);
        SMRunnerUtil.registerAsAction(shiftEnterKey, "select-test-proxy-in-test-view", new Runnable(){

            @Override
            public void run() {
                StatisticsPanel.this.showSelectedProxyInTestsTree();
            }
        }, this.myStatisticsTableView);
        KeyStroke enterKey = KeyStroke.getKeyStroke(10, 0);
        SMRunnerUtil.registerAsAction(enterKey, "go-to-selected-suite-or-parent", gotoSuiteOrParentAction, this.myStatisticsTableView);
        PopupHandler.installPopupHandler(this.myStatisticsTableView, (String)"TestTreePopupMenu", (String)"TestTreeViewPopup");
        this.myStatisticsTableView.putClientProperty((Object)"DataProvider", (Object)this);
    }

    public void addPropagateSelectionListener(PropagateSelectionHandler handler) {
        this.myPropagateSelectionHandlers.add(handler);
    }

    public JPanel getContentPane() {
        return this.myContentPane;
    }

    public SMTRunnerEventsListener createTestEventsListener() {
        return new SMTRunnerEventsAdapter(){

            @Override
            public void onSuiteStarted(@NotNull SMTestProxy suite) {
                if (suite == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/testframework/sm/runner/ui/statistics/StatisticsPanel$3.onSuiteStarted must not be null");
                }
                if (StatisticsPanel.this.myTableModel.shouldUpdateModelBySuite(suite)) {
                    this.updateAndRestoreSelection();
                }
            }

            @Override
            public void onSuiteFinished(@NotNull SMTestProxy suite) {
                if (suite == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/testframework/sm/runner/ui/statistics/StatisticsPanel$3.onSuiteFinished must not be null");
                }
                if (StatisticsPanel.this.myTableModel.shouldUpdateModelBySuite(suite)) {
                    this.updateAndRestoreSelection();
                }
            }

            @Override
            public void onTestStarted(@NotNull SMTestProxy test) {
                if (test == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/testframework/sm/runner/ui/statistics/StatisticsPanel$3.onTestStarted must not be null");
                }
                if (StatisticsPanel.this.myTableModel.shouldUpdateModelByTest(test)) {
                    this.updateAndRestoreSelection();
                }
            }

            @Override
            public void onTestFinished(@NotNull SMTestProxy test) {
                if (test == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/testframework/sm/runner/ui/statistics/StatisticsPanel$3.onTestFinished must not be null");
                }
                if (StatisticsPanel.this.myTableModel.shouldUpdateModelByTest(test)) {
                    this.updateAndRestoreSelection();
                }
            }

            private void updateAndRestoreSelection() {
                SMRunnerUtil.addToInvokeLater(new Runnable(){

                    @Override
                    public void run() {
                        int newRow;
                        SMTestProxy oldSelection = (SMTestProxy)StatisticsPanel.this.myStatisticsTableView.getSelectedObject();
                        StatisticsPanel.this.myTableModel.updateModel();
                        if (oldSelection != null && (newRow = StatisticsPanel.this.myTableModel.getIndexOf(oldSelection)) > -1) {
                            StatisticsPanel.this.myStatisticsTableView.setRowSelectionInterval(newRow, newRow);
                        }
                    }
                });
            }
        };
    }

    public Object getData(@NonNls String dataId) {
        if (SM_TEST_RUNNER_STATISTICS.is(dataId)) {
            return this;
        }
        return TestsUIUtil.getData(this.getSelectedItem(), dataId, this.myFrameworkRunningModel);
    }

    public PropagateSelectionHandler createSelectMeListener() {
        return new PropagateSelectionHandler(){

            @Override
            public void handlePropagateSelectionRequest(@Nullable SMTestProxy selectedTestProxy, @NotNull Object sender, boolean requestFocus) {
                if (sender == null) {
                    throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/execution/testframework/sm/runner/ui/statistics/StatisticsPanel$4.handlePropagateSelectionRequest must not be null");
                }
                StatisticsPanel.this.selectProxy(selectedTestProxy, sender, requestFocus);
            }
        };
    }

    public void selectProxy(final @Nullable SMTestProxy selectedTestProxy, @NotNull Object sender, final boolean requestFocus) {
        if (sender == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/execution/testframework/sm/runner/ui/statistics/StatisticsPanel.selectProxy must not be null");
        }
        SMRunnerUtil.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                if (requestFocus) {
                    IdeFocusManager.getInstance((Project)StatisticsPanel.this.myProject).requestFocus((Component)StatisticsPanel.this.myStatisticsTableView, true);
                }
                StatisticsPanel.this.selectProxy(selectedTestProxy);
            }
        });
    }

    protected void showSelectedProxyInTestsTree() {
        Collection proxies = this.myStatisticsTableView.getSelection();
        if (proxies.isEmpty()) {
            return;
        }
        SMTestProxy proxy = (SMTestProxy)proxies.iterator().next();
        this.myStatisticsTableView.clearSelection();
        this.fireOnPropagateSelection(proxy);
    }

    protected Runnable createGotoSuiteOrParentAction() {
        return new Runnable(){

            @Override
            public void run() {
                SMTestProxy selectedProxy = StatisticsPanel.this.getSelectedItem();
                if (selectedProxy == null) {
                    return;
                }
                int i = StatisticsPanel.this.myStatisticsTableView.getSelectedRow();
                assert (i >= 0);
                if (ColumnTest.TestsCellRenderer.isFirstLine(i)) {
                    SMTestProxy parentSuite = selectedProxy.getParent();
                    if (parentSuite != null) {
                        StatisticsPanel.this.showInTableAndSelectRow(parentSuite, selectedProxy);
                    }
                } else if (selectedProxy.isSuite()) {
                    StatisticsPanel.this.showInTableAndSelectRow(selectedProxy, selectedProxy);
                }
            }
        };
    }

    protected void selectProxy(@Nullable SMTestProxy selectedTestProxy) {
        this.myTableModel.updateModelOnProxySelected(selectedTestProxy);
        if (selectedTestProxy != null) {
            this.findAndSelectInTable(selectedTestProxy);
        }
    }

    protected void selectRow(final int rowIndex) {
        SMRunnerUtil.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                StatisticsPanel.this.myStatisticsTableView.setRowSelectionInterval(rowIndex, rowIndex);
                TableUtil.scrollSelectionToVisible((JTable)StatisticsPanel.this.myStatisticsTableView);
            }
        });
    }

    protected void selectRowOf(final SMTestProxy proxy) {
        SMRunnerUtil.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                int rowIndex = StatisticsPanel.this.myTableModel.getIndexOf(proxy);
                StatisticsPanel.this.myStatisticsTableView.setRowSelectionInterval(rowIndex, rowIndex >= 0 ? rowIndex : 0);
                TableUtil.scrollSelectionToVisible((JTable)StatisticsPanel.this.myStatisticsTableView);
            }
        });
    }

    @Nullable
    protected SMTestProxy getSelectedItem() {
        return (SMTestProxy)this.myStatisticsTableView.getSelectedObject();
    }

    protected List<SMTestProxy> getTableItems() {
        return this.myTableModel.getItems();
    }

    private void findAndSelectInTable(final SMTestProxy proxy) {
        SMRunnerUtil.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                int rowIndex = StatisticsPanel.this.myTableModel.getIndexOf(proxy);
                if (rowIndex >= 0) {
                    StatisticsPanel.this.myStatisticsTableView.setRowSelectionInterval(rowIndex, rowIndex);
                }
            }
        });
    }

    private void fireOnPropagateSelection(SMTestProxy selectedTestProxy) {
        for (PropagateSelectionHandler handler : this.myPropagateSelectionHandlers) {
            handler.handlePropagateSelectionRequest(selectedTestProxy, this, true);
        }
    }

    private void createUIComponents() {
        this.myStatisticsTableView = new TableView();
    }

    private void showInTableAndSelectRow(SMTestProxy suite, SMTestProxy suiteProxy) {
        this.selectProxy(suite);
        this.selectRowOf(suiteProxy);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        this.createUIComponents();
        this.myContentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JScrollPane jScrollPane = new JScrollPane();
        jPanel.add((Component)jScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        TableView<SMTestProxy> tableView = this.myStatisticsTableView;
        tableView.setShowVerticalLines(true);
        jScrollPane.setViewportView((Component)tableView);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }
}

