/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.actions;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionUtil;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.PreferedProducerFind;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.LocatableConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.execution.junit.RuntimeConfigurationProducer;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.awt.RelativePoint;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseRunConfigurationAction
extends ActionGroup {
    private static final Logger LOG = Logger.getInstance((String)("#" + BaseRunConfigurationAction.class.getName()));

    protected BaseRunConfigurationAction(String text, String description, Icon icon) {
        super(text, description, icon);
        this.setPopup(true);
    }

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        AnAction[] anActionArray = e != null ? this.getChildren(e.getDataContext()) : EMPTY_ARRAY;
        if (anActionArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/execution/actions/BaseRunConfigurationAction.getChildren must not return null");
        }
        return anActionArray;
    }

    private AnAction[] getChildren(DataContext dataContext) {
        List<RuntimeConfigurationProducer> producers;
        final ConfigurationContext context = new ConfigurationContext(dataContext);
        RunnerAndConfigurationSettingsImpl existing = context.findExisting();
        if (existing == null && (producers = this.getEnabledProducers(context)).size() > 1) {
            AnAction[] children = new AnAction[producers.size()];
            int chldIdx = 0;
            for (final RuntimeConfigurationProducer producer : producers) {
                ConfigurationType configurationType = producer.getConfigurationType();
                RunConfiguration configuration = producer.getConfiguration().getConfiguration();
                String actionName = configuration instanceof LocatableConfiguration ? StringUtil.unquoteString((String)BaseRunConfigurationAction.suggestRunActionName((LocatableConfiguration)configuration)) : configurationType.getDisplayName();
                children[chldIdx++] = new AnAction(actionName, configurationType.getDisplayName(), configurationType.getIcon()){

                    public void actionPerformed(AnActionEvent e) {
                        BaseRunConfigurationAction.this.perform(producer, context);
                    }
                };
            }
            return children;
        }
        return EMPTY_ARRAY;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private List<RuntimeConfigurationProducer> getEnabledProducers(ConfigurationContext context) {
        List<RuntimeConfigurationProducer> list;
        List<RuntimeConfigurationProducer> preferred = PreferedProducerFind.findPreferredProducers(context.getLocation(), context, true);
        if (preferred == null) {
            list = Collections.emptyList();
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/execution/actions/BaseRunConfigurationAction.getEnabledProducers must not return null");
            return list;
        }
        ArrayList<RuntimeConfigurationProducer> producers = new ArrayList<RuntimeConfigurationProducer>();
        for (RuntimeConfigurationProducer producer : preferred) {
            if (!this.isEnabledFor(producer.getConfiguration().getConfiguration())) continue;
            producers.add(producer);
        }
        list = producers;
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/execution/actions/BaseRunConfigurationAction.getEnabledProducers must not return null");
    }

    protected boolean isEnabledFor(RunConfiguration configuration) {
        return true;
    }

    public boolean canBePerformed(DataContext dataContext) {
        ConfigurationContext context = new ConfigurationContext(dataContext);
        RunnerAndConfigurationSettingsImpl existing = context.findExisting();
        if (existing == null) {
            List<RuntimeConfigurationProducer> producers = this.getEnabledProducers(context);
            return producers.size() <= 1;
        }
        return true;
    }

    public void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        final ConfigurationContext context = new ConfigurationContext(dataContext);
        RunnerAndConfigurationSettingsImpl existing = context.findExisting();
        if (existing == null) {
            List<RuntimeConfigurationProducer> producers = PreferedProducerFind.findPreferredProducers(context.getLocation(), context, true);
            if (producers == null) {
                return;
            }
            if (producers.size() > 1) {
                Editor editor = (Editor)PlatformDataKeys.EDITOR.getData(dataContext);
                Collections.sort(producers, new Comparator<RuntimeConfigurationProducer>(){

                    @Override
                    public int compare(RuntimeConfigurationProducer p1, RuntimeConfigurationProducer p2) {
                        return p1.getConfigurationType().getDisplayName().compareTo(p2.getConfigurationType().getDisplayName());
                    }
                });
                ListPopup popup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<RuntimeConfigurationProducer>(ExecutionBundle.message((String)"configuration.action.chooser.title", (Object[])new Object[0]), producers){

                    @NotNull
                    public String getTextFor(RuntimeConfigurationProducer producer) {
                        String string = producer.getConfigurationType().getDisplayName();
                        if (string == null) {
                            throw new IllegalStateException("@NotNull method com/intellij/execution/actions/BaseRunConfigurationAction$3.getTextFor must not return null");
                        }
                        return string;
                    }

                    public Icon getIconFor(RuntimeConfigurationProducer producer) {
                        return producer.getConfigurationType().getIcon();
                    }

                    public PopupStep onChosen(RuntimeConfigurationProducer producer, boolean finalChoice) {
                        BaseRunConfigurationAction.this.perform(producer, context);
                        return FINAL_CHOICE;
                    }
                });
                InputEvent event = e.getInputEvent();
                if (event instanceof MouseEvent) {
                    popup.show(new RelativePoint((MouseEvent)event));
                } else if (editor != null) {
                    popup.showInBestPositionFor(editor);
                } else {
                    popup.showInBestPositionFor(dataContext);
                }
            } else {
                this.perform(producers.get(0), context);
            }
            return;
        }
        this.perform(context);
    }

    private void perform(RuntimeConfigurationProducer producer, ConfigurationContext context) {
        RunnerAndConfigurationSettings configuration = context.getConfiguration(producer);
        if (configuration != null) {
            this.perform(context);
        }
    }

    protected abstract void perform(ConfigurationContext var1);

    public void update(AnActionEvent event) {
        RunnerAndConfigurationSettingsImpl configuration;
        ConfigurationContext context = new ConfigurationContext(event.getDataContext());
        Presentation presentation = event.getPresentation();
        try {
            configuration = context.getConfiguration();
        }
        catch (IndexNotReadyException e) {
            configuration = null;
        }
        if (configuration == null) {
            presentation.setEnabled(false);
            presentation.setVisible(false);
        } else {
            presentation.setEnabled(true);
            presentation.setVisible(true);
            String name = BaseRunConfigurationAction.suggestRunActionName((LocatableConfiguration)configuration.getConfiguration());
            List<RuntimeConfigurationProducer> producers = this.getEnabledProducers(context);
            if (!producers.isEmpty()) {
                context.getConfiguration(producers.get(0));
            }
            this.updatePresentation(presentation, context.findExisting() != null || producers.size() <= 1 ? " " + name : "", context);
        }
    }

    public static String suggestRunActionName(LocatableConfiguration configuration) {
        if (!configuration.isGeneratedName()) {
            return "\"" + ExecutionUtil.shortenName(configuration.getName(), 0) + "\"";
        }
        return "\"" + configuration.suggestedName() + "\"";
    }

    protected abstract void updatePresentation(Presentation var1, String var2, ConfigurationContext var3);
}

