/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.actions.EvaluateActionHandler;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.evaluation.CodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.ui.DebuggerExpressionComboBox;
import com.intellij.debugger.ui.EvaluationDialog;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;

public class ExpressionEvaluationDialog
extends EvaluationDialog {
    private JLabel myLanguageLabel;

    public ExpressionEvaluationDialog(Project project, TextWithImports defaultExpression) {
        super(project, ExpressionEvaluationDialog.makeOnLine(defaultExpression));
        this.setTitle(DebuggerBundle.message((String)"evaluate.expression.dialog.title", (Object[])new Object[0]));
        KeyStroke expressionStroke = KeyStroke.getKeyStroke(69, 8);
        KeyStroke resultStroke = KeyStroke.getKeyStroke(82, 8);
        final JRootPane rootPane = this.getRootPane();
        final AnAction anAction = new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                ExpressionEvaluationDialog.this.getExpressionCombo().requestFocus();
            }
        };
        anAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(expressionStroke), (JComponent)rootPane);
        this.addDisposeRunnable(new Runnable(){

            @Override
            public void run() {
                anAction.unregisterCustomShortcutSet((JComponent)rootPane);
            }
        });
        final AnAction anAction2 = new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                ExpressionEvaluationDialog.this.getEvaluationPanel().getWatchTree().requestFocus();
            }
        };
        anAction2.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(resultStroke), (JComponent)rootPane);
        this.addDisposeRunnable(new Runnable(){

            @Override
            public void run() {
                anAction2.unregisterCustomShortcutSet((JComponent)rootPane);
            }
        });
        this.init();
    }

    @Override
    protected DebuggerExpressionComboBox createEditor(CodeFragmentFactory factory) {
        return new DebuggerExpressionComboBox(this.getProject(), PositionUtil.getContextElement((StackFrameContext)this.getDebuggerContext()), "evaluation", factory);
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        this.myLanguageLabel = new JLabel(DebuggerBundle.message((String)"label.evaluate.dialog.language", (Object[])new Object[0]));
        this.myLanguageLabel.setVisible(this.getCodeFragmentFactoryChooserComponent().isVisible());
        panel.add((Component)this.myLanguageLabel, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add(this.getCodeFragmentFactoryChooserComponent(), new GridBagConstraints(1, -1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0));
        JLabel expressionLabel = new JLabel(DebuggerBundle.message((String)"label.evaluate.dialog.expression", (Object[])new Object[0]));
        panel.add((Component)expressionLabel, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.getExpressionCombo(), new GridBagConstraints(1, -1, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 0, 0, 0), 0, 0));
        JLabel resultLabel = new JLabel(DebuggerBundle.message((String)"label.evaluate.dialog.result", (Object[])new Object[0]));
        panel.add((Component)resultLabel, new GridBagConstraints(0, -1, 2, 1, 1.0, 0.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.getEvaluationPanel(), new GridBagConstraints(0, -1, 2, 1, 1.0, 1.0, 18, 1, new Insets(5, 0, 0, 0), 0, 0));
        return panel;
    }

    @Override
    protected void setDebuggerContext(DebuggerContextImpl context) {
        super.setDebuggerContext(context);
        if (this.myLanguageLabel != null) {
            this.myLanguageLabel.setVisible(this.getCodeFragmentFactoryChooserComponent().isVisible());
        }
    }

    private static TextWithImports makeOnLine(TextWithImports text) {
        String initialExpression = text.getText();
        if (initialExpression != null) {
            int size = initialExpression.length();
            StringBuffer buf = new StringBuffer(size);
            for (int idx = 0; idx < size; ++idx) {
                char ch = initialExpression.charAt(idx);
                if (ch == '\n' || ch == '\r') continue;
                buf.append(ch);
            }
            text.setText(initialExpression);
        }
        return text;
    }

    @Override
    protected void initDialogData(TextWithImports text) {
        super.initDialogData(text);
        this.getExpressionCombo().selectAll();
    }

    private DebuggerExpressionComboBox getExpressionCombo() {
        return (DebuggerExpressionComboBox)this.getEditor();
    }

    protected Action[] createActions() {
        return new Action[]{this.getOKAction(), this.getCancelAction(), new SwitchAction(), this.getHelpAction()};
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp("debugging.debugMenu.evaluate");
    }

    private class SwitchAction
    extends AbstractAction {
        public SwitchAction() {
            this.putValue("Name", DebuggerBundle.message((String)"action.evaluate.expression.dialog.switch.mode.description", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            final TextWithImports text = ExpressionEvaluationDialog.this.getEditor().getText();
            ExpressionEvaluationDialog.this.doCancelAction();
            DebuggerInvocationUtil.invokeLater(ExpressionEvaluationDialog.this.getProject(), new Runnable(){

                @Override
                public void run() {
                    EvaluateActionHandler.showEvaluationDialog(ExpressionEvaluationDialog.this.getProject(), text, "EvaluateFragment");
                }
            });
        }
    }
}

