/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.classParsing;

import com.intellij.compiler.classParsing.AnnotationConstantValue;
import com.intellij.compiler.classParsing.ConstantValue;
import com.intellij.compiler.classParsing.MemberInfo;
import com.intellij.compiler.classParsing.MemberInfoExternalizer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class FieldInfo
extends MemberInfo {
    public static final FieldInfo[] EMPTY_ARRAY = new FieldInfo[0];
    private final ConstantValue myConstantValue;

    public FieldInfo(int name, int descriptor) {
        super(name, descriptor);
        this.myConstantValue = ConstantValue.EMPTY_CONSTANT_VALUE;
    }

    public FieldInfo(int name, int descriptor, int genericSignature, int flags, ConstantValue value, AnnotationConstantValue[] runtimeVisibleAnnotations, AnnotationConstantValue[] runtimeInvisibleAnnotations) {
        super(name, descriptor, genericSignature, flags, runtimeVisibleAnnotations, runtimeInvisibleAnnotations);
        this.myConstantValue = value == null ? ConstantValue.EMPTY_CONSTANT_VALUE : value;
    }

    public FieldInfo(DataInput in) throws IOException {
        super(in);
        this.myConstantValue = MemberInfoExternalizer.loadConstantValue(in);
    }

    public ConstantValue getConstantValue() {
        return this.myConstantValue;
    }

    @Override
    public void save(DataOutput out) throws IOException {
        super.save(out);
        MemberInfoExternalizer.saveConstantValue(out, this.myConstantValue);
    }
}

