/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.macro;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.PsiElementResult;
import com.intellij.codeInsight.template.PsiTypeResult;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.macro.MacroUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;

public class ComponentTypeOfMacro
implements Macro {
    public String getName() {
        return "componentTypeOf";
    }

    public String getDescription() {
        return CodeInsightBundle.message((String)"macro.component.type.of.array", (Object[])new Object[0]);
    }

    public String getDefaultValue() {
        return "A";
    }

    public LookupElement[] calculateLookupItems(@NotNull Expression[] params, ExpressionContext context) {
        if (params == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/template/macro/ComponentTypeOfMacro.calculateLookupItems must not be null");
        }
        if (params.length != 1) {
            return null;
        }
        LookupElement[] lookupItems = params[0].calculateLookupItems(context);
        if (lookupItems == null) {
            return null;
        }
        for (LookupElement element : lookupItems) {
            if (!(element instanceof LookupItem)) continue;
            LookupItem item = (LookupItem)element;
            Integer bracketsCount = (Integer)item.getUserData(LookupItem.BRACKETS_COUNT_ATTR);
            if (bracketsCount == null) {
                return null;
            }
            item.putUserData(LookupItem.BRACKETS_COUNT_ATTR, new Integer(bracketsCount - 1));
        }
        return lookupItems;
    }

    public Result calculateQuickResult(@NotNull Expression[] params, ExpressionContext context) {
        if (params == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/template/macro/ComponentTypeOfMacro.calculateQuickResult must not be null");
        }
        return null;
    }

    public Result calculateResult(@NotNull Expression[] params, ExpressionContext context) {
        PsiType type;
        if (params == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/template/macro/ComponentTypeOfMacro.calculateResult must not be null");
        }
        if (params.length != 1) {
            return null;
        }
        Result result = params[0].calculateResult(context);
        if (result == null) {
            return null;
        }
        PsiDocumentManager.getInstance((Project)context.getProject()).commitAllDocuments();
        if (result instanceof PsiTypeResult && (type = ((PsiTypeResult)result).getType()) instanceof PsiArrayType) {
            return new PsiTypeResult(((PsiArrayType)type).getComponentType(), context.getProject());
        }
        PsiExpression expr = MacroUtil.resultToPsiExpression(result, context);
        PsiType type2 = expr == null ? MacroUtil.resultToPsiType(result, context) : expr.getType();
        if (type2 instanceof PsiArrayType) {
            return new PsiTypeResult(((PsiArrayType)type2).getComponentType(), context.getProject());
        }
        return new PsiElementResult(null);
    }
}

