/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.highlighting.NontrivialBraceMatcher;
import com.intellij.lang.BracePair;
import com.intellij.lang.Language;
import com.intellij.lang.PairedBraceMatcher;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PairedBraceMatcherAdapter
implements NontrivialBraceMatcher {
    private final PairedBraceMatcher myMatcher;
    private final Language myLanguage;

    public PairedBraceMatcherAdapter(PairedBraceMatcher matcher, Language language) {
        this.myMatcher = matcher;
        this.myLanguage = language;
    }

    @Override
    public int getBraceTokenGroupId(IElementType tokenType) {
        BracePair[] pairs;
        for (BracePair pair : pairs = this.myMatcher.getPairs()) {
            if (tokenType != pair.getLeftBraceType() && tokenType != pair.getRightBraceType()) continue;
            return this.myLanguage.hashCode();
        }
        return -1;
    }

    @Override
    public boolean isLBraceToken(HighlighterIterator iterator, CharSequence fileText, FileType fileType) {
        BracePair[] pairs;
        IElementType tokenType = iterator.getTokenType();
        for (BracePair pair : pairs = this.myMatcher.getPairs()) {
            if (tokenType != pair.getLeftBraceType()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isRBraceToken(HighlighterIterator iterator, CharSequence fileText, FileType fileType) {
        BracePair[] pairs;
        IElementType tokenType = iterator.getTokenType();
        for (BracePair pair : pairs = this.myMatcher.getPairs()) {
            if (tokenType != pair.getRightBraceType()) continue;
            return true;
        }
        return false;
    }

    @Override
    public IElementType getOppositeBraceTokenType(@NotNull IElementType type) {
        BracePair[] pairs;
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/highlighting/PairedBraceMatcherAdapter.getOppositeBraceTokenType must not be null");
        }
        for (BracePair pair : pairs = this.myMatcher.getPairs()) {
            if (type == pair.getRightBraceType()) {
                return pair.getLeftBraceType();
            }
            if (type != pair.getLeftBraceType()) continue;
            return pair.getRightBraceType();
        }
        return null;
    }

    @Override
    public boolean isPairBraces(IElementType tokenType, IElementType tokenType2) {
        BracePair[] pairs;
        for (BracePair pair : pairs = this.myMatcher.getPairs()) {
            if ((tokenType != pair.getLeftBraceType() || tokenType2 != pair.getRightBraceType()) && (tokenType != pair.getRightBraceType() || tokenType2 != pair.getLeftBraceType())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isStructuralBrace(HighlighterIterator iterator, CharSequence text, FileType fileType) {
        BracePair[] pairs;
        IElementType tokenType = iterator.getTokenType();
        for (BracePair pair : pairs = this.myMatcher.getPairs()) {
            if (tokenType != pair.getRightBraceType() && tokenType != pair.getLeftBraceType()) continue;
            return pair.isStructural();
        }
        return false;
    }

    @Override
    public boolean isPairedBracesAllowedBeforeType(@NotNull IElementType lbraceType, @Nullable IElementType contextType) {
        if (lbraceType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/highlighting/PairedBraceMatcherAdapter.isPairedBracesAllowedBeforeType must not be null");
        }
        return this.myMatcher.isPairedBracesAllowedBeforeType(lbraceType, contextType);
    }

    @Override
    public int getCodeConstructStart(PsiFile file, int openingBraceOffset) {
        return this.myMatcher.getCodeConstructStart(file, openingBraceOffset);
    }

    @Override
    @NotNull
    public List<IElementType> getOppositeBraceTokenTypes(@NotNull IElementType type) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/highlighting/PairedBraceMatcherAdapter.getOppositeBraceTokenTypes must not be null");
        }
        List<IElementType> result = null;
        for (BracePair pair : this.myMatcher.getPairs()) {
            IElementType match = null;
            if (type == pair.getRightBraceType()) {
                match = pair.getLeftBraceType();
            }
            if (type == pair.getLeftBraceType()) {
                match = pair.getRightBraceType();
            }
            if (match == null) continue;
            if (result == null) {
                result = new ArrayList<IElementType>(2);
            }
            result.add(match);
        }
        List<IElementType> list = result != null ? result : Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/highlighting/PairedBraceMatcherAdapter.getOppositeBraceTokenTypes must not return null");
        }
        return list;
    }
}

