/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation.surroundWith;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.generation.surroundWith.JavaStatementsSurrounder;
import com.intellij.codeInsight.generation.surroundWith.SurroundWithUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.IncorrectOperationException;

class JavaWithForSurrounder
extends JavaStatementsSurrounder {
    JavaWithForSurrounder() {
    }

    public String getTemplateDescription() {
        return CodeInsightBundle.message((String)"surround.with.for.template", (Object[])new Object[0]);
    }

    @Override
    public TextRange surroundStatements(Project project, Editor editor, PsiElement container, PsiElement[] statements) throws IncorrectOperationException {
        PsiManager manager = PsiManager.getInstance((Project)project);
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
        if ((statements = SurroundWithUtil.moveDeclarationsOut(container, statements, true)).length == 0) {
            return null;
        }
        String text = "for(a;b;c){\n}";
        PsiForStatement forStatement = (PsiForStatement)factory.createStatementFromText(text, null);
        forStatement = (PsiForStatement)codeStyleManager.reformat((PsiElement)forStatement);
        forStatement = (PsiForStatement)container.addAfter((PsiElement)forStatement, statements[statements.length - 1]);
        PsiCodeBlock bodyBlock = ((PsiBlockStatement)forStatement.getBody()).getCodeBlock();
        bodyBlock.addRange(statements[0], statements[statements.length - 1]);
        container.deleteChildRange(statements[0], statements[statements.length - 1]);
        forStatement = CodeInsightUtilBase.forcePsiPostprocessAndRestoreElement(forStatement);
        TextRange range1 = forStatement.getInitialization().getTextRange();
        TextRange range3 = forStatement.getUpdate().getTextRange();
        editor.getDocument().deleteString(range1.getStartOffset(), range3.getEndOffset());
        return new TextRange(range1.getStartOffset(), range1.getStartOffset());
    }
}

