/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.CommentUtil;
import com.intellij.codeInsight.generation.CommentByBlockCommentHandler;
import com.intellij.codeInsight.generation.CommenterDataHolder;
import com.intellij.codeInsight.generation.SelfManagingCommenter;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.highlighter.custom.SyntaxTable;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.Commenter;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageCommenters;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.impl.AbstractFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.Indent;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.StringBuilderSpinAllocator;
import com.intellij.util.containers.IntArrayList;
import com.intellij.util.text.CharArrayUtil;
import gnu.trove.THashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommentByLineCommentHandler
implements CodeInsightActionHandler {
    private Project myProject;
    private PsiFile myFile;
    private Document myDocument;
    private Editor myEditor;
    private int myStartOffset;
    private int myEndOffset;
    private int myStartLine;
    private int myEndLine;
    private int[] myStartOffsets;
    private int[] myEndOffsets;
    private Commenter[] myCommenters;
    private Map<SelfManagingCommenter, CommenterDataHolder> myCommenterStateMap;
    private CodeStyleManager myCodeStyleManager;

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        String s;
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/generation/CommentByLineCommentHandler.invoke must not be null");
        }
        if (editor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/generation/CommentByLineCommentHandler.invoke must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/generation/CommentByLineCommentHandler.invoke must not be null");
        }
        this.myProject = project;
        this.myFile = file.getViewProvider().getPsi(file.getViewProvider().getBaseLanguage());
        this.myEditor = editor;
        PsiElement context = this.myFile.getContext();
        if (context != null && (context.textContains('\'') || context.textContains('\"')) && (StringUtil.startsWith((CharSequence)(s = context.getText()), (CharSequence)"\"") || StringUtil.startsWith((CharSequence)s, (CharSequence)"'"))) {
            this.myFile = context.getContainingFile();
            this.myEditor = editor instanceof EditorWindow ? ((EditorWindow)editor).getDelegate() : editor;
        }
        this.myDocument = this.myEditor.getDocument();
        if (!FileDocumentManager.getInstance().requestWriting(this.myDocument, project)) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitDocument(this.myDocument);
        FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.comment.line");
        this.myCodeStyleManager = CodeStyleManager.getInstance((Project)this.myProject);
        SelectionModel selectionModel = this.myEditor.getSelectionModel();
        boolean hasSelection = selectionModel.hasSelection();
        this.myStartOffset = selectionModel.getSelectionStart();
        this.myEndOffset = selectionModel.getSelectionEnd();
        if (this.myDocument.getTextLength() == 0) {
            return;
        }
        while (true) {
            int endOffset;
            int lastLineEnd = this.myDocument.getLineEndOffset(this.myDocument.getLineNumber(this.myEndOffset));
            FoldRegion collapsedAt = this.myEditor.getFoldingModel().getCollapsedRegionAtOffset(lastLineEnd);
            if (collapsedAt == null || (endOffset = collapsedAt.getEndOffset()) <= this.myEndOffset) break;
            this.myEndOffset = endOffset;
        }
        boolean wholeLinesSelected = !hasSelection || this.myStartOffset == this.myDocument.getLineStartOffset(this.myDocument.getLineNumber(this.myStartOffset)) && this.myEndOffset == this.myDocument.getLineEndOffset(this.myDocument.getLineNumber(this.myEndOffset - 1)) + 1;
        boolean startingNewLineComment = !hasSelection && this.isLineEmpty(this.myDocument.getLineNumber(this.myStartOffset)) && !Comparing.equal((String)"CommentByLineComment", (String)ActionManagerEx.getInstanceEx().getPrevPreformedActionId());
        this.doComment();
        if (startingNewLineComment) {
            Commenter commenter = this.myCommenters[0];
            if (commenter != null) {
                String prefix;
                if (commenter instanceof SelfManagingCommenter) {
                    prefix = ((SelfManagingCommenter)commenter).getCommentPrefix(this.myStartLine, this.myDocument, this.myCommenterStateMap.get((SelfManagingCommenter)commenter));
                    if (prefix == null) {
                        prefix = "";
                    }
                } else {
                    prefix = commenter.getLineCommentPrefix();
                    if (prefix == null) {
                        prefix = commenter.getBlockCommentPrefix();
                    }
                }
                int lineStart = this.myDocument.getLineStartOffset(this.myStartLine);
                lineStart = CharArrayUtil.shiftForward((CharSequence)this.myDocument.getCharsSequence(), (int)lineStart, (String)" \t");
                lineStart += prefix.length();
                lineStart = CharArrayUtil.shiftForward((CharSequence)this.myDocument.getCharsSequence(), (int)lineStart, (String)" \t");
                if (lineStart > this.myDocument.getTextLength()) {
                    lineStart = this.myDocument.getTextLength();
                }
                this.myEditor.getCaretModel().moveToOffset(lineStart);
                this.myEditor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            }
        } else if (!hasSelection) {
            this.myEditor.getCaretModel().moveCaretRelatively(0, 1, false, false, true);
        } else if (wholeLinesSelected) {
            selectionModel.setSelection(this.myStartOffset, selectionModel.getSelectionEnd());
        }
    }

    private boolean isLineEmpty(int line) {
        CharSequence chars = this.myDocument.getCharsSequence();
        int start = this.myDocument.getLineStartOffset(line);
        int end = Math.min(this.myDocument.getLineEndOffset(line), this.myDocument.getTextLength() - 1);
        for (int i = start; i <= end; ++i) {
            if (Character.isWhitespace(chars.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public boolean startInWriteAction() {
        return true;
    }

    private void doComment() {
        int line;
        Commenter blockSuitableCommenter;
        this.myStartLine = this.myDocument.getLineNumber(this.myStartOffset);
        this.myEndLine = this.myDocument.getLineNumber(this.myEndOffset);
        if (this.myEndLine > this.myStartLine && this.myDocument.getLineStartOffset(this.myEndLine) == this.myEndOffset) {
            --this.myEndLine;
        }
        this.myStartOffsets = new int[this.myEndLine - this.myStartLine + 1];
        this.myEndOffsets = new int[this.myEndLine - this.myStartLine + 1];
        this.myCommenters = new Commenter[this.myEndLine - this.myStartLine + 1];
        this.myCommenterStateMap = new THashMap();
        CharSequence chars = this.myDocument.getCharsSequence();
        boolean singleline = this.myStartLine == this.myEndLine;
        int offset = this.myDocument.getLineStartOffset(this.myStartLine);
        offset = CharArrayUtil.shiftForward((CharSequence)this.myDocument.getCharsSequence(), (int)offset, (String)" \t");
        Language languageSuitableForCompleteFragment = PsiUtilBase.reallyEvaluateLanguageInRange((int)offset, (int)CharArrayUtil.shiftBackward((CharSequence)this.myDocument.getCharsSequence(), (int)this.myDocument.getLineEndOffset(this.myEndLine), (String)" \t\n"), (PsiFile)this.myFile);
        Commenter commenter = blockSuitableCommenter = languageSuitableForCompleteFragment == null ? (Commenter)LanguageCommenters.INSTANCE.forLanguage(this.myFile.getLanguage()) : null;
        if (blockSuitableCommenter == null && this.myFile.getFileType() instanceof AbstractFileType) {
            blockSuitableCommenter = new Commenter(){
                final SyntaxTable mySyntaxTable;
                {
                    this.mySyntaxTable = ((AbstractFileType)CommentByLineCommentHandler.this.myFile.getFileType()).getSyntaxTable();
                }

                @Nullable
                public String getLineCommentPrefix() {
                    return this.mySyntaxTable.getLineComment();
                }

                @Nullable
                public String getBlockCommentPrefix() {
                    return this.mySyntaxTable.getStartComment();
                }

                @Nullable
                public String getBlockCommentSuffix() {
                    return this.mySyntaxTable.getEndComment();
                }

                public String getCommentedBlockCommentPrefix() {
                    return null;
                }

                public String getCommentedBlockCommentSuffix() {
                    return null;
                }
            };
        }
        boolean allLineCommented = true;
        for (line = this.myStartLine; line <= this.myEndLine; ++line) {
            Commenter commenter2;
            Commenter commenter3 = commenter2 = blockSuitableCommenter != null ? blockSuitableCommenter : this.findCommenter(line);
            if (commenter2 == null) {
                return;
            }
            if (commenter2.getLineCommentPrefix() == null && (commenter2.getBlockCommentPrefix() == null || commenter2.getBlockCommentSuffix() == null)) {
                return;
            }
            if (commenter2 instanceof SelfManagingCommenter && this.myCommenterStateMap.get(commenter2) == null) {
                SelfManagingCommenter selfManagingCommenter = (SelfManagingCommenter)commenter2;
                Object state = selfManagingCommenter.createLineCommentingState(this.myStartLine, this.myEndLine, this.myDocument, this.myFile);
                if (state == null) {
                    state = SelfManagingCommenter.EMPTY_STATE;
                }
                this.myCommenterStateMap.put(selfManagingCommenter, (CommenterDataHolder)((Object)state));
            }
            this.myCommenters[line - this.myStartLine] = commenter2;
            if (this.isLineCommented(line, chars, commenter2) || !singleline && this.isLineEmpty(line)) continue;
            allLineCommented = false;
            break;
        }
        if (!allLineCommented) {
            if (CodeStyleSettingsManager.getSettings((Project)this.myProject).LINE_COMMENT_AT_FIRST_COLUMN) {
                this.doDefaultCommenting(blockSuitableCommenter);
            } else {
                this.doIndentCommenting(blockSuitableCommenter);
            }
        } else {
            for (line = this.myEndLine; line >= this.myStartLine; --line) {
                this.uncommentLine(line);
            }
        }
    }

    private boolean isLineCommented(int line, CharSequence chars, Commenter commenter) {
        boolean commented;
        int lineEndForBlockCommenting = -1;
        int lineStart = this.myDocument.getLineStartOffset(line);
        lineStart = CharArrayUtil.shiftForward((CharSequence)chars, (int)lineStart, (String)" \t");
        if (commenter instanceof SelfManagingCommenter) {
            SelfManagingCommenter selfManagingCommenter = (SelfManagingCommenter)commenter;
            commented = selfManagingCommenter.isLineCommented(line, lineStart, this.myDocument, this.myCommenterStateMap.get(selfManagingCommenter));
        } else {
            String prefix = commenter.getLineCommentPrefix();
            if (prefix != null) {
                commented = CharArrayUtil.regionMatches((CharSequence)chars, (int)lineStart, (CharSequence)prefix) || prefix.endsWith(" ") && CharArrayUtil.regionMatches((CharSequence)chars, (int)lineStart, (CharSequence)(prefix.trim() + "\n"));
            } else {
                prefix = commenter.getBlockCommentPrefix();
                String suffix = commenter.getBlockCommentSuffix();
                int textLength = this.myDocument.getTextLength();
                lineEndForBlockCommenting = this.myDocument.getLineEndOffset(line);
                if (lineEndForBlockCommenting == textLength) {
                    int shifted = CharArrayUtil.shiftBackward((CharSequence)chars, (int)(textLength - 1), (String)" \t");
                    if (shifted < textLength - 1) {
                        lineEndForBlockCommenting = shifted;
                    }
                } else {
                    lineEndForBlockCommenting = CharArrayUtil.shiftBackward((CharSequence)chars, (int)lineEndForBlockCommenting, (String)" \t");
                }
                boolean bl = commented = lineStart == lineEndForBlockCommenting && this.myStartLine != this.myEndLine || CharArrayUtil.regionMatches((CharSequence)chars, (int)lineStart, (CharSequence)prefix) && CharArrayUtil.regionMatches((CharSequence)chars, (int)(lineEndForBlockCommenting - suffix.length()), (CharSequence)suffix);
            }
        }
        if (commented) {
            this.myStartOffsets[line - this.myStartLine] = lineStart;
            this.myEndOffsets[line - this.myStartLine] = lineEndForBlockCommenting;
        }
        return commented;
    }

    @Nullable
    private Commenter findCommenter(int line) {
        FileType fileType = this.myFile.getFileType();
        if (fileType instanceof AbstractFileType) {
            return ((AbstractFileType)fileType).getCommenter();
        }
        int lineStartOffset = this.myDocument.getLineStartOffset(line);
        int lineEndOffset = this.myDocument.getLineEndOffset(line) - 1;
        CharSequence charSequence = this.myDocument.getCharsSequence();
        lineStartOffset = CharArrayUtil.shiftForward((CharSequence)charSequence, (int)lineStartOffset, (String)" \t");
        lineEndOffset = CharArrayUtil.shiftBackward((CharSequence)charSequence, (int)(lineEndOffset < 0 ? 0 : lineEndOffset), (String)" \t");
        Language lineStartLanguage = PsiUtilBase.getLanguageAtOffset((PsiFile)this.myFile, (int)lineStartOffset);
        Language lineEndLanguage = PsiUtilBase.getLanguageAtOffset((PsiFile)this.myFile, (int)lineEndOffset);
        return CommentByBlockCommentHandler.getCommenter(this.myFile, this.myEditor, lineStartLanguage, lineEndLanguage);
    }

    private Indent computeMinIndent(int line1, int line2, CharSequence chars, CodeStyleManager codeStyleManager, FileType fileType) {
        int commentOffset;
        Indent minIndent = CommentUtil.getMinLineIndent(this.myProject, this.myDocument, line1, line2, fileType);
        if (line1 > 0 && (commentOffset = this.getCommentStart(line1 - 1)) >= 0) {
            int lineStart = this.myDocument.getLineStartOffset(line1 - 1);
            String space = ((Object)chars.subSequence(lineStart, commentOffset)).toString();
            Indent indent = codeStyleManager.getIndent(space, fileType);
            Indent indent2 = minIndent = minIndent != null ? indent.min(minIndent) : indent;
        }
        if (minIndent == null) {
            minIndent = codeStyleManager.zeroIndent();
        }
        return minIndent;
    }

    private int getCommentStart(int line) {
        int offset = this.myDocument.getLineStartOffset(line);
        CharSequence chars = this.myDocument.getCharsSequence();
        offset = CharArrayUtil.shiftForward((CharSequence)chars, (int)offset, (String)" \t");
        Commenter commenter = this.findCommenter(line);
        if (commenter == null) {
            return -1;
        }
        String prefix = commenter.getLineCommentPrefix();
        if (prefix == null) {
            prefix = commenter.getBlockCommentPrefix();
        }
        if (prefix == null) {
            return -1;
        }
        return CharArrayUtil.regionMatches((CharSequence)chars, (int)offset, (CharSequence)prefix) ? offset : -1;
    }

    public void doDefaultCommenting(Commenter commenter) {
        for (int line = this.myEndLine; line >= this.myStartLine; --line) {
            int offset = this.myDocument.getLineStartOffset(line);
            this.commentLine(line, offset, commenter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doIndentCommenting(Commenter commenter) {
        CharSequence chars = this.myDocument.getCharsSequence();
        FileType fileType = this.myFile.getFileType();
        Indent minIndent = this.computeMinIndent(this.myStartLine, this.myEndLine, chars, this.myCodeStyleManager, fileType);
        for (int line = this.myEndLine; line >= this.myStartLine; --line) {
            int lineStart;
            int offset = lineStart = this.myDocument.getLineStartOffset(line);
            StringBuilder buffer = StringBuilderSpinAllocator.alloc();
            try {
                String space;
                Indent indent;
                while (!(indent = this.myCodeStyleManager.getIndent(space = buffer.toString(), fileType)).isGreaterThan(minIndent)) {
                    if (indent.equals(minIndent)) {
                        break;
                    }
                    char c = chars.charAt(offset);
                    if (c != ' ' && c != '\t') {
                        String newSpace = this.myCodeStyleManager.fillIndent(minIndent, fileType);
                        this.myDocument.replaceString(lineStart, offset, (CharSequence)newSpace);
                        offset = lineStart + newSpace.length();
                        break;
                    }
                    buffer.append(c);
                    ++offset;
                }
            }
            finally {
                StringBuilderSpinAllocator.dispose((StringBuilder)buffer);
            }
            this.commentLine(line, offset, commenter);
        }
    }

    private void uncommentRange(int startOffset, int endOffset, @NotNull Commenter commenter) {
        if (commenter == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/generation/CommentByLineCommentHandler.uncommentRange must not be null");
        }
        String commentedSuffix = commenter.getCommentedBlockCommentSuffix();
        String commentedPrefix = commenter.getCommentedBlockCommentPrefix();
        String prefix = commenter.getBlockCommentPrefix();
        String suffix = commenter.getBlockCommentSuffix();
        if (prefix == null || suffix == null) {
            return;
        }
        if (endOffset >= suffix.length() && CharArrayUtil.regionMatches((CharSequence)this.myDocument.getCharsSequence(), (int)(endOffset - suffix.length()), (CharSequence)suffix)) {
            this.myDocument.deleteString(endOffset - suffix.length(), endOffset);
        }
        if (commentedPrefix != null && commentedSuffix != null) {
            CommentByBlockCommentHandler.commentNestedComments(this.myDocument, new TextRange(startOffset, endOffset), commenter);
        }
        this.myDocument.deleteString(startOffset, startOffset + prefix.length());
    }

    private void uncommentLine(int line) {
        int prefixPos;
        Commenter commenter = this.myCommenters[line - this.myStartLine];
        if (commenter == null) {
            commenter = this.findCommenter(line);
        }
        if (commenter == null) {
            return;
        }
        int startOffset = this.myStartOffsets[line - this.myStartLine];
        if (commenter instanceof SelfManagingCommenter) {
            SelfManagingCommenter selfManagingCommenter = (SelfManagingCommenter)commenter;
            selfManagingCommenter.uncommentLine(line, startOffset, this.myDocument, this.myCommenterStateMap.get(selfManagingCommenter));
            return;
        }
        int endOffset = this.myEndOffsets[line - this.myStartLine];
        if (startOffset == endOffset) {
            return;
        }
        String prefix = commenter.getLineCommentPrefix();
        if (prefix != null) {
            int theEnd;
            boolean commented;
            CharSequence chars = this.myDocument.getCharsSequence();
            boolean skipNewLine = false;
            boolean bl = CharArrayUtil.regionMatches((CharSequence)chars, (int)startOffset, (CharSequence)prefix) || (skipNewLine = prefix.endsWith(" ") && CharArrayUtil.regionMatches((CharSequence)chars, (int)startOffset, (CharSequence)(prefix.trim() + "\n"))) ? true : (commented = false);
            assert (commented);
            int charsToDelete = skipNewLine ? prefix.trim().length() : prefix.length();
            int n = theEnd = endOffset > 0 ? endOffset : chars.length();
            if (startOffset + charsToDelete < theEnd - 2 && chars.charAt(startOffset + charsToDelete) == ' ' && chars.charAt(startOffset + charsToDelete + 1) != ' ') {
                ++charsToDelete;
            }
            this.myDocument.deleteString(startOffset, startOffset + charsToDelete);
            return;
        }
        String text = ((Object)this.myDocument.getCharsSequence().subSequence(startOffset, endOffset)).toString();
        prefix = commenter.getBlockCommentPrefix();
        String suffix = commenter.getBlockCommentSuffix();
        if (prefix == null || suffix == null) {
            return;
        }
        IntArrayList prefixes = new IntArrayList();
        IntArrayList suffixes = new IntArrayList();
        int position = 0;
        while (position < text.length() && (prefixPos = text.indexOf(prefix, position)) != -1) {
            prefixes.add(prefixPos);
            position = prefixPos + prefix.length();
            int suffixPos = text.indexOf(suffix, position);
            if (suffixPos == -1) {
                suffixPos = text.length() - suffix.length();
            }
            suffixes.add(suffixPos);
            position = suffixPos + suffix.length();
        }
        assert (prefixes.size() == suffixes.size());
        for (int i = prefixes.size() - 1; i >= 0; --i) {
            this.uncommentRange(startOffset + prefixes.get(i), Math.min(startOffset + suffixes.get(i) + suffix.length(), endOffset), commenter);
        }
    }

    private void commentLine(int line, int offset, @Nullable Commenter commenter) {
        if (commenter == null) {
            commenter = this.findCommenter(line);
        }
        if (commenter == null) {
            return;
        }
        if (commenter instanceof SelfManagingCommenter) {
            SelfManagingCommenter selfManagingCommenter = (SelfManagingCommenter)commenter;
            selfManagingCommenter.commentLine(line, offset, this.myDocument, this.myCommenterStateMap.get(selfManagingCommenter));
            return;
        }
        String prefix = commenter.getLineCommentPrefix();
        if (prefix != null) {
            this.myDocument.insertString(offset, (CharSequence)prefix);
        } else {
            prefix = commenter.getBlockCommentPrefix();
            String suffix = commenter.getBlockCommentSuffix();
            if (prefix == null || suffix == null) {
                return;
            }
            int endOffset = this.myDocument.getLineEndOffset(line);
            if (endOffset == offset && this.myStartLine != this.myEndLine) {
                return;
            }
            int textLength = this.myDocument.getTextLength();
            CharSequence chars = this.myDocument.getCharsSequence();
            offset = CharArrayUtil.shiftForward((CharSequence)chars, (int)offset, (String)" \t");
            if (endOffset == textLength) {
                int shifted = CharArrayUtil.shiftBackward((CharSequence)chars, (int)(textLength - 1), (String)" \t");
                if (shifted < textLength - 1) {
                    endOffset = shifted;
                }
            } else {
                endOffset = CharArrayUtil.shiftBackward((CharSequence)chars, (int)endOffset, (String)" \t");
            }
            if (endOffset < offset || offset == textLength - 1) {
                return;
            }
            String text = ((Object)chars.subSequence(offset, endOffset)).toString();
            IntArrayList prefixes = new IntArrayList();
            IntArrayList suffixes = new IntArrayList();
            String commentedSuffix = commenter.getCommentedBlockCommentSuffix();
            String commentedPrefix = commenter.getCommentedBlockCommentPrefix();
            int position = 0;
            while (position < text.length()) {
                int nearestSuffix;
                int nearestPrefix = text.indexOf(prefix, position);
                if (nearestPrefix == -1) {
                    nearestPrefix = text.length();
                }
                if ((nearestSuffix = text.indexOf(suffix, position)) == -1) {
                    nearestSuffix = text.length();
                }
                if (Math.min(nearestPrefix, nearestSuffix) == text.length()) break;
                if (nearestPrefix < nearestSuffix) {
                    prefixes.add(nearestPrefix);
                    position = nearestPrefix + prefix.length();
                    continue;
                }
                suffixes.add(nearestSuffix);
                position = nearestSuffix + suffix.length();
            }
            if (commentedSuffix != null || suffixes.isEmpty() || offset + suffixes.get(suffixes.size() - 1) + suffix.length() < endOffset) {
                this.myDocument.insertString(endOffset, (CharSequence)suffix);
            }
            int nearestPrefix = prefixes.size() - 1;
            int nearestSuffix = suffixes.size() - 1;
            while (nearestPrefix >= 0 || nearestSuffix >= 0) {
                int position2;
                if (nearestSuffix == -1 || nearestPrefix != -1 && prefixes.get(nearestPrefix) > suffixes.get(nearestSuffix)) {
                    position2 = prefixes.get(nearestPrefix);
                    --nearestPrefix;
                    if (commentedPrefix != null) {
                        this.myDocument.replaceString(offset + position2, offset + position2 + prefix.length(), (CharSequence)commentedPrefix);
                        continue;
                    }
                    if (position2 == 0) continue;
                    this.myDocument.insertString(offset + position2, (CharSequence)suffix);
                    continue;
                }
                position2 = suffixes.get(nearestSuffix);
                --nearestSuffix;
                if (commentedSuffix != null) {
                    this.myDocument.replaceString(offset + position2, offset + position2 + suffix.length(), (CharSequence)commentedSuffix);
                    continue;
                }
                if (offset + position2 + suffix.length() >= endOffset) continue;
                this.myDocument.insertString(offset + position2 + suffix.length(), (CharSequence)prefix);
            }
            if (commentedPrefix != null || prefixes.isEmpty() || prefixes.get(0) != 0) {
                this.myDocument.insertString(offset, (CharSequence)prefix);
            }
        }
    }
}

