/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.RemoveUnusedParameterFix;
import com.intellij.codeInspection.IntentionAndQuickFixAction;
import com.intellij.ide.util.SuperMethodWarningUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessor;
import org.jetbrains.annotations.NotNull;

public class MethodReturnFix
extends IntentionAndQuickFixAction {
    private final PsiMethod myMethod;
    private final PsiType myReturnType;
    private final boolean myFixWholeHierarchy;

    public MethodReturnFix(PsiMethod method, PsiType toReturn, boolean fixWholeHierarchy) {
        this.myMethod = method;
        this.myReturnType = toReturn;
        this.myFixWholeHierarchy = fixWholeHierarchy;
    }

    @NotNull
    public String getName() {
        String string = QuickFixBundle.message("fix.return.type.text", this.myMethod.getName(), this.myReturnType.getCanonicalText());
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/MethodReturnFix.getName must not return null");
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("fix.return.type.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/MethodReturnFix.getFamilyName must not return null");
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/MethodReturnFix.isAvailable must not be null");
        }
        return this.myMethod != null && this.myMethod.isValid() && this.myMethod.getManager().isInProject((PsiElement)this.myMethod) && this.myReturnType != null && this.myReturnType.isValid() && !TypeConversionUtil.isNullType((PsiType)this.myReturnType) && this.myMethod.getReturnType() != null && !Comparing.equal((Object)this.myReturnType, (Object)this.myMethod.getReturnType());
    }

    public void applyFix(Project project, PsiFile file, Editor editor) {
        PsiType superReturnType;
        PsiMethod superMethod;
        if (!CodeInsightUtilBase.prepareFileForWrite(this.myMethod.getContainingFile())) {
            return;
        }
        PsiMethod method = this.myMethod;
        if (this.myFixWholeHierarchy && (superMethod = this.myMethod.findDeepestSuperMethod()) != null && (superReturnType = superMethod.getReturnType()) != null && !Comparing.equal((Object)this.myReturnType, (Object)superReturnType) && (method = SuperMethodWarningUtil.checkSuperMethod(this.myMethod, RefactoringBundle.message((String)"to.refactor"))) == null) {
            return;
        }
        if (!CodeInsightUtilBase.prepareFileForWrite(method.getContainingFile())) {
            return;
        }
        ChangeSignatureProcessor processor = new ChangeSignatureProcessor(this.myMethod.getProject(), method, false, null, method.getName(), this.myReturnType, RemoveUnusedParameterFix.getNewParametersInfo(method, null));
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            processor.run();
        } else {
            processor.run();
        }
        if (method.getContainingFile() != file) {
            UndoUtil.markPsiFileForUndo((PsiFile)file);
        }
    }
}

