/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.quickfix.ExtendsListFix;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.codeInsight.generation.PsiMethodMember;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ChangeParameterClassFix
extends ExtendsListFix {
    private ChangeParameterClassFix(PsiClass aClassToExtend, PsiClassType parameterClass) {
        super(aClassToExtend, parameterClass, true);
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("change.parameter.class.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/ChangeParameterClassFix.getFamilyName must not return null");
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/ChangeParameterClassFix.isAvailable must not be null");
        }
        return super.isAvailable(project, editor, file) && this.myClass != null && this.myClass.isValid() && this.myClass.getQualifiedName() != null && this.myClassToExtendFrom != null && this.myClassToExtendFrom.isValid() && this.myClassToExtendFrom.getQualifiedName() != null && this.myClass.getManager().isInProject((PsiElement)this.myClass);
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/ChangeParameterClassFix.invoke must not be null");
        }
        if (!CodeInsightUtilBase.prepareFileForWrite(file)) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                ChangeParameterClassFix.this.invokeImpl();
            }
        });
        final Editor editor1 = CodeInsightUtil.positionCursor(project, this.myClass.getContainingFile(), (PsiElement)this.myClass);
        if (editor1 == null) {
            return;
        }
        final Collection<CandidateInfo> toImplement = OverrideImplementUtil.getMethodsToOverrideImplement(this.myClass, true);
        if (!toImplement.isEmpty()) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        List members = ContainerUtil.map2List((Collection)toImplement, (Function)new Function<CandidateInfo, PsiMethodMember>(){

                            public PsiMethodMember fun(CandidateInfo s) {
                                return new PsiMethodMember(s);
                            }
                        });
                        OverrideImplementUtil.overrideOrImplementMethodsInRightPlace(editor1, ChangeParameterClassFix.this.myClass, members, false);
                    }
                });
            } else {
                editor1.getCaretModel().moveToOffset(this.myClass.getTextRange().getStartOffset());
                OverrideImplementUtil.chooseAndImplementMethods(project, editor1, this.myClass);
            }
        }
    }

    public static void registerQuickFixActions(PsiMethodCallExpression methodCall, PsiExpressionList list, HighlightInfo highlightInfo) {
        JavaResolveResult result = methodCall.getMethodExpression().advancedResolve(false);
        PsiMethod method = (PsiMethod)result.getElement();
        PsiSubstitutor substitutor = result.getSubstitutor();
        PsiExpression[] expressions = list.getExpressions();
        if (method == null || method.getParameterList().getParametersCount() != expressions.length) {
            return;
        }
        for (int i = 0; i < expressions.length; ++i) {
            PsiExpression expression = expressions[i];
            PsiParameter parameter = method.getParameterList().getParameters()[i];
            PsiType expressionType = expression.getType();
            PsiType parameterType = substitutor.substitute(parameter.getType());
            if (expressionType == null || expressionType instanceof PsiPrimitiveType || TypeConversionUtil.isNullType((PsiType)expressionType) || expressionType instanceof PsiArrayType || parameterType instanceof PsiPrimitiveType || TypeConversionUtil.isNullType((PsiType)parameterType) || parameterType instanceof PsiArrayType || parameterType.isAssignableFrom(expressionType)) continue;
            PsiClass parameterClass = PsiUtil.resolveClassInType((PsiType)parameterType);
            PsiClass expressionClass = PsiUtil.resolveClassInType((PsiType)expressionType);
            if (parameterClass == null || expressionClass == null || parameterClass.isInheritor(expressionClass, true)) continue;
            QuickFixAction.registerQuickFixAction(highlightInfo, new ChangeParameterClassFix(expressionClass, (PsiClassType)parameterType));
        }
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }
}

