/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.JavaHightlightInfoTypes;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightClassUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightMessageUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightMethodUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightNamesUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.IncreaseLanguageLevelFix;
import com.intellij.codeInsight.daemon.impl.quickfix.GenerifyFileFix;
import com.intellij.codeInsight.daemon.impl.quickfix.MakeVarargParameterLastFix;
import com.intellij.codeInsight.daemon.impl.quickfix.MoveBoundClassToFrontFix;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.daemon.impl.quickfix.ShowModulePropertiesFix;
import com.intellij.codeInsight.daemon.impl.quickfix.VariableParameterizedTypeFix;
import com.intellij.codeInsight.intention.EmptyIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConstructorCall;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiQualifiedReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.searches.SuperMethodsSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiMatcherImpl;
import com.intellij.psi.util.PsiMatchers;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenericsHighlightUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.analysis.GenericsHighlightUtil");
    private static final String GENERICS_ARE_NOT_SUPPORTED = JavaErrorMessages.message("generics.are.not.supported", new Object[0]);
    private static final QuickFixFactory QUICK_FIX_FACTORY = QuickFixFactory.getInstance();
    private static final MethodSignature ourValuesEnumSyntheticMethod = MethodSignatureUtil.createMethodSignature((String)"values", (PsiType[])PsiType.EMPTY_ARRAY, (PsiTypeParameter[])PsiTypeParameter.EMPTY_ARRAY, (PsiSubstitutor)PsiSubstitutor.EMPTY);

    private GenericsHighlightUtil() {
    }

    public static HighlightInfo checkInferredTypeArguments(PsiMethod genericMethod, PsiMethodCallExpression call, PsiSubstitutor substitutor) {
        PsiTypeParameter[] typeParameters;
        for (PsiTypeParameter typeParameter : typeParameters = genericMethod.getTypeParameters()) {
            PsiClassType[] extendsTypes;
            PsiType substituted = substitutor.substitute(typeParameter);
            if (substituted == null) {
                return null;
            }
            substituted = PsiUtil.captureToplevelWildcards((PsiType)substituted, (PsiElement)call);
            for (PsiClassType type : extendsTypes = typeParameter.getExtendsListTypes()) {
                PsiType extendsType = substitutor.substitute((PsiType)type);
                if (TypeConversionUtil.isAssignable((PsiType)extendsType, (PsiType)substituted, (boolean)false)) continue;
                PsiClass boundClass = extendsType instanceof PsiClassType ? ((PsiClassType)extendsType).resolve() : null;
                String messageKey = boundClass == null || typeParameter.isInterface() == boundClass.isInterface() ? "generics.inferred.type.for.type.parameter.is.not.within.its.bound.extend" : "generics.inferred.type.for.type.parameter.is.not.within.its.bound.implement";
                String description = JavaErrorMessages.message(messageKey, HighlightUtil.formatClass((PsiClass)typeParameter), HighlightUtil.formatType(extendsType), HighlightUtil.formatType(substituted));
                return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)call, description);
            }
        }
        return null;
    }

    public static HighlightInfo checkParameterizedReferenceTypeArguments(PsiElement resolved, PsiJavaCodeReferenceElement referenceElement, PsiSubstitutor substitutor) {
        if (!(resolved instanceof PsiTypeParameterListOwner)) {
            return null;
        }
        PsiTypeParameterListOwner typeParameterListOwner = (PsiTypeParameterListOwner)resolved;
        return GenericsHighlightUtil.checkReferenceTypeArgumentList(typeParameterListOwner, referenceElement.getParameterList(), substitutor, true);
    }

    public static HighlightInfo checkReferenceTypeArgumentList(PsiTypeParameterListOwner typeParameterListOwner, PsiReferenceParameterList referenceParameterList, PsiSubstitutor substitutor, boolean registerIntentions) {
        int refParametersNum;
        if (referenceParameterList != null && !PsiUtil.isLanguageLevel5OrHigher((PsiElement)referenceParameterList) && referenceParameterList.getTypeParameterElements().length > 0) {
            HighlightInfo info = HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)referenceParameterList, GENERICS_ARE_NOT_SUPPORTED);
            QuickFixAction.registerQuickFixAction(info, new ShowModulePropertiesFix((PsiElement)referenceParameterList));
            QuickFixAction.registerQuickFixAction(info, new IncreaseLanguageLevelFix(LanguageLevel.JDK_1_5));
            return info;
        }
        PsiTypeParameter[] typeParameters = typeParameterListOwner.getTypeParameters();
        int targetParametersNum = typeParameters.length;
        int n = refParametersNum = referenceParameterList == null ? 0 : referenceParameterList.getTypeParameterElements().length;
        if (targetParametersNum != refParametersNum && refParametersNum != 0) {
            PsiElement variable;
            PsiElement pparent;
            String description = targetParametersNum == 0 ? JavaErrorMessages.message("generics.type.or.method.does.not.have.type.parameters", GenericsHighlightUtil.typeParameterListOwnerCategoryDescription(typeParameterListOwner), GenericsHighlightUtil.typeParameterListOwnerDescription(typeParameterListOwner)) : JavaErrorMessages.message("generics.wrong.number.of.type.arguments", refParametersNum, targetParametersNum);
            HighlightInfo highlightInfo = HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)referenceParameterList, description);
            if (registerIntentions && (pparent = referenceParameterList.getParent().getParent()) instanceof PsiTypeElement && (variable = pparent.getParent()) instanceof PsiVariable) {
                VariableParameterizedTypeFix.registerIntentions(highlightInfo, (PsiVariable)variable, referenceParameterList);
            }
            return highlightInfo;
        }
        if (targetParametersNum > 0 && refParametersNum != 0) {
            PsiTypeElement[] referenceElements = referenceParameterList.getTypeParameterElements();
            for (int i = 0; i < typeParameters.length; ++i) {
                PsiClassType[] bounds;
                PsiClass referenceClass;
                PsiTypeParameter classParameter = typeParameters[i];
                PsiTypeElement typeElement = referenceElements[i];
                PsiType type = typeElement.getType();
                if (!(type instanceof PsiClassType) || (referenceClass = ((PsiClassType)type).resolve()) == null) continue;
                for (PsiClassType type1 : bounds = classParameter.getSuperTypes()) {
                    PsiType bound = substitutor.substitute((PsiType)type1);
                    if (TypeConversionUtil.isAssignable((PsiType)bound, (PsiType)type, (boolean)false)) continue;
                    PsiClass boundClass = bound instanceof PsiClassType ? ((PsiClassType)bound).resolve() : null;
                    String messageKey = boundClass == null || referenceClass.isInterface() == boundClass.isInterface() ? "generics.type.parameter.is.not.within.its.bound.extend" : "generics.type.parameter.is.not.within.its.bound.implement";
                    String description = JavaErrorMessages.message(messageKey, HighlightUtil.formatClass(referenceClass), HighlightUtil.formatType(bound));
                    HighlightInfo highlightInfo = HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)typeElement, description);
                    if (bound instanceof PsiClassType) {
                        QuickFixAction.registerQuickFixAction(highlightInfo, QUICK_FIX_FACTORY.createExtendsListFix(referenceClass, (PsiClassType)bound, true), null);
                    }
                    return highlightInfo;
                }
            }
        }
        return null;
    }

    private static String typeParameterListOwnerDescription(PsiTypeParameterListOwner typeParameterListOwner) {
        if (typeParameterListOwner instanceof PsiClass) {
            return HighlightUtil.formatClass((PsiClass)typeParameterListOwner);
        }
        if (typeParameterListOwner instanceof PsiMethod) {
            return HighlightUtil.formatMethod((PsiMethod)typeParameterListOwner);
        }
        LOG.error("Unknown " + typeParameterListOwner);
        return "?";
    }

    private static String typeParameterListOwnerCategoryDescription(PsiTypeParameterListOwner typeParameterListOwner) {
        if (typeParameterListOwner instanceof PsiClass) {
            return JavaErrorMessages.message("generics.holder.type", new Object[0]);
        }
        if (typeParameterListOwner instanceof PsiMethod) {
            return JavaErrorMessages.message("generics.holder.method", new Object[0]);
        }
        LOG.error("Unknown " + typeParameterListOwner);
        return "?";
    }

    public static HighlightInfo checkElementInTypeParameterExtendsList(PsiReferenceList referenceList, JavaResolveResult resolveResult, PsiElement element) {
        PsiClass aClass = (PsiClass)referenceList.getParent();
        PsiJavaCodeReferenceElement[] referenceElements = referenceList.getReferenceElements();
        PsiClass extendFrom = (PsiClass)resolveResult.getElement();
        if (extendFrom == null) {
            return null;
        }
        HighlightInfo errorResult = null;
        if (!extendFrom.isInterface() && referenceElements.length != 0 && element != referenceElements[0]) {
            String description = HighlightClassUtil.INTERFACE_EXPECTED;
            errorResult = HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, element, description);
            PsiClassType type = JavaPsiFacade.getInstance((Project)aClass.getProject()).getElementFactory().createType(extendFrom, resolveResult.getSubstitutor());
            QuickFixAction.registerQuickFixAction(errorResult, new MoveBoundClassToFrontFix(aClass, type), null);
        } else if (referenceElements.length != 0 && element != referenceElements[0] && referenceElements[0].resolve() instanceof PsiTypeParameter) {
            String description = JavaErrorMessages.message("type.parameter.cannot.be.followed.by.other.bounds", new Object[0]);
            errorResult = HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, element, description);
            PsiClassType type = JavaPsiFacade.getInstance((Project)aClass.getProject()).getElementFactory().createType(extendFrom, resolveResult.getSubstitutor());
            IntentionAction fix = QUICK_FIX_FACTORY.createExtendsListFix(aClass, type, false);
            QuickFixAction.registerQuickFixAction(errorResult, fix, null);
        }
        return errorResult;
    }

    public static HighlightInfo checkInterfaceMultipleInheritance(PsiClass aClass) {
        if (aClass instanceof PsiTypeParameter) {
            return null;
        }
        PsiClassType[] types = aClass.getSuperTypes();
        if (types.length < 2) {
            return null;
        }
        HashMap inheritedClasses = new HashMap();
        TextRange textRange = HighlightNamesUtil.getClassDeclarationTextRange(aClass);
        return GenericsHighlightUtil.checkInterfaceMultipleInheritance(aClass, PsiSubstitutor.EMPTY, (Map<PsiClass, PsiSubstitutor>)inheritedClasses, (Set<PsiClass>)new HashSet(), textRange);
    }

    private static HighlightInfo checkInterfaceMultipleInheritance(PsiClass aClass, PsiSubstitutor derivedSubstitutor, Map<PsiClass, PsiSubstitutor> inheritedClasses, Set<PsiClass> visited, TextRange textRange) {
        PsiClassType[] superTypes;
        for (PsiClassType superType : superTypes = aClass.getSuperTypes()) {
            PsiClassType.ClassResolveResult result = superType.resolveGenerics();
            PsiClass superClass = result.getElement();
            if (superClass == null || visited.contains(superClass)) continue;
            PsiSubstitutor superTypeSubstitutor = result.getSubstitutor();
            superTypeSubstitutor = MethodSignatureUtil.combineSubstitutors((PsiSubstitutor)superTypeSubstitutor, (PsiSubstitutor)derivedSubstitutor);
            PsiSubstitutor inheritedSubstitutor = inheritedClasses.get(superClass);
            if (inheritedSubstitutor != null) {
                PsiTypeParameter[] typeParameters;
                for (PsiTypeParameter typeParameter : typeParameters = superClass.getTypeParameters()) {
                    PsiType type2;
                    PsiType type1 = inheritedSubstitutor.substitute(typeParameter);
                    if (Comparing.equal((Object)type1, (Object)(type2 = superTypeSubstitutor.substitute(typeParameter)))) continue;
                    String description = JavaErrorMessages.message("generics.cannot.be.inherited.with.different.type.arguments", HighlightUtil.formatClass(superClass), HighlightUtil.formatType(type1), HighlightUtil.formatType(type2));
                    return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, textRange, description);
                }
            }
            inheritedClasses.put(superClass, superTypeSubstitutor);
            visited.add(superClass);
            HighlightInfo highlightInfo = GenericsHighlightUtil.checkInterfaceMultipleInheritance(superClass, superTypeSubstitutor, inheritedClasses, visited, textRange);
            visited.remove(superClass);
            if (highlightInfo == null) continue;
            return highlightInfo;
        }
        return null;
    }

    public static HighlightInfo checkOverrideEquivalentMethods(PsiClass aClass) {
        Collection signaturesWithSupers = aClass.getVisibleSignatures();
        PsiManager manager = aClass.getManager();
        THashMap sameErasureMethods = new THashMap(MethodSignatureUtil.METHOD_PARAMETERS_ERASURE_EQUALITY);
        for (HierarchicalMethodSignature signature : signaturesWithSupers) {
            HighlightInfo info = GenericsHighlightUtil.checkSameErasureNotSubsignatureInner(signature, manager, aClass, (Map<MethodSignature, MethodSignatureBackedByPsiMethod>)sameErasureMethods);
            if (info == null) continue;
            return info;
        }
        return null;
    }

    private static HighlightInfo checkSameErasureNotSubsignatureInner(HierarchicalMethodSignature signature, PsiManager manager, PsiClass aClass, Map<MethodSignature, MethodSignatureBackedByPsiMethod> sameErasureMethods) {
        HighlightInfo info;
        PsiMethod method = signature.getMethod();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)manager.getProject());
        if (!facade.getResolveHelper().isAccessible((PsiMember)method, (PsiElement)aClass, null)) {
            return null;
        }
        MethodSignature signatureToErase = method.getSignature(PsiSubstitutor.EMPTY);
        MethodSignatureBackedByPsiMethod sameErasure = sameErasureMethods.get(signatureToErase);
        if (sameErasure != null && (info = GenericsHighlightUtil.checkSameErasureNotSubsignatureOrSameClass(sameErasure, signature, aClass, method)) != null) {
            return info;
        }
        sameErasureMethods.put(signatureToErase, (MethodSignatureBackedByPsiMethod)signature);
        List supers = signature.getSuperSignatures();
        for (HierarchicalMethodSignature superSignature : supers) {
            info = GenericsHighlightUtil.checkSameErasureNotSubsignatureInner(superSignature, manager, aClass, sameErasureMethods);
            if (info == null) continue;
            return info;
        }
        return null;
    }

    private static HighlightInfo checkSameErasureNotSubsignatureOrSameClass(MethodSignatureBackedByPsiMethod signatureToCheck, HierarchicalMethodSignature superSignature, PsiClass aClass, PsiMethod superMethod) {
        PsiType retErasure2;
        PsiMethod checkMethod = signatureToCheck.getMethod();
        if (superMethod.equals(checkMethod)) {
            return null;
        }
        PsiClass checkContainingClass = checkMethod.getContainingClass();
        LOG.assertTrue(checkContainingClass != null);
        PsiClass superContainingClass = superMethod.getContainingClass();
        boolean checkEqualsSuper = checkContainingClass.equals(superContainingClass);
        if (checkMethod.isConstructor() ? !superMethod.isConstructor() || !checkEqualsSuper : superMethod.isConstructor()) {
            return null;
        }
        if (checkMethod.hasModifierProperty("static") && !checkEqualsSuper) {
            return null;
        }
        PsiType retErasure1 = TypeConversionUtil.erasure((PsiType)checkMethod.getReturnType());
        if (!(Comparing.equal((Object)retErasure1, (Object)(retErasure2 = TypeConversionUtil.erasure((PsiType)superMethod.getReturnType()))) || TypeConversionUtil.isVoidType((PsiType)retErasure1) || TypeConversionUtil.isVoidType((PsiType)retErasure2) || checkEqualsSuper && Arrays.equals(superSignature.getParameterTypes(), signatureToCheck.getParameterTypes()))) {
            return null;
        }
        if (!checkEqualsSuper && MethodSignatureUtil.isSubsignature((MethodSignature)superSignature, (MethodSignature)signatureToCheck)) {
            return null;
        }
        if (aClass.equals(checkContainingClass)) {
            boolean sameClass = aClass.equals(superContainingClass);
            return GenericsHighlightUtil.getSameErasureMessage(sameClass, checkMethod, superMethod, HighlightNamesUtil.getMethodDeclarationTextRange(checkMethod));
        }
        return GenericsHighlightUtil.getSameErasureMessage(false, checkMethod, superMethod, HighlightNamesUtil.getClassDeclarationTextRange(aClass));
    }

    private static HighlightInfo getSameErasureMessage(boolean sameClass, PsiMethod method, PsiMethod superMethod, TextRange textRange) {
        String key = sameClass ? "generics.methods.have.same.erasure" : "generics.methods.have.same.erasure.override";
        String description = JavaErrorMessages.message(key, HighlightMethodUtil.createClashMethodMessage(method, superMethod, !sameClass));
        return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, textRange, description);
    }

    public static HighlightInfo checkTypeParameterInstantiation(PsiNewExpression expression) {
        PsiJavaCodeReferenceElement classReference = expression.getClassOrAnonymousClassReference();
        if (classReference == null) {
            return null;
        }
        JavaResolveResult result = classReference.advancedResolve(false);
        PsiElement element = result.getElement();
        if (element instanceof PsiTypeParameter) {
            String description = JavaErrorMessages.message("generics.type.parameter.cannot.be.instantiated", HighlightUtil.formatClass((PsiClass)((PsiTypeParameter)element)));
            return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)classReference, description);
        }
        return null;
    }

    public static HighlightInfo checkWildcardUsage(PsiTypeElement typeElement) {
        PsiType type = typeElement.getType();
        if (type instanceof PsiWildcardType) {
            if (typeElement.getParent() instanceof PsiReferenceParameterList) {
                PsiElement refPParent;
                PsiElement parent = typeElement.getParent().getParent();
                LOG.assertTrue(parent instanceof PsiJavaCodeReferenceElement, (Object)parent);
                PsiElement refParent = parent.getParent();
                if (refParent instanceof PsiAnonymousClass) {
                    refParent = refParent.getParent();
                }
                if (refParent instanceof PsiNewExpression) {
                    PsiNewExpression newExpression = (PsiNewExpression)refParent;
                    if (!(newExpression.getType() instanceof PsiArrayType)) {
                        String description = JavaErrorMessages.message("wildcard.type.cannot.be.instantiated", HighlightUtil.formatType(type));
                        return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)typeElement, description);
                    }
                } else if (refParent instanceof PsiReferenceList && (!((refPParent = refParent.getParent()) instanceof PsiTypeParameter) || refParent != ((PsiTypeParameter)refPParent).getExtendsList())) {
                    return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)typeElement, JavaErrorMessages.message("generics.wildcard.not.expected", new Object[0]));
                }
            } else {
                return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)typeElement, JavaErrorMessages.message("generics.wildcards.may.be.used.only.as.reference.parameters", new Object[0]));
            }
        }
        return null;
    }

    public static HighlightInfo checkReferenceTypeUsedAsTypeArgument(PsiTypeElement typeElement) {
        PsiType type = typeElement.getType();
        if (type instanceof PsiPrimitiveType || type instanceof PsiWildcardType && ((PsiWildcardType)type).getBound() instanceof PsiPrimitiveType) {
            PsiElement element = new PsiMatcherImpl((PsiElement)typeElement).parent(PsiMatchers.hasClass(PsiReferenceParameterList.class)).parent(PsiMatchers.hasClass(PsiJavaCodeReferenceElement.class)).getElement();
            if (element == null) {
                return null;
            }
            String description = JavaErrorMessages.message("generics.type.argument.cannot.be.of.primitive.type", new Object[0]);
            return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)typeElement, description);
        }
        return null;
    }

    public static HighlightInfo checkRawToGenericAssignment(PsiType lType, PsiType rType, @NotNull PsiElement elementToHighlight) {
        if (elementToHighlight == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/analysis/GenericsHighlightUtil.checkRawToGenericAssignment must not be null");
        }
        if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)elementToHighlight)) {
            return null;
        }
        HighlightDisplayKey key = HighlightDisplayKey.find((String)"UNCHECKED_WARNING");
        if (!InspectionProjectProfileManager.getInstance(elementToHighlight.getProject()).getInspectionProfile().isToolEnabled(key, elementToHighlight)) {
            return null;
        }
        if (!GenericsHighlightUtil.isRawToGeneric(lType, rType)) {
            return null;
        }
        String description = JavaErrorMessages.message("generics.unchecked.assignment", HighlightUtil.formatType(rType), HighlightUtil.formatType(lType));
        return GenericsHighlightUtil.createUncheckedWarning(elementToHighlight, key, description, elementToHighlight);
    }

    private static boolean isRawToGeneric(PsiType lType, PsiType rType) {
        boolean isValidType;
        if (lType instanceof PsiPrimitiveType || rType instanceof PsiPrimitiveType) {
            return false;
        }
        if (lType.equals(rType)) {
            return false;
        }
        if (lType instanceof PsiArrayType && rType instanceof PsiArrayType) {
            return GenericsHighlightUtil.isRawToGeneric(((PsiArrayType)lType).getComponentType(), ((PsiArrayType)rType).getComponentType());
        }
        if (lType instanceof PsiArrayType || rType instanceof PsiArrayType) {
            return false;
        }
        if (rType instanceof PsiIntersectionType) {
            for (PsiType type : ((PsiIntersectionType)rType).getConjuncts()) {
                if (!GenericsHighlightUtil.isRawToGeneric(lType, type)) continue;
                return true;
            }
            return false;
        }
        if (lType instanceof PsiIntersectionType) {
            for (PsiType type : ((PsiIntersectionType)lType).getConjuncts()) {
                if (!GenericsHighlightUtil.isRawToGeneric(type, rType)) continue;
                return true;
            }
            return false;
        }
        if (lType instanceof PsiCapturedWildcardType || rType instanceof PsiCapturedWildcardType) {
            return false;
        }
        if (lType instanceof PsiWildcardType || rType instanceof PsiWildcardType) {
            return false;
        }
        boolean bl = isValidType = lType instanceof PsiClassType && rType instanceof PsiClassType;
        if (!isValidType) {
            LOG.error("Invalid types: rType =" + rType + ", lType=" + lType);
        }
        PsiClassType.ClassResolveResult lResolveResult = ((PsiClassType)lType).resolveGenerics();
        PsiClassType.ClassResolveResult rResolveResult = ((PsiClassType)rType).resolveGenerics();
        PsiClass lClass = lResolveResult.getElement();
        PsiClass rClass = rResolveResult.getElement();
        if (rClass instanceof PsiAnonymousClass) {
            return GenericsHighlightUtil.isRawToGeneric(lType, (PsiType)((PsiAnonymousClass)rClass).getBaseClassType());
        }
        PsiSubstitutor lSubstitutor = lResolveResult.getSubstitutor();
        PsiSubstitutor rSubstitutor = rResolveResult.getSubstitutor();
        if (lClass == null || rClass == null) {
            return false;
        }
        if (lClass instanceof PsiTypeParameter && !InheritanceUtil.isInheritorOrSelf((PsiClass)rClass, (PsiClass)lClass, (boolean)true)) {
            return true;
        }
        if (!lClass.getManager().areElementsEquivalent((PsiElement)lClass, (PsiElement)rClass)) {
            if (lClass.isInheritor(rClass, true)) {
                lSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)rClass, (PsiClass)lClass, (PsiSubstitutor)lSubstitutor);
                lClass = rClass;
            } else if (rClass.isInheritor(lClass, true)) {
                rSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)lClass, (PsiClass)rClass, (PsiSubstitutor)rSubstitutor);
                rClass = lClass;
            } else {
                return false;
            }
        }
        Iterator lIterator = PsiUtil.typeParametersIterator((PsiTypeParameterListOwner)lClass);
        Iterator rIterator = PsiUtil.typeParametersIterator((PsiTypeParameterListOwner)rClass);
        while (lIterator.hasNext()) {
            if (!rIterator.hasNext()) {
                return false;
            }
            PsiTypeParameter lParameter = (PsiTypeParameter)lIterator.next();
            PsiTypeParameter rParameter = (PsiTypeParameter)rIterator.next();
            PsiType lTypeArg = lSubstitutor.substitute(lParameter);
            PsiType rTypeArg = rSubstitutor.substituteWithBoundsPromotion(rParameter);
            if (lTypeArg == null) continue;
            if (rTypeArg == null) {
                if (lTypeArg instanceof PsiWildcardType && ((PsiWildcardType)lTypeArg).getBound() == null) continue;
                return true;
            }
            if (!GenericsHighlightUtil.isUncheckedTypeArgumentConversion(lTypeArg, rTypeArg)) continue;
            return true;
        }
        return false;
    }

    public static HighlightInfo checkUncheckedTypeCast(PsiTypeCastExpression typeCast) {
        if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)typeCast)) {
            return null;
        }
        HighlightDisplayKey key = HighlightDisplayKey.find((String)"UNCHECKED_WARNING");
        if (!InspectionProjectProfileManager.getInstance(typeCast.getProject()).getInspectionProfile().isToolEnabled(key, (PsiElement)typeCast)) {
            return null;
        }
        PsiTypeElement typeElement = typeCast.getCastType();
        if (typeElement == null) {
            return null;
        }
        PsiType castType = typeElement.getType();
        PsiExpression expression = typeCast.getOperand();
        if (expression == null) {
            return null;
        }
        PsiType exprType = expression.getType();
        if (exprType == null) {
            return null;
        }
        if (GenericsHighlightUtil.isUncheckedCast(castType, exprType)) {
            String description = JavaErrorMessages.message("generics.unchecked.cast", HighlightUtil.formatType(exprType), HighlightUtil.formatType(castType));
            return GenericsHighlightUtil.createUncheckedWarning((PsiElement)expression, key, description, (PsiElement)typeCast);
        }
        return null;
    }

    private static boolean isUncheckedCast(PsiType castType, PsiType operandType) {
        if (TypeConversionUtil.isAssignable((PsiType)castType, (PsiType)operandType, (boolean)false)) {
            return false;
        }
        if ((castType = castType.getDeepComponentType()) instanceof PsiClassType) {
            PsiClassType castClassType = (PsiClassType)castType;
            if (!((operandType = operandType.getDeepComponentType()) instanceof PsiClassType)) {
                return false;
            }
            PsiClassType operandClassType = (PsiClassType)operandType;
            PsiClassType.ClassResolveResult castResult = castClassType.resolveGenerics();
            PsiClassType.ClassResolveResult operandResult = operandClassType.resolveGenerics();
            PsiClass operandClass = operandResult.getElement();
            PsiClass castClass = castResult.getElement();
            if (operandClass == null || castClass == null) {
                return false;
            }
            if (castClass instanceof PsiTypeParameter) {
                return true;
            }
            if (castClassType.hasNonTrivialParameters()) {
                if (operandClassType.isRaw()) {
                    return true;
                }
                if (castClass.isInheritor(operandClass, true)) {
                    PsiSubstitutor castSubstitutor = castResult.getSubstitutor();
                    for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)castClass)) {
                        PsiSubstitutor modifiedSubstitutor = castSubstitutor.put(typeParameter, null);
                        PsiClassType otherType = JavaPsiFacade.getInstance((Project)typeParameter.getProject()).getElementFactory().createType(castClass, modifiedSubstitutor);
                        if (!TypeConversionUtil.isAssignable((PsiType)operandType, (PsiType)otherType, (boolean)false)) continue;
                        return true;
                    }
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private static boolean isUncheckedTypeArgumentConversion(PsiType lTypeArg, PsiType rTypeArg) {
        if (lTypeArg instanceof PsiPrimitiveType || rTypeArg instanceof PsiPrimitiveType) {
            return false;
        }
        if (lTypeArg.equals(rTypeArg)) {
            return false;
        }
        if (lTypeArg instanceof PsiCapturedWildcardType) {
            return GenericsHighlightUtil.isUncheckedTypeArgumentConversion((PsiType)((PsiCapturedWildcardType)lTypeArg).getWildcard(), rTypeArg);
        }
        if (rTypeArg instanceof PsiCapturedWildcardType) {
            return GenericsHighlightUtil.isUncheckedTypeArgumentConversion(lTypeArg, (PsiType)((PsiCapturedWildcardType)rTypeArg).getWildcard());
        }
        if (lTypeArg instanceof PsiWildcardType || rTypeArg instanceof PsiWildcardType) {
            return !lTypeArg.isAssignableFrom(rTypeArg);
        }
        if (lTypeArg instanceof PsiArrayType && rTypeArg instanceof PsiArrayType) {
            return GenericsHighlightUtil.isUncheckedTypeArgumentConversion(((PsiArrayType)rTypeArg).getComponentType(), ((PsiArrayType)lTypeArg).getComponentType());
        }
        if (lTypeArg instanceof PsiArrayType || rTypeArg instanceof PsiArrayType) {
            return false;
        }
        if (lTypeArg instanceof PsiIntersectionType) {
            for (PsiType type : ((PsiIntersectionType)lTypeArg).getConjuncts()) {
                if (GenericsHighlightUtil.isUncheckedTypeArgumentConversion(type, rTypeArg)) continue;
                return false;
            }
            return true;
        }
        if (!(lTypeArg instanceof PsiClassType)) {
            LOG.error("left: " + lTypeArg + "; " + lTypeArg.getClass());
        }
        if (rTypeArg instanceof PsiIntersectionType) {
            for (PsiType type : ((PsiIntersectionType)rTypeArg).getConjuncts()) {
                if (GenericsHighlightUtil.isUncheckedTypeArgumentConversion(lTypeArg, type)) continue;
                return false;
            }
            return true;
        }
        if (!(rTypeArg instanceof PsiClassType)) {
            LOG.error("right :" + rTypeArg + "; " + rTypeArg.getClass());
        }
        return ((PsiClassType)lTypeArg).resolve() instanceof PsiTypeParameter || ((PsiClassType)rTypeArg).resolve() instanceof PsiTypeParameter;
    }

    public static HighlightInfo checkUncheckedCall(JavaResolveResult resolveResult, PsiCall call) {
        PsiParameter[] parameters;
        if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)call)) {
            return null;
        }
        HighlightDisplayKey key = HighlightDisplayKey.find((String)"UNCHECKED_WARNING");
        if (!InspectionProjectProfileManager.getInstance(call.getProject()).getInspectionProfile().isToolEnabled(key, (PsiElement)call)) {
            return null;
        }
        PsiMethod method = (PsiMethod)resolveResult.getElement();
        if (method == null) {
            return null;
        }
        final PsiSubstitutor substitutor = resolveResult.getSubstitutor();
        for (PsiParameter parameter : parameters = method.getParameterList().getParameters()) {
            PsiType parameterType = parameter.getType();
            if (!((Boolean)parameterType.accept((PsiTypeVisitor)new PsiTypeVisitor<Boolean>(){

                public Boolean visitPrimitiveType(PsiPrimitiveType primitiveType) {
                    return Boolean.FALSE;
                }

                public Boolean visitArrayType(PsiArrayType arrayType) {
                    return (Boolean)arrayType.getComponentType().accept((PsiTypeVisitor)this);
                }

                public Boolean visitClassType(PsiClassType classType) {
                    PsiType[] parameters;
                    PsiClass psiClass = classType.resolve();
                    if (psiClass instanceof PsiTypeParameter) {
                        return substitutor.substitute((PsiTypeParameter)psiClass) == null ? Boolean.TRUE : Boolean.FALSE;
                    }
                    for (PsiType parameter : parameters = classType.getParameters()) {
                        if (!((Boolean)parameter.accept((PsiTypeVisitor)this)).booleanValue()) continue;
                        return Boolean.TRUE;
                    }
                    return Boolean.FALSE;
                }

                public Boolean visitWildcardType(PsiWildcardType wildcardType) {
                    PsiType bound = wildcardType.getBound();
                    if (bound != null) {
                        return (Boolean)bound.accept((PsiTypeVisitor)this);
                    }
                    return Boolean.FALSE;
                }

                public Boolean visitEllipsisType(PsiEllipsisType ellipsisType) {
                    return (Boolean)ellipsisType.getComponentType().accept((PsiTypeVisitor)this);
                }
            })).booleanValue()) continue;
            PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)method.getProject()).getElementFactory();
            PsiClassType type = elementFactory.createType(method.getContainingClass(), substitutor);
            String description = JavaErrorMessages.message("generics.unchecked.call.to.member.of.raw.type", HighlightUtil.formatMethod(method), HighlightUtil.formatType((PsiType)type));
            PsiCall element = call instanceof PsiMethodCallExpression ? ((PsiMethodCallExpression)call).getMethodExpression() : call;
            return GenericsHighlightUtil.createUncheckedWarning((PsiElement)call, key, description, (PsiElement)element);
        }
        return null;
    }

    private static HighlightInfo createUncheckedWarning(PsiElement context, HighlightDisplayKey key, String description, PsiElement elementToHighlight) {
        InspectionProfile inspectionProfile = InspectionProjectProfileManager.getInstance(context.getProject()).getInspectionProfile();
        LocalInspectionTool tool = ((LocalInspectionToolWrapper)inspectionProfile.getInspectionTool("UNCHECKED_WARNING", elementToHighlight)).getTool();
        if (InspectionManagerEx.inspectionResultSuppressed(context, tool)) {
            return null;
        }
        HighlightInfo highlightInfo = HighlightInfo.createHighlightInfo(JavaHightlightInfoTypes.UNCHECKED_WARNING, elementToHighlight, description);
        QuickFixAction.registerQuickFixAction(highlightInfo, new GenerifyFileFix(elementToHighlight.getContainingFile()), key);
        return highlightInfo;
    }

    public static HighlightInfo checkForeachLoopParameterType(PsiForeachStatement statement) {
        PsiParameter parameter = statement.getIterationParameter();
        PsiExpression expression = statement.getIteratedValue();
        if (expression == null) {
            return null;
        }
        PsiType itemType = GenericsHighlightUtil.getCollectionItemType(expression);
        if (itemType == null) {
            String description = JavaErrorMessages.message("foreach.not.applicable", HighlightUtil.formatType(expression.getType()));
            return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)expression, description);
        }
        int start = parameter.getTextRange().getStartOffset();
        int end = expression.getTextRange().getEndOffset();
        PsiType parameterType = parameter.getType();
        HighlightInfo highlightInfo = HighlightUtil.checkAssignability(parameterType, itemType, null, new TextRange(start, end));
        if (highlightInfo != null) {
            HighlightUtil.registerChangeVariableTypeFixes((PsiVariable)parameter, itemType, highlightInfo);
        } else {
            highlightInfo = GenericsHighlightUtil.checkRawToGenericAssignment(parameterType, itemType, (PsiElement)statement.getIterationParameter());
        }
        return highlightInfo;
    }

    @Nullable
    private static PsiType getCollectionItemType(PsiExpression expression) {
        PsiType type = expression.getType();
        if (type == null) {
            return null;
        }
        if (type instanceof PsiArrayType) {
            return ((PsiArrayType)type).getComponentType();
        }
        if (type instanceof PsiClassType) {
            PsiTypeParameter typeParameter;
            PsiClass myClass;
            PsiClassType.ClassResolveResult resolveResult = ((PsiClassType)type).resolveGenerics();
            PsiClass aClass = resolveResult.getElement();
            if (aClass == null) {
                return null;
            }
            PsiManager manager = aClass.getManager();
            String qName = aClass.getQualifiedName();
            PsiSubstitutor substitutor = resolveResult.getSubstitutor();
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)manager.getProject());
            if (qName != null && (myClass = facade.findClass(qName, expression.getResolveScope())) != null && myClass != aClass) {
                PsiTypeParameter thisTypeParameter = GenericsHighlightUtil.getIterableTypeParameter(facade, myClass);
                if (thisTypeParameter == null) {
                    return null;
                }
                PsiTypeParameter thatTypeParameter = GenericsHighlightUtil.getIterableTypeParameter(facade, aClass);
                if (thatTypeParameter != null) {
                    substitutor = substitutor.put(thisTypeParameter, substitutor.substitute(thatTypeParameter));
                }
                aClass = myClass;
            }
            if ((typeParameter = GenericsHighlightUtil.getIterableTypeParameter(facade, aClass)) == null) {
                return null;
            }
            PsiClass owner = (PsiClass)typeParameter.getOwner();
            if (owner == null) {
                return null;
            }
            PsiSubstitutor superClassSubstitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)owner, (PsiClass)aClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            if (superClassSubstitutor == null) {
                return null;
            }
            PsiType itemType = superClassSubstitutor.substitute(typeParameter);
            return (itemType = substitutor.substitute(itemType)) == null ? PsiType.getJavaLangObject((PsiManager)manager, (GlobalSearchScope)aClass.getResolveScope()) : itemType;
        }
        return null;
    }

    @Nullable
    private static PsiTypeParameter getIterableTypeParameter(JavaPsiFacade facade, PsiClass context) {
        PsiClass iterable = facade.findClass("java.lang.Iterable", context.getResolveScope());
        if (iterable == null) {
            return null;
        }
        PsiTypeParameter[] typeParameters = iterable.getTypeParameters();
        if (typeParameters.length != 1) {
            return null;
        }
        return typeParameters[0];
    }

    @Nullable
    public static HighlightInfo checkAccessStaticFieldFromEnumConstructor(PsiReferenceExpression expr, JavaResolveResult result) {
        PsiElement resolved = result.getElement();
        if (!(resolved instanceof PsiField)) {
            return null;
        }
        if (!((PsiModifierListOwner)resolved).hasModifierProperty("static")) {
            return null;
        }
        PsiMember constructorOrInitializer = PsiUtil.findEnclosingConstructorOrInitializer((PsiElement)expr);
        if (constructorOrInitializer == null) {
            return null;
        }
        if (constructorOrInitializer.hasModifierProperty("static")) {
            return null;
        }
        PsiClass aClass = constructorOrInitializer.getContainingClass();
        if (aClass == null) {
            return null;
        }
        if (!aClass.isEnum()) {
            return null;
        }
        PsiField field = (PsiField)resolved;
        if (field.getContainingClass() != aClass) {
            return null;
        }
        PsiType type = field.getType();
        if (type instanceof PsiClassType && ((PsiClassType)type).resolve() == aClass) {
            return null;
        }
        if (PsiUtil.isCompileTimeConstant((PsiField)field)) {
            return null;
        }
        String description = JavaErrorMessages.message("illegal.to.access.static.member.from.enum.constructor.or.instance.initializer", HighlightMessageUtil.getSymbolName(resolved, result.getSubstitutor()));
        return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)expr, description);
    }

    @Nullable
    public static HighlightInfo checkEnumInstantiation(PsiNewExpression expression) {
        PsiClass aClass;
        PsiType type = expression.getType();
        if (type instanceof PsiClassType && (aClass = ((PsiClassType)type).resolve()) != null && aClass.isEnum()) {
            String description = JavaErrorMessages.message("enum.types.cannot.be.instantiated", new Object[0]);
            return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)expression, description);
        }
        return null;
    }

    @Nullable
    public static HighlightInfo checkGenericArrayCreation(PsiElement element, PsiType type) {
        PsiType componentType;
        if (type instanceof PsiArrayType && (componentType = type.getDeepComponentType()) instanceof PsiClassType) {
            PsiType[] parameters;
            PsiClassType classType = (PsiClassType)componentType;
            for (PsiType parameter : parameters = classType.getParameters()) {
                if (parameter instanceof PsiWildcardType && ((PsiWildcardType)parameter).getBound() == null) continue;
                return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, element, JavaErrorMessages.message("generic.array.creation", new Object[0]));
            }
            PsiClass resolved = ((PsiClassType)PsiUtil.convertAnonymousToBaseType((PsiType)classType)).resolve();
            if (resolved instanceof PsiTypeParameter) {
                return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, element, JavaErrorMessages.message("generic.array.creation", new Object[0]));
            }
        }
        return null;
    }

    public static boolean isEnumSyntheticMethod(MethodSignature methodSignature, Project project) {
        if (methodSignature.equals(ourValuesEnumSyntheticMethod)) {
            return true;
        }
        PsiClassType javaLangString = PsiType.getJavaLangString((PsiManager)PsiManager.getInstance((Project)project), (GlobalSearchScope)GlobalSearchScope.allScope((Project)project));
        MethodSignature valueOfMethod = MethodSignatureUtil.createMethodSignature((String)"valueOf", (PsiType[])new PsiType[]{javaLangString}, (PsiTypeParameter[])PsiTypeParameter.EMPTY_ARRAY, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        return valueOfMethod.equals(methodSignature);
    }

    public static HighlightInfo checkTypeParametersList(PsiTypeParameterList parameterList) {
        PsiTypeParameter[] typeParameters = parameterList.getTypeParameters();
        if (typeParameters.length == 0) {
            return null;
        }
        if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)parameterList)) {
            HighlightInfo info = HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)parameterList, GENERICS_ARE_NOT_SUPPORTED);
            QuickFixAction.registerQuickFixAction(info, new ShowModulePropertiesFix((PsiElement)parameterList));
            QuickFixAction.registerQuickFixAction(info, new IncreaseLanguageLevelFix(LanguageLevel.JDK_1_5));
            return info;
        }
        PsiElement parent = parameterList.getParent();
        if (parent instanceof PsiClass && ((PsiClass)parent).isEnum()) {
            return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)parameterList, JavaErrorMessages.message("generics.enum.may.not.have.type.parameters", new Object[0]));
        }
        if (parent instanceof PsiAnnotationMethod) {
            return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)parameterList, JavaErrorMessages.message("generics.annotation.members.may.not.have.type.parameters", new Object[0]));
        }
        if (parent instanceof PsiClass && ((PsiClass)parent).isAnnotationType()) {
            return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)parameterList, JavaErrorMessages.message("annotation.may.not.have.type.parameters", new Object[0]));
        }
        for (int i = 0; i < typeParameters.length; ++i) {
            PsiTypeParameter typeParameter1 = typeParameters[i];
            String name1 = typeParameter1.getName();
            for (int j = i + 1; j < typeParameters.length; ++j) {
                PsiTypeParameter typeParameter2 = typeParameters[j];
                String name2 = typeParameter2.getName();
                if (!Comparing.strEqual((String)name1, (String)name2)) continue;
                String message = JavaErrorMessages.message("generics.duplicate.type.parameter", name1);
                return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)typeParameter2, message);
            }
        }
        return null;
    }

    public static HighlightInfo checkCatchParameterIsClass(PsiParameter parameter) {
        PsiClass aClass;
        PsiType type;
        if (parameter.getDeclarationScope() instanceof PsiCatchSection && (type = parameter.getType()) instanceof PsiClassType && (aClass = ((PsiClassType)type).resolve()) instanceof PsiTypeParameter) {
            return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)parameter.getTypeElement(), JavaErrorMessages.message("generics.cannot.catch.type.parameters", new Object[0]));
        }
        return null;
    }

    public static HighlightInfo checkInstanceOfGenericType(PsiInstanceOfExpression expression) {
        PsiTypeElement checkTypeElement = expression.getCheckType();
        if (checkTypeElement == null) {
            return null;
        }
        PsiJavaCodeReferenceElement ref = checkTypeElement.getInnermostComponentReferenceElement();
        while (ref instanceof PsiJavaCodeReferenceElement) {
            HighlightInfo result = GenericsHighlightUtil.isIllegalForInstanceOf(ref, checkTypeElement);
            if (result != null) {
                return result;
            }
            ref = ((PsiQualifiedReference)ref).getQualifier();
        }
        return null;
    }

    private static HighlightInfo isIllegalForInstanceOf(PsiJavaCodeReferenceElement ref, PsiTypeElement typeElement) {
        PsiType[] parameters;
        PsiElement resolved = ref.resolve();
        if (resolved instanceof PsiTypeParameter) {
            return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)ref, JavaErrorMessages.message("generics.cannot.instanceof.type.parameters", new Object[0]));
        }
        for (PsiType parameterType : parameters = ref.getTypeParameters()) {
            if (parameterType == null || parameterType instanceof PsiWildcardType && ((PsiWildcardType)parameterType).getBound() == null) continue;
            return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)typeElement, JavaErrorMessages.message("illegal.generic.type.for.instanceof", new Object[0]));
        }
        return null;
    }

    public static HighlightInfo checkClassObjectAccessExpression(PsiClassObjectAccessExpression expression) {
        PsiClass aClass;
        PsiType type = expression.getOperand().getType();
        if (type instanceof PsiClassType && (aClass = ((PsiClassType)type).resolve()) instanceof PsiTypeParameter) {
            return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)expression.getOperand(), JavaErrorMessages.message("cannot.select.dot.class.from.type.variable", new Object[0]));
        }
        return null;
    }

    @Nullable
    public static HighlightInfo checkOverrideAnnotation(PsiMethod method) {
        PsiModifierList list = method.getModifierList();
        PsiAnnotation overrideAnnotation = list.findAnnotation("java.lang.Override");
        if (overrideAnnotation == null) {
            return null;
        }
        try {
            MethodSignatureBackedByPsiMethod superMethod = (MethodSignatureBackedByPsiMethod)SuperMethodsSearch.search((PsiMethod)method, null, (boolean)true, (boolean)false).findFirst();
            if (superMethod == null) {
                return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)overrideAnnotation, JavaErrorMessages.message("method.doesnot.override.super", new Object[0]));
            }
            LanguageLevel languageLevel = PsiUtil.getLanguageLevel((PsiElement)method);
            PsiClass superClass = superMethod.getMethod().getContainingClass();
            if (languageLevel.equals((Object)LanguageLevel.JDK_1_5) && superClass != null && superClass.isInterface()) {
                HighlightInfo info = HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)overrideAnnotation, JavaErrorMessages.message("override.not.allowed.in.interfaces", new Object[0]));
                QuickFixAction.registerQuickFixAction(info, new IncreaseLanguageLevelFix(LanguageLevel.JDK_1_6));
                return info;
            }
            return null;
        }
        catch (IndexNotReadyException e) {
            return null;
        }
    }

    static void checkEnumConstantForConstructorProblems(PsiEnumConstant enumConstant, HighlightInfoHolder holder) {
        PsiClass containingClass = enumConstant.getContainingClass();
        if (enumConstant.getInitializingClass() == null) {
            HighlightInfo highlightInfo = HighlightClassUtil.checkInstantiationOfAbstractClass(containingClass, (PsiElement)enumConstant.getNameIdentifier());
            if (highlightInfo != null) {
                holder.add(highlightInfo);
                return;
            }
            highlightInfo = HighlightClassUtil.checkClassWithAbstractMethods(enumConstant.getContainingClass(), enumConstant.getNameIdentifier().getTextRange());
            if (highlightInfo != null) {
                holder.add(highlightInfo);
                return;
            }
        }
        PsiClassType type = JavaPsiFacade.getInstance((Project)enumConstant.getProject()).getElementFactory().createType(containingClass);
        HighlightMethodUtil.checkConstructorCall(type.resolveGenerics(), (PsiConstructorCall)enumConstant, (PsiType)type, null, holder);
    }

    public static HighlightInfo checkEnumSuperConstructorCall(PsiMethodCallExpression expr) {
        PsiMember constructor;
        PsiReferenceExpression methodExpression = expr.getMethodExpression();
        PsiElement refNameElement = methodExpression.getReferenceNameElement();
        if (refNameElement != null && "super".equals(refNameElement.getText()) && (constructor = PsiUtil.findEnclosingConstructorOrInitializer((PsiElement)expr)) instanceof PsiMethod && constructor.getContainingClass().isEnum()) {
            return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)expr, JavaErrorMessages.message("call.to.super.is.not.allowed.in.enum.constructor", new Object[0]));
        }
        return null;
    }

    public static HighlightInfo checkVarArgParameterIsLast(PsiParameter parameter) {
        PsiElement declarationScope = parameter.getDeclarationScope();
        if (declarationScope instanceof PsiMethod) {
            PsiParameter[] params = ((PsiMethod)declarationScope).getParameterList().getParameters();
            if (parameter.isVarArgs()) {
                if (!PsiUtil.getLanguageLevel((PsiElement)parameter).hasEnumKeywordAndAutoboxing()) {
                    HighlightInfo info = HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)parameter, JavaErrorMessages.message("varargs.prior.15", new Object[0]));
                    QuickFixAction.registerQuickFixAction(info, new IncreaseLanguageLevelFix(LanguageLevel.JDK_1_5));
                    return info;
                }
                if (params[params.length - 1] != parameter) {
                    HighlightInfo info = HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)parameter, JavaErrorMessages.message("vararg.not.last.parameter", new Object[0]));
                    QuickFixAction.registerQuickFixAction(info, new MakeVarargParameterLastFix(parameter), null);
                    return info;
                }
            }
        }
        return null;
    }

    public static List<HighlightInfo> checkEnumConstantModifierList(PsiModifierList modifierList) {
        PsiElement[] children;
        ArrayList<HighlightInfo> list = null;
        for (PsiElement child : children = modifierList.getChildren()) {
            if (!(child instanceof PsiKeyword)) continue;
            if (list == null) {
                list = new ArrayList<HighlightInfo>();
            }
            list.add(HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, child, JavaErrorMessages.message("modifiers.for.enum.constants", new Object[0])));
        }
        return list;
    }

    public static HighlightInfo checkGenericCallWithRawArguments(JavaResolveResult resolveResult, PsiCallExpression callExpression) {
        PsiMethod method = (PsiMethod)resolveResult.getElement();
        if (method == null) {
            return null;
        }
        PsiSubstitutor substitutor = resolveResult.getSubstitutor();
        PsiExpressionList argumentList = callExpression.getArgumentList();
        if (argumentList == null) {
            return null;
        }
        PsiExpression[] expressions = argumentList.getExpressions();
        PsiParameter[] parameters = method.getParameterList().getParameters();
        if (parameters.length != 0) {
            for (int i = 0; i < expressions.length; ++i) {
                HighlightInfo highlightInfo;
                PsiParameter parameter = parameters[Math.min(i, parameters.length - 1)];
                PsiExpression expression = expressions[i];
                PsiType parameterType = substitutor.substitute(parameter.getType());
                PsiType expressionType = substitutor.substitute(expression.getType());
                if (expressionType == null || (highlightInfo = GenericsHighlightUtil.checkRawToGenericAssignment(parameterType, expressionType, (PsiElement)expression)) == null) continue;
                return highlightInfo;
            }
        }
        return null;
    }

    public static HighlightInfo checkParametersOnRaw(PsiReferenceParameterList refParamList) {
        if (refParamList.getTypeArguments().length == 0) {
            return null;
        }
        JavaResolveResult resolveResult = null;
        PsiElement parent = refParamList.getParent();
        if (parent instanceof PsiJavaCodeReferenceElement) {
            resolveResult = ((PsiJavaCodeReferenceElement)parent).advancedResolve(false);
        } else if (parent instanceof PsiCallExpression) {
            resolveResult = ((PsiCallExpression)parent).resolveMethodGenerics();
        }
        if (resolveResult != null) {
            PsiElement element = resolveResult.getElement();
            if (!(element instanceof PsiTypeParameterListOwner)) {
                return null;
            }
            if (((PsiModifierListOwner)element).hasModifierProperty("static")) {
                return null;
            }
            PsiClass containingClass = ((PsiMember)element).getContainingClass();
            if (containingClass != null && PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)containingClass, (PsiSubstitutor)resolveResult.getSubstitutor())) {
                String message = element instanceof PsiClass ? JavaErrorMessages.message("generics.type.arguments.on.raw.type", new Object[0]) : JavaErrorMessages.message("generics.type.arguments.on.raw.method", new Object[0]);
                return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)refParamList, message);
            }
        }
        return null;
    }

    public static HighlightInfo checkCannotInheritFromEnum(PsiClass superClass, PsiElement elementToHighlight) {
        HighlightInfo errorResult = null;
        if (Comparing.strEqual((String)"java.lang.Enum", (String)superClass.getQualifiedName())) {
            String message = JavaErrorMessages.message("classes.extends.enum", new Object[0]);
            errorResult = HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, elementToHighlight, message);
        }
        return errorResult;
    }

    public static HighlightInfo checkGenericCannotExtendException(PsiReferenceList list) {
        PsiElement parent = list.getParent();
        if (!(parent instanceof PsiClass)) {
            return null;
        }
        PsiClass aClass = (PsiClass)parent;
        if (!aClass.hasTypeParameters() || aClass.getExtendsList() != list) {
            return null;
        }
        PsiJavaCodeReferenceElement[] referenceElements = list.getReferenceElements();
        PsiClass throwableClass = null;
        for (PsiJavaCodeReferenceElement referenceElement : referenceElements) {
            PsiElement resolved = referenceElement.resolve();
            if (!(resolved instanceof PsiClass)) continue;
            if (throwableClass == null) {
                throwableClass = JavaPsiFacade.getInstance((Project)aClass.getProject()).findClass("java.lang.Throwable", aClass.getResolveScope());
            }
            if (!InheritanceUtil.isInheritorOrSelf((PsiClass)((PsiClass)resolved), throwableClass, (boolean)true)) continue;
            String message = JavaErrorMessages.message("generic.extend.exception", new Object[0]);
            HighlightInfo highlightInfo = HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)referenceElement, message);
            PsiClassType classType = JavaPsiFacade.getInstance((Project)aClass.getProject()).getElementFactory().createType((PsiClass)resolved);
            QuickFixAction.registerQuickFixAction(highlightInfo, QUICK_FIX_FACTORY.createExtendsListFix(aClass, classType, false));
            return highlightInfo;
        }
        return null;
    }

    public static HighlightInfo checkUncheckedOverriding(PsiMethod overrider, List<HierarchicalMethodSignature> superMethodSignatures) {
        if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)overrider)) {
            return null;
        }
        HighlightDisplayKey key = HighlightDisplayKey.find((String)"UNCHECKED_WARNING");
        InspectionProfile inspectionProfile = InspectionProjectProfileManager.getInstance(overrider.getProject()).getInspectionProfile();
        if (!inspectionProfile.isToolEnabled(key, (PsiElement)overrider)) {
            return null;
        }
        LocalInspectionTool tool = ((LocalInspectionToolWrapper)inspectionProfile.getInspectionTool("UNCHECKED_WARNING", (PsiElement)overrider)).getTool();
        if (InspectionManagerEx.inspectionResultSuppressed((PsiElement)overrider, tool)) {
            return null;
        }
        MethodSignature signature = overrider.getSignature(PsiSubstitutor.EMPTY);
        for (HierarchicalMethodSignature superSignature : superMethodSignatures) {
            PsiMethod baseMethod = superSignature.getMethod();
            PsiSubstitutor substitutor = MethodSignatureUtil.getSuperMethodSignatureSubstitutor((MethodSignature)signature, (MethodSignature)superSignature);
            if (substitutor == null) {
                substitutor = superSignature.getSubstitutor();
            }
            if (PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)baseMethod, (PsiSubstitutor)superSignature.getSubstitutor())) continue;
            PsiType baseReturnType = substitutor.substitute(baseMethod.getReturnType());
            PsiType overriderReturnType = overrider.getReturnType();
            if (baseReturnType == null || overriderReturnType == null) {
                return null;
            }
            if (!GenericsHighlightUtil.isRawToGeneric(baseReturnType, overriderReturnType)) continue;
            String message = JavaErrorMessages.message("unchecked.overriding.incompatible.return.type", HighlightUtil.formatType(overriderReturnType), HighlightUtil.formatType(baseReturnType));
            PsiTypeElement returnTypeElement = overrider.getReturnTypeElement();
            LOG.assertTrue(returnTypeElement != null);
            HighlightInfo highlightInfo = HighlightInfo.createHighlightInfo(JavaHightlightInfoTypes.UNCHECKED_WARNING, (PsiElement)returnTypeElement, message);
            QuickFixAction.registerQuickFixAction(highlightInfo, new EmptyIntentionAction(JavaErrorMessages.message("unchecked.overriding", new Object[0])), key);
            return highlightInfo;
        }
        return null;
    }

    public static HighlightInfo checkEnumMustNotBeLocal(PsiClass aClass) {
        if (!aClass.isEnum()) {
            return null;
        }
        PsiElement parent = aClass.getParent();
        if (!(parent instanceof PsiClass) && !(parent instanceof PsiFile)) {
            return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, HighlightNamesUtil.getClassDeclarationTextRange(aClass), JavaErrorMessages.message("local.enum", new Object[0]));
        }
        return null;
    }

    public static HighlightInfo checkSelectStaticClassFromParameterizedType(PsiElement resolved, PsiJavaCodeReferenceElement ref) {
        PsiReferenceParameterList parameterList;
        PsiElement qualifier;
        if (resolved instanceof PsiClass && ((PsiClass)resolved).hasModifierProperty("static") && (qualifier = ref.getQualifier()) instanceof PsiJavaCodeReferenceElement && (parameterList = ((PsiJavaCodeReferenceElement)qualifier).getParameterList()) != null && parameterList.getTypeArguments().length > 0) {
            String message = JavaErrorMessages.message("generics.select.static.class.from.parameterized.type", HighlightUtil.formatClass((PsiClass)resolved));
            return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)parameterList, message);
        }
        return null;
    }

    public static HighlightInfo checkCannotInheritFromTypeParameter(PsiClass superClass, PsiJavaCodeReferenceElement toHighlight) {
        if (superClass instanceof PsiTypeParameter) {
            return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)toHighlight, JavaErrorMessages.message("class.cannot.inherit.from.its.type.parameter", new Object[0]));
        }
        return null;
    }
}

