/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.ChangeLocalityDetector;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorMarkupModel;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.PsiDocumentManagerImpl;
import com.intellij.psi.impl.PsiDocumentTransactionListener;
import com.intellij.util.SmartList;
import com.intellij.util.messages.MessageBusConnection;
import gnu.trove.THashMap;
import java.awt.Component;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiChangeHandler
extends PsiTreeChangeAdapter
implements Disposable {
    private static final ExtensionPointName<ChangeLocalityDetector> EP_NAME = ExtensionPointName.create((String)"com.intellij.daemon.changeLocalityDetector");
    private final Key<Boolean> UPDATE_ON_COMMIT_ENGAGED = Key.create((String)"UPDATE_ON_COMMIT_ENGAGED");
    private final Project myProject;
    private final DaemonCodeAnalyzerImpl myDaemonCodeAnalyzer;
    private final Map<Document, List<Pair<PsiElement, Boolean>>> changedElements = new THashMap();
    private final FileStatusMap myFileStatusMap;

    public PsiChangeHandler(Project project, DaemonCodeAnalyzerImpl daemonCodeAnalyzer, final PsiDocumentManagerImpl documentManager, EditorFactory editorFactory, MessageBusConnection connection) {
        this.myProject = project;
        this.myDaemonCodeAnalyzer = daemonCodeAnalyzer;
        this.myFileStatusMap = daemonCodeAnalyzer.getFileStatusMap();
        editorFactory.getEventMulticaster().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void beforeDocumentChange(DocumentEvent e) {
                final Document document = e.getDocument();
                if (documentManager.getSynchronizer().isInSynchronization(document)) {
                    return;
                }
                if (documentManager.getCachedPsiFile(document) == null) {
                    return;
                }
                if (document.getUserData(PsiChangeHandler.this.UPDATE_ON_COMMIT_ENGAGED) == null) {
                    document.putUserData(PsiChangeHandler.this.UPDATE_ON_COMMIT_ENGAGED, (Object)Boolean.TRUE);
                    documentManager.addRunOnCommit(document, new Runnable(){

                        @Override
                        public void run() {
                            PsiChangeHandler.this.updateChangesForDocument(document);
                            document.putUserData(PsiChangeHandler.this.UPDATE_ON_COMMIT_ENGAGED, null);
                        }
                    });
                }
            }
        }, (Disposable)this);
        connection.subscribe(PsiDocumentTransactionListener.TOPIC, (Object)new PsiDocumentTransactionListener(){

            @Override
            public void transactionStarted(Document doc, PsiFile file) {
            }

            @Override
            public void transactionCompleted(Document doc, PsiFile file) {
                PsiChangeHandler.this.updateChangesForDocument(doc);
            }
        });
    }

    public void dispose() {
    }

    private void updateChangesForDocument(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/PsiChangeHandler.updateChangesForDocument must not be null");
        }
        List<Pair<PsiElement, Boolean>> toUpdate = this.changedElements.get(document);
        if (toUpdate != null) {
            for (Pair<PsiElement, Boolean> changedElement : toUpdate) {
                PsiElement element = (PsiElement)changedElement.getFirst();
                Boolean whiteSpaceOptimizationAllowed = (Boolean)changedElement.getSecond();
                this.updateByChange(element, whiteSpaceOptimizationAllowed);
            }
            this.changedElements.remove(document);
        }
    }

    public void childAdded(PsiTreeChangeEvent event) {
        this.queueElement(event.getParent(), true, event);
    }

    public void childRemoved(PsiTreeChangeEvent event) {
        this.queueElement(event.getParent(), true, event);
    }

    public void childReplaced(PsiTreeChangeEvent event) {
        this.queueElement(event.getNewChild(), PsiChangeHandler.typesEqual(event.getNewChild(), event.getOldChild()), event);
    }

    private static boolean typesEqual(PsiElement newChild, PsiElement oldChild) {
        return newChild != null && oldChild != null && newChild.getClass() == oldChild.getClass();
    }

    public void childrenChanged(PsiTreeChangeEvent event) {
        this.queueElement(event.getParent(), true, event);
    }

    public void beforeChildMovement(PsiTreeChangeEvent event) {
        this.queueElement(event.getOldParent(), true, event);
        this.queueElement(event.getNewParent(), true, event);
    }

    public void beforeChildrenChange(PsiTreeChangeEvent event) {
        PsiFile psiFile = event.getFile();
        if (psiFile != null) {
            this.myFileStatusMap.markFileScopeDirtyDefensively(psiFile);
        }
    }

    public void propertyChanged(PsiTreeChangeEvent event) {
        String propertyName = event.getPropertyName();
        if (!propertyName.equals("writable")) {
            this.myFileStatusMap.markAllFilesDirty();
            this.myDaemonCodeAnalyzer.stopProcess(true);
        }
    }

    private void queueElement(PsiElement child, boolean whitespaceOptimizationAllowed, PsiTreeChangeEvent event) {
        PsiFile file = event.getFile();
        if (file == null) {
            file = child.getContainingFile();
        }
        if (file == null) {
            this.myFileStatusMap.markAllFilesDirty();
            return;
        }
        if (!child.isValid()) {
            return;
        }
        Document document = PsiDocumentManager.getInstance((Project)this.myProject).getCachedDocument(file);
        if (document != null) {
            SmartList toUpdate = this.changedElements.get(document);
            if (toUpdate == null) {
                toUpdate = new SmartList();
                this.changedElements.put(document, (List<Pair<PsiElement, Boolean>>)toUpdate);
            }
            toUpdate.add(Pair.create((Object)child, (Object)whitespaceOptimizationAllowed));
        }
    }

    private void updateByChange(PsiElement child, boolean whitespaceOptimizationAllowed) {
        PsiFile file;
        final Editor editor = FileEditorManager.getInstance((Project)this.myProject).getSelectedTextEditor();
        if (editor != null) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (PsiChangeHandler.this.myProject.isDisposed()) {
                        return;
                    }
                    EditorMarkupModel markupModel = (EditorMarkupModel)editor.getMarkupModel();
                    markupModel.setErrorStripeRenderer(markupModel.getErrorStripeRenderer());
                }
            }, ModalityState.stateForComponent((Component)editor.getComponent()));
        }
        if ((file = child.getContainingFile()) == null || file instanceof PsiCompiledElement) {
            this.myFileStatusMap.markAllFilesDirty();
            return;
        }
        Document document = PsiDocumentManager.getInstance((Project)this.myProject).getCachedDocument(file);
        if (document == null) {
            return;
        }
        int fileLength = file.getTextLength();
        if (!file.getViewProvider().isPhysical()) {
            this.myFileStatusMap.markFileScopeDirty(document, new TextRange(0, fileLength), fileLength);
            return;
        }
        if (whitespaceOptimizationAllowed && UpdateHighlightersUtil.isWhitespaceOptimizationAllowed(document) && (child instanceof PsiWhiteSpace || child instanceof PsiComment && !child.getText().contains("noinspection"))) {
            this.myFileStatusMap.markFileScopeDirty(document, child.getTextRange(), fileLength);
            return;
        }
        PsiElement element = child;
        while (true) {
            if (element instanceof PsiFile || element instanceof PsiDirectory) {
                this.myFileStatusMap.markAllFilesDirty();
                return;
            }
            PsiElement scope = PsiChangeHandler.getChangeHighlightingScope(element);
            if (scope != null) {
                this.myFileStatusMap.markFileScopeDirty(document, scope.getTextRange(), fileLength);
                return;
            }
            element = element.getParent();
        }
    }

    @Nullable
    private static PsiElement getChangeHighlightingScope(PsiElement element) {
        for (ChangeLocalityDetector detector : (ChangeLocalityDetector[])Extensions.getExtensions(EP_NAME)) {
            PsiElement scope = detector.getChangeHighlightingDirtyScopeFor(element);
            if (scope == null) continue;
            return scope;
        }
        return null;
    }
}

