/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion.impl;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.util.containers.hash.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class CamelHumpMatcher
extends PrefixMatcher {
    private static int ourLastCompletionCaseSetting = -1;
    private static final Map<String, NameUtil.Matcher> ourPatternCache = new LinkedHashMap<String, NameUtil.Matcher>(){

        protected boolean removeEldestEntry(Map.Entry<String, NameUtil.Matcher> eldest) {
            return this.size() > 10;
        }
    };
    private NameUtil.Matcher myMatcher;
    private final boolean myCaseSensitive;
    private final int currentSetting;

    public CamelHumpMatcher(@NotNull String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/completion/impl/CamelHumpMatcher.<init> must not be null");
        }
        this(prefix, true);
    }

    public CamelHumpMatcher(String prefix, boolean caseSensitive) {
        super(prefix);
        this.currentSetting = CodeInsightSettings.getInstance().COMPLETION_CASE_SENSITIVE;
        this.myCaseSensitive = caseSensitive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean prefixMatches(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/completion/impl/CamelHumpMatcher.prefixMatches must not be null");
        }
        Map<String, NameUtil.Matcher> map = ourPatternCache;
        synchronized (map) {
            if (this.myMatcher == null) {
                NameUtil.Matcher pattern;
                if (ourLastCompletionCaseSetting != this.currentSetting) {
                    ourPatternCache.clear();
                    ourLastCompletionCaseSetting = this.currentSetting;
                }
                if ((pattern = ourPatternCache.get(this.myPrefix)) == null) {
                    pattern = this.createCamelHumpsMatcher();
                    ourPatternCache.put(this.myPrefix, pattern);
                }
                this.myMatcher = pattern;
            }
            return this.myMatcher.matches(name);
        }
    }

    public boolean prefixMatches(@NotNull LookupElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/completion/impl/CamelHumpMatcher.prefixMatches must not be null");
        }
        return this.prefixMatchersInternal(element, !element.isCaseSensitive());
    }

    private boolean prefixMatchersInternal(LookupElement element, boolean itemCaseInsensitive) {
        for (String name : element.getAllLookupStrings()) {
            char c;
            String swappedCase;
            if (itemCaseInsensitive && StringUtil.startsWithIgnoreCase((String)name, (String)this.myPrefix) || this.prefixMatches(name)) {
                return true;
            }
            if (!itemCaseInsensitive || 1 == CodeInsightSettings.getInstance().COMPLETION_CASE_SENSITIVE || name.length() <= 0 || !this.prefixMatches(swappedCase = (Character.isUpperCase(c = name.charAt(0)) ? Character.toLowerCase(c) : Character.toUpperCase(c)) + name.substring(1))) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public PrefixMatcher cloneWithPrefix(@NotNull String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/completion/impl/CamelHumpMatcher.cloneWithPrefix must not be null");
        }
        CamelHumpMatcher camelHumpMatcher = new CamelHumpMatcher(prefix);
        if (camelHumpMatcher == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/completion/impl/CamelHumpMatcher.cloneWithPrefix must not return null");
        }
        return camelHumpMatcher;
    }

    private NameUtil.Matcher createCamelHumpsMatcher() {
        if (!this.myCaseSensitive) {
            return NameUtil.buildMatcher((String)this.myPrefix, (int)0, (boolean)true, (boolean)true);
        }
        switch (CodeInsightSettings.getInstance().COMPLETION_CASE_SENSITIVE) {
            case 2: {
                return NameUtil.buildMatcher((String)this.myPrefix, (int)0, (boolean)true, (boolean)true);
            }
            case 3: {
                int exactPrefixLen = this.myPrefix.startsWith("*") ? 0 : 1;
                return NameUtil.buildMatcher((String)this.myPrefix, (int)exactPrefixLen, (boolean)true, (boolean)true);
            }
            case 1: {
                return NameUtil.buildMatcher((String)this.myPrefix, (int)0, (boolean)false, (boolean)false);
            }
        }
        return NameUtil.buildMatcher((String)this.myPrefix, (int)0, (boolean)true, (boolean)false);
    }

    public String toString() {
        return this.myPrefix;
    }
}

