/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionLocation;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionPreselectSkipper;
import com.intellij.codeInsight.completion.CompletionService;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupArranger;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInsight.lookup.impl.LookupItemWeightComparable;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.WeighingComparable;
import com.intellij.psi.WeighingService;
import com.intellij.psi.statistics.StatisticsInfo;
import com.intellij.psi.statistics.StatisticsManager;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class CompletionLookupArranger
extends LookupArranger {
    public static final Key<LookupItemWeightComparable> RELEVANCE_KEY = Key.create((String)"RELEVANCE_KEY");
    private static final String SELECTED = "selected";
    static final String IGNORED = "ignored";
    private final CompletionLocation myLocation;
    public static final Key<Comparable[]> WEIGHT = Key.create((String)"WEIGHT");
    private final Map<LookupElement, Comparable> mySortingWeights = new THashMap(TObjectHashingStrategy.IDENTITY);

    public CompletionLookupArranger(CompletionParameters parameters) {
        this.myLocation = new CompletionLocation(parameters);
    }

    @Override
    public void sortItems(List<LookupElement> items) {
        Collections.sort(items, new Comparator<LookupElement>(){

            @Override
            public int compare(LookupElement o1, LookupElement o2) {
                return CompletionLookupArranger.this.getSortingWeight(o1).compareTo(CompletionLookupArranger.this.getSortingWeight(o2));
            }
        });
    }

    @Override
    public void itemSelected(LookupElement item, Lookup lookup) {
        StatisticsManager manager = StatisticsManager.getInstance();
        manager.incUseCount(CompletionService.STATISTICS_KEY, (Object)item, (Object)this.myLocation);
        List<LookupElement> items = lookup.getItems();
        LookupImpl lookupImpl = (LookupImpl)lookup;
        int count = Math.min(lookupImpl.getPreferredItemsCount(), lookupImpl.getList().getSelectedIndex());
        for (int i = 0; i < count; ++i) {
            LookupElement element = items.get(i);
            StatisticsInfo info = StatisticsManager.serialize((Key)CompletionService.STATISTICS_KEY, (Object)element, (Object)this.myLocation);
            if (info == null || info == StatisticsInfo.EMPTY || manager.getUseCount(info) != 0) continue;
            manager.incUseCount(new StatisticsInfo(CompletionLookupArranger.composeContextWithValue(info), item == element ? SELECTED : IGNORED));
        }
    }

    @Override
    public int suggestPreselectedItem(List<LookupElement> sorted) {
        CompletionPreselectSkipper[] skippers = (CompletionPreselectSkipper[])CompletionPreselectSkipper.EP_NAME.getExtensions();
        block0: for (int i = 0; i < sorted.size(); ++i) {
            LookupElement item = sorted.get(i);
            Object obj = item.getObject();
            if (obj instanceof PsiElement && !((PsiElement)obj).isValid()) continue;
            for (CompletionPreselectSkipper skipper : skippers) {
                if (skipper.skipElement(item, this.myLocation)) continue block0;
            }
            return i;
        }
        return sorted.size() - 1;
    }

    public static String composeContextWithValue(StatisticsInfo info) {
        return info.getContext() + "###" + info.getValue();
    }

    public Comparable[] getRelevanceWeight(LookupElement item) {
        if (item.getUserData(WEIGHT) != null) {
            return (Comparable[])item.getUserData(WEIGHT);
        }
        Comparable[] result = new Comparable[]{WeighingService.weigh((Key)CompletionService.RELEVANCE_KEY, (Object)item, (Object)this.myLocation)};
        item.putUserData(WEIGHT, (Object)result);
        return result;
    }

    public Comparable getSortingWeight(LookupElement item) {
        Comparable comparable = this.mySortingWeights.get(item);
        if (comparable != null) {
            return comparable;
        }
        WeighingComparable result = WeighingService.weigh((Key)CompletionService.SORTING_KEY, (Object)item, (Object)this.myLocation);
        this.mySortingWeights.put(item, (Comparable)result);
        return result;
    }

    public static int doCompare(double priority1, double priority2, Comparable[] weight1, Comparable[] weight2) {
        if (priority1 != priority2) {
            double v = priority1 - priority2;
            if (v > 0.0) {
                return -1;
            }
            if (v < 0.0) {
                return 1;
            }
        }
        for (int i = 0; i < weight1.length; ++i) {
            Comparable w2;
            Comparable w1 = weight1[i];
            Comparable comparable = w2 = i < weight2.length ? weight2[i] : null;
            if (w1 == null && w2 == null) continue;
            if (w1 == null) {
                return 1;
            }
            if (w2 == null) {
                return -1;
            }
            int res = w1.compareTo(w2);
            if (res == 0) continue;
            return -res;
        }
        return 0;
    }

    @Override
    public LookupItemWeightComparable getRelevance(LookupElement item) {
        if (item.getUserData(RELEVANCE_KEY) != null) {
            return (LookupItemWeightComparable)item.getUserData(RELEVANCE_KEY);
        }
        double priority = item instanceof LookupItem ? ((LookupItem)item).getPriority() : 0.0;
        LookupItemWeightComparable result = new LookupItemWeightComparable(priority, this.getRelevanceWeight(item));
        item.putUserData(RELEVANCE_KEY, (Object)result);
        return result;
    }
}

