/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.StringComboboxEditor;
import javax.swing.JComboBox;

public class ComboEditorCompletionContributor
extends CompletionContributor {
    public void fillCompletionVariants(CompletionParameters parameters, CompletionResultSet result) {
        JComboBox comboBox;
        PsiFile file = parameters.getOriginalFile();
        Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
        if (document != null && (comboBox = (JComboBox)document.getUserData(StringComboboxEditor.COMBO_BOX_KEY)) != null) {
            CompletionResultSet resultSet = result.withPrefixMatcher(document.getText().substring(0, parameters.getOffset()));
            int count = comboBox.getItemCount();
            for (int i = 0; i < count; ++i) {
                Object o = comboBox.getItemAt(i);
                if (!(o instanceof String)) continue;
                resultSet.addElement(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)((String)o)).setInsertHandler((InsertHandler)new InsertHandler<LookupElement>(){

                    public void handleInsert(InsertionContext context, LookupElement item) {
                        Document document = context.getEditor().getDocument();
                        document.deleteString(context.getEditor().getCaretModel().getOffset(), document.getTextLength());
                    }
                }), (double)(count - i)));
            }
            result.stopHere();
        }
    }
}

