/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.psi.impl;

import com.intellij.extapi.psi.PsiFileBase;
import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.lang.properties.PropertiesUtil;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.ResourceBundleImpl;
import com.intellij.lang.properties.parsing.PropertiesElementTypes;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.Property;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLock;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.tree.ChangeUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropertiesFileImpl
extends PsiFileBase
implements PropertiesFile {
    private static final TokenSet outPropertiesListSet = TokenSet.create((IElementType[])new IElementType[]{PropertiesElementTypes.PROPERTIES_LIST});
    private Map<String, List<Property>> myPropertiesMap;
    private List<Property> myProperties;

    public PropertiesFileImpl(FileViewProvider viewProvider) {
        super(viewProvider, StdFileTypes.PROPERTIES.getLanguage());
    }

    @NotNull
    public FileType getFileType() {
        LanguageFileType languageFileType = StdFileTypes.PROPERTIES;
        if (languageFileType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/properties/psi/impl/PropertiesFileImpl.getFileType must not return null");
        }
        return languageFileType;
    }

    @NonNls
    public String toString() {
        return "Properties file:" + this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public List<Property> getProperties() {
        Object object = PsiLock.LOCK;
        // MONITORENTER : object
        this.ensurePropertiesLoaded();
        List<Property> list = this.myProperties;
        // MONITOREXIT : object
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/lang/properties/psi/impl/PropertiesFileImpl.getProperties must not return null");
    }

    private ASTNode getPropertiesList() {
        ASTNode[] nodes = this.getNode().getChildren(outPropertiesListSet);
        return nodes.length > 0 ? nodes[0] : null;
    }

    private void ensurePropertiesLoaded() {
        if (this.myPropertiesMap != null) {
            return;
        }
        ASTNode[] props = this.getPropertiesList().getChildren(PropertiesElementTypes.PROPERTIES);
        this.myPropertiesMap = new LinkedHashMap<String, List<Property>>();
        this.myProperties = new ArrayList<Property>(props.length);
        for (ASTNode prop : props) {
            Property property = (Property)prop.getPsi();
            String key = property.getUnescapedKey();
            SmartList list = this.myPropertiesMap.get(key);
            if (list == null) {
                list = new SmartList();
                this.myPropertiesMap.put(key, (List<Property>)list);
            }
            list.add((Property)property);
            this.myProperties.add(property);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Property findPropertyByKey(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/properties/psi/impl/PropertiesFileImpl.findPropertyByKey must not be null");
        }
        Object object = PsiLock.LOCK;
        synchronized (object) {
            this.ensurePropertiesLoaded();
            List<Property> list = this.myPropertiesMap.get(key);
            return list == null ? null : list.get(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public List<Property> findPropertiesByKey(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/properties/psi/impl/PropertiesFileImpl.findPropertiesByKey must not be null");
        }
        Object object = PsiLock.LOCK;
        // MONITORENTER : object
        this.ensurePropertiesLoaded();
        List<Property> list2 = this.myPropertiesMap.get(key);
        List<Object> list = list2 == null ? Collections.emptyList() : list2;
        // MONITOREXIT : object
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/lang/properties/psi/impl/PropertiesFileImpl.findPropertiesByKey must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public ResourceBundle getResourceBundle() {
        ResourceBundle resourceBundle;
        VirtualFile virtualFile = this.getVirtualFile();
        if (!this.isValid() || virtualFile == null) {
            resourceBundle = ResourceBundleImpl.NULL;
            if (resourceBundle == null) throw new IllegalStateException("@NotNull method com/intellij/lang/properties/psi/impl/PropertiesFileImpl.getResourceBundle must not return null");
            return resourceBundle;
        }
        String baseName = PropertiesUtil.getBaseName(virtualFile);
        PsiDirectory directory = (PsiDirectory)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiDirectory>(){

            @Nullable
            public PsiDirectory compute() {
                return PropertiesFileImpl.this.getContainingFile().getContainingDirectory();
            }
        });
        if (directory == null) {
            resourceBundle = ResourceBundleImpl.NULL;
            if (resourceBundle == null) throw new IllegalStateException("@NotNull method com/intellij/lang/properties/psi/impl/PropertiesFileImpl.getResourceBundle must not return null");
            return resourceBundle;
        }
        resourceBundle = new ResourceBundleImpl(directory.getVirtualFile(), baseName);
        if (resourceBundle != null) return resourceBundle;
        throw new IllegalStateException("@NotNull method com/intellij/lang/properties/psi/impl/PropertiesFileImpl.getResourceBundle must not return null");
    }

    @Override
    @NotNull
    public Locale getLocale() {
        Locale locale = PropertiesUtil.getLocale(this.getVirtualFile());
        if (locale == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/properties/psi/impl/PropertiesFileImpl.getLocale must not return null");
        }
        return locale;
    }

    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/properties/psi/impl/PropertiesFileImpl.add must not be null");
        }
        if (element instanceof Property) {
            throw new IncorrectOperationException("Use addProperty() instead");
        }
        return super.add(element);
    }

    @Override
    @NotNull
    public PsiElement addProperty(@NotNull Property property) throws IncorrectOperationException {
        if (property == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/properties/psi/impl/PropertiesFileImpl.addProperty must not be null");
        }
        if (this.haveToAddNewLine()) {
            this.insertLinebreakBefore(null);
        }
        TreeElement copy = ChangeUtil.copyToElement((PsiElement)property);
        this.getPropertiesList().addChild((ASTNode)copy);
        PsiElement psiElement = copy.getPsi();
        if (psiElement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/properties/psi/impl/PropertiesFileImpl.addProperty must not return null");
        }
        return psiElement;
    }

    @Override
    @NotNull
    public PsiElement addPropertyAfter(@NotNull Property property, @Nullable Property anchor) throws IncorrectOperationException {
        ASTNode anchorBefore;
        if (property == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/properties/psi/impl/PropertiesFileImpl.addPropertyAfter must not be null");
        }
        TreeElement copy = ChangeUtil.copyToElement((PsiElement)property);
        List<Property> properties = this.getProperties();
        Object object = anchor == null ? (properties.isEmpty() ? null : properties.get(0).getNode()) : (anchorBefore = anchor.getNode().getTreeNext());
        if (anchorBefore != null && anchorBefore.getElementType() == TokenType.WHITE_SPACE) {
            anchorBefore = anchorBefore.getTreeNext();
        }
        if (anchorBefore == null && this.haveToAddNewLine()) {
            this.insertLinebreakBefore(null);
        }
        this.getPropertiesList().addChild((ASTNode)copy, anchorBefore);
        if (anchorBefore != null) {
            this.insertLinebreakBefore(anchorBefore);
        }
        PsiElement psiElement = copy.getPsi();
        if (psiElement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/properties/psi/impl/PropertiesFileImpl.addPropertyAfter must not return null");
        }
        return psiElement;
    }

    private void insertLinebreakBefore(ASTNode anchorBefore) {
        this.getPropertiesList().addChild((ASTNode)ASTFactory.whitespace((CharSequence)"\n"), anchorBefore);
    }

    private boolean haveToAddNewLine() {
        ASTNode lastChild = this.getPropertiesList().getLastChildNode();
        return lastChild != null && !lastChild.getText().endsWith("\n");
    }

    @Override
    @NotNull
    public Map<String, String> getNamesMap() {
        THashMap result = new THashMap();
        for (Property property : this.getProperties()) {
            result.put(property.getUnescapedKey(), property.getValue());
        }
        THashMap tHashMap = result;
        if (tHashMap == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/properties/psi/impl/PropertiesFileImpl.getNamesMap must not return null");
        }
        return tHashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCaches() {
        super.clearCaches();
        Object object = PsiLock.LOCK;
        synchronized (object) {
            this.myPropertiesMap = null;
            this.myProperties = null;
        }
    }
}

