/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.psi.impl;

import com.intellij.lang.ant.AntElementRole;
import com.intellij.lang.ant.misc.PsiElementSetSpinAllocator;
import com.intellij.lang.ant.psi.AntElement;
import com.intellij.lang.ant.psi.AntElementVisitor;
import com.intellij.lang.ant.psi.AntFile;
import com.intellij.lang.ant.psi.AntProject;
import com.intellij.lang.ant.psi.AntTarget;
import com.intellij.lang.ant.psi.impl.AntFileImpl;
import com.intellij.lang.ant.psi.impl.AntImportImpl;
import com.intellij.lang.ant.psi.impl.AntStructuredElementImpl;
import com.intellij.lang.ant.psi.impl.reference.AntTargetReference;
import com.intellij.lang.ant.psi.introspection.AntTypeDefinition;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiLock;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.StringBuilderSpinAllocator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AntProjectImpl
extends AntStructuredElementImpl
implements AntProject {
    private volatile AntTarget[] myTargets;
    private volatile AntTarget[] myImportedTargets;
    private volatile List<AntFile> myImports;
    private AntFile[] myCachedImportsArray;
    private volatile Map<String, AntElement> myReferencedElements;
    private volatile String[] myRefIdsArray;
    private int myBuildingImports = 0;

    public AntProjectImpl(AntFileImpl parent, XmlTag tag, AntTypeDefinition projectDefinition) {
        super((AntElement)parent, tag);
        this.myDefinition = projectDefinition;
    }

    @Override
    public void acceptAntElementVisitor(@NotNull AntElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/ant/psi/impl/AntProjectImpl.acceptAntElementVisitor must not be null");
        }
        visitor.visitAntProject(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNls
    public String toString() {
        StringBuilder builder = StringBuilderSpinAllocator.alloc();
        try {
            builder.append("AntProject[");
            String name = this.getName();
            builder.append(name == null ? "unnamed" : name);
            builder.append("]");
            if (this.getDescription() != null) {
                builder.append(" :");
                builder.append(this.getDescription());
            }
            String string = builder.toString();
            return string;
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)builder);
        }
    }

    @Override
    public AntElementRole getRole() {
        return AntElementRole.PROJECT_ROLE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCaches() {
        Object object = PsiLock.LOCK;
        synchronized (object) {
            super.clearCaches();
            this.myTargets = null;
            this.clearImports();
            this.myReferencedElements = null;
            this.myRefIdsArray = null;
            AntFile antFile = this.getAntFile();
            if (antFile != null) {
                antFile.invalidateProperties();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearImports() {
        Object object = PsiLock.LOCK;
        synchronized (object) {
            if (this.myBuildingImports == 0) {
                this.myImports = null;
            }
            this.myCachedImportsArray = null;
            this.myImportedTargets = null;
        }
    }

    @Override
    @Nullable
    public String getBaseDir() {
        return this.computeAttributeValue(this.getSourceElement().getAttributeValue("basedir"));
    }

    @Override
    @Nullable
    public String getDescription() {
        XmlTag tag = this.getSourceElement().findFirstSubTag("description");
        return tag != null ? tag.getValue().getTrimmedText() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public AntTarget[] getTargets() {
        AntTarget[] antTargetArray;
        Object object = PsiLock.LOCK;
        synchronized (object) {
            if (this.myTargets != null) {
                // MONITOREXIT @DISABLED, blocks:[3, 11] lbl4 : MonitorExitStatement: MONITOREXIT : var1_1
                antTargetArray = this.myTargets;
                if (this.myTargets == null) throw new IllegalStateException("@NotNull method com/intellij/lang/ant/psi/impl/AntProjectImpl.getTargets must not return null");
                return antTargetArray;
            }
            if (this.myInGettingChildren) {
                // MONITOREXIT @DISABLED, blocks:[3, 10] lbl9 : MonitorExitStatement: MONITOREXIT : var1_1
                antTargetArray = AntTarget.EMPTY_ARRAY;
                if (AntTarget.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/lang/ant/psi/impl/AntProjectImpl.getTargets must not return null");
                return antTargetArray;
            }
            ArrayList<AntTarget> targets = new ArrayList<AntTarget>();
            for (AntElement child : this.getChildren()) {
                if (!(child instanceof AntTarget)) continue;
                targets.add((AntTarget)child);
            }
            int size = targets.size();
            this.myTargets = size == 0 ? AntTarget.EMPTY_ARRAY : targets.toArray(new AntTarget[size]);
        }
        antTargetArray = this.myTargets;
        if (this.myTargets != null) return antTargetArray;
        throw new IllegalStateException("@NotNull method com/intellij/lang/ant/psi/impl/AntProjectImpl.getTargets must not return null");
    }

    @Override
    @Nullable
    public AntTarget getDefaultTarget() {
        for (PsiReference ref : this.getReferences()) {
            if (!(ref instanceof AntTargetReference)) continue;
            return (AntTarget)ref.resolve();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public AntTarget[] getImportedTargets() {
        Object object = PsiLock.LOCK;
        synchronized (object) {
            if (this.myImportedTargets == null) {
                if (this.getImportedFiles().length == 0) {
                    this.myImportedTargets = AntTarget.EMPTY_ARRAY;
                } else {
                    Set<PsiElement> targets = PsiElementSetSpinAllocator.alloc();
                    try {
                        Set<PsiElement> elementsDepthStack = PsiElementSetSpinAllocator.alloc();
                        try {
                            AntProjectImpl.getImportedTargets(this, targets, elementsDepthStack);
                        }
                        finally {
                            PsiElementSetSpinAllocator.dispose(elementsDepthStack);
                        }
                        int size = targets.size();
                        this.myImportedTargets = size == 0 ? AntTarget.EMPTY_ARRAY : targets.toArray(new AntTarget[size]);
                    }
                    finally {
                        PsiElementSetSpinAllocator.dispose(targets);
                    }
                }
            }
        }
        if (this.myImportedTargets == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/ant/psi/impl/AntProjectImpl.getImportedTargets must not return null");
        }
        return this.myImportedTargets;
    }

    @Override
    @Nullable
    public AntTarget getTarget(String name) {
        for (AntTarget target : this.getTargets()) {
            if (!name.equals(target.getName())) continue;
            return target;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public AntFile[] getImportedFiles() {
        Object object = PsiLock.LOCK;
        // MONITORENTER : object
        if (this.myImports == null) {
            this.myImports = new ArrayList<AntFile>();
            XmlTag se = this.getSourceElement();
            PsiFile psiFile = se.getContainingFile();
            StringBuilder builder = StringBuilderSpinAllocator.alloc();
            ++this.myBuildingImports;
            try {
                for (XmlTag tag : se.getSubTags()) {
                    AntFile imported;
                    String fileName;
                    if (!psiFile.equals(tag.getContainingFile())) {
                        AntProjectImpl.buildTagText(tag, builder);
                        continue;
                    }
                    if (!"import".equals(tag.getName()) || (fileName = tag.getAttributeValue("file")) == null || (imported = AntImportImpl.getImportedFile(fileName, this)) == null) continue;
                    this.addImportedFile(imported);
                }
                if (builder.length() > 0) {
                    builder.insert(0, "\">");
                    String baseDir = this.getBaseDir();
                    if (baseDir != null && baseDir.length() > 0) {
                        builder.insert(0, baseDir);
                    }
                    builder.insert(0, "<project basedir=\"");
                    builder.append("</project>");
                    XmlFile xmlFile = (XmlFile)PsiFileFactory.getInstance((Project)this.getProject()).createFileFromText("dummyEntities.xml", (FileType)StdFileTypes.XML, (CharSequence)builder.toString(), LocalTimeCounter.currentTime(), false, false);
                    this.addImportedFile(new AntFileImpl(xmlFile.getViewProvider()){

                        @Override
                        public VirtualFile getContainingPath() {
                            return AntProjectImpl.this.getAntFile().getContainingPath();
                        }
                    });
                }
            }
            finally {
                StringBuilderSpinAllocator.dispose((StringBuilder)builder);
                --this.myBuildingImports;
                this.myCachedImportsArray = null;
                this.myImportedTargets = null;
            }
        }
        if (this.myCachedImportsArray == null) {
            this.myCachedImportsArray = this.myImports.toArray(new AntFile[this.myImports.size()]);
        }
        // MONITOREXIT : object
        if (this.myCachedImportsArray != null) return this.myCachedImportsArray;
        throw new IllegalStateException("@NotNull method com/intellij/lang/ant/psi/impl/AntProjectImpl.getImportedFiles must not return null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addImportedFile(AntFile imported) {
        try {
            this.myImports.add(imported);
        }
        finally {
            this.myCachedImportsArray = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerRefId(String id, AntElement element) {
        Object object = PsiLock.LOCK;
        synchronized (object) {
            if (id == null || id.length() == 0) {
                return;
            }
            if (this.myReferencedElements == null) {
                this.myReferencedElements = new HashMap<String, AntElement>();
            }
            this.myReferencedElements.put(id, element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public AntElement getElementByRefId(String refid) {
        Object object = PsiLock.LOCK;
        synchronized (object) {
            if (this.myReferencedElements == null) {
                return null;
            }
            refid = this.computeAttributeValue(refid);
            return this.myReferencedElements.get(refid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public String[] getRefIds() {
        Object object = PsiLock.LOCK;
        // MONITORENTER : object
        if (this.myRefIdsArray == null) {
            this.myRefIdsArray = this.myReferencedElements == null ? ArrayUtil.EMPTY_STRING_ARRAY : this.myReferencedElements.keySet().toArray(new String[this.myReferencedElements.size()]);
        }
        // MONITOREXIT : object
        if (this.myRefIdsArray != null) return this.myRefIdsArray;
        throw new IllegalStateException("@NotNull method com/intellij/lang/ant/psi/impl/AntProjectImpl.getRefIds must not return null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getImportedTargets(AntProject project, Set<PsiElement> targets, Set<PsiElement> elementsDepthStack) {
        if (elementsDepthStack.contains(project)) {
            return;
        }
        elementsDepthStack.add(project);
        try {
            for (AntFile imported : project.getImportedFiles()) {
                AntProject importedProject = imported.getAntProject();
                if (importedProject != null && !elementsDepthStack.contains(importedProject)) {
                    for (AntTarget target : importedProject.getTargets()) {
                        targets.add(target);
                    }
                }
                AntProjectImpl.getImportedTargets(importedProject, targets, elementsDepthStack);
            }
        }
        finally {
            elementsDepthStack.remove(project);
        }
    }

    private static void buildTagText(XmlTag tag, StringBuilder builder) {
        boolean firstChild = true;
        for (PsiElement tagChild : tag.getChildren()) {
            if (!firstChild) {
                builder.append(' ');
            }
            if (tagChild instanceof XmlTag) {
                AntProjectImpl.buildTagText((XmlTag)tagChild, builder);
            } else {
                builder.append(tagChild.getText());
            }
            firstChild = false;
        }
    }
}

