/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.RootUrlInfo;
import org.jetbrains.idea.svn.SvnFileUrlMapping;
import org.jetbrains.idea.svn.SvnVcs;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNLogEntryPath;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCClient;

public class LatestExistentSearcher {
    private long myStartNumber;
    private boolean myStartExistsKnown;
    private final SVNURL myUrl;
    private final SvnVcs myVcs;
    private long myEndNumber;

    public LatestExistentSearcher(SvnVcs vcs, SVNURL url) {
        this(0L, -1L, false, vcs, url);
    }

    public LatestExistentSearcher(long startNumber, long endNumber, boolean startExistsKnown, SvnVcs vcs, SVNURL url) {
        this.myStartNumber = startNumber;
        this.myEndNumber = endNumber;
        this.myStartExistsKnown = startExistsKnown;
        this.myVcs = vcs;
        this.myUrl = url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDeletionRevision() {
        if (!this.detectStartRevision()) {
            return -1L;
        }
        final Ref latest = new Ref((Object)this.myStartNumber);
        SVNRepository repository = null;
        try {
            repository = this.myVcs.createRepository(this.myUrl.toString());
            SVNURL repRoot = repository.getRepositoryRoot(true);
            if (repRoot != null) {
                SVNURL existingParent;
                if (this.myEndNumber == -1L) {
                    this.myEndNumber = repository.getLatestRevision();
                }
                if ((existingParent = this.getExistingParent(this.myUrl, repository, repRoot.toString().length())) == null) {
                    long l = this.myStartNumber;
                    return l;
                }
                final String urlRelativeString = this.myUrl.toString().substring(repRoot.toString().length());
                SVNRevision startRevision = SVNRevision.create((long)this.myStartNumber);
                this.myVcs.createLogClient().doLog(existingParent, new String[]{""}, startRevision, startRevision, SVNRevision.HEAD, false, true, 0L, new ISVNLogEntryHandler(){

                    public void handleLogEntry(SVNLogEntry logEntry) throws SVNException {
                        Map changedPaths = logEntry.getChangedPaths();
                        for (Object o : changedPaths.values()) {
                            SVNLogEntryPath path = (SVNLogEntryPath)o;
                            if (path.getType() != 'D' || !urlRelativeString.equals(path.getPath())) continue;
                            latest.set((Object)logEntry.getRevision());
                            throw new SVNException(SVNErrorMessage.UNKNOWN_ERROR_MESSAGE);
                        }
                    }
                });
            }
        }
        catch (SVNException sVNException) {
        }
        finally {
            if (repository != null) {
                repository.closeSession();
            }
        }
        return (Long)latest.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLatestExistent() {
        if (!this.detectStartRevision()) {
            return this.myStartNumber;
        }
        SVNRepository repository = null;
        long latestOk = this.myStartNumber;
        try {
            repository = this.myVcs.createRepository(this.myUrl.toString());
            SVNURL repRoot = repository.getRepositoryRoot(true);
            if (repRoot != null) {
                if (this.myEndNumber == -1L) {
                    this.myEndNumber = repository.getLatestRevision();
                }
                String urlString = this.myUrl.toString().substring(repRoot.toString().length());
                for (long i = this.myStartNumber + 1L; i < this.myEndNumber; ++i) {
                    SVNNodeKind kind = repository.checkPath(urlString, i);
                    if (!SVNNodeKind.DIR.equals(kind) && !SVNNodeKind.FILE.equals(kind)) continue;
                    latestOk = i;
                }
            }
        }
        catch (SVNException e) {
        }
        finally {
            if (repository != null) {
                repository.closeSession();
            }
        }
        return latestOk;
    }

    private boolean detectStartRevision() {
        if (!this.myStartExistsKnown) {
            SvnFileUrlMapping mapping = this.myVcs.getSvnFileUrlMapping();
            RootUrlInfo rootUrlInfo = mapping.getWcRootForUrl(this.myUrl.toString());
            if (rootUrlInfo == null) {
                return true;
            }
            VirtualFile vf = rootUrlInfo.getVirtualFile();
            if (vf == null) {
                return true;
            }
            SVNWCClient client = this.myVcs.createWCClient();
            try {
                SVNInfo info = client.doInfo(new File(vf.getPath()), SVNRevision.WORKING);
                if (info == null || info.getRevision() == null) {
                    return false;
                }
                this.myStartNumber = info.getRevision().getNumber();
                this.myStartExistsKnown = true;
            }
            catch (SVNException e) {
                return false;
            }
        }
        return true;
    }

    @Nullable
    private SVNURL getExistingParent(SVNURL url, SVNRepository repository, int repoRootLen) throws SVNException {
        String urlString = url.toString().substring(repoRootLen);
        if (urlString.length() == 0) {
            return url;
        }
        SVNNodeKind kind = repository.checkPath(urlString, this.myEndNumber);
        if (SVNNodeKind.DIR.equals(kind) || SVNNodeKind.FILE.equals(kind)) {
            return url;
        }
        SVNURL parentUrl = url.removePathTail();
        if (parentUrl == null) {
            return null;
        }
        return this.getExistingParent(parentUrl, repository, repoRootLen);
    }
}

