/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.ide.actions.EditSourceAction;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MultiLineLabelUI;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.pom.Navigatable;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.ContentsUtil;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.EditSourceOnEnterKeyHandler;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.plaf.LabelUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class IntersectingLocalChangesPanel {
    private final JPanel myPanel;
    private final String myText;
    private final List<FilePath> myFilesToShow;
    private final Project myProject;
    private JTree myJTree;

    public IntersectingLocalChangesPanel(Project project, List<FilePath> filesToShow, String text) {
        this.myProject = project;
        this.myText = text;
        this.myPanel = new MyPanel(new BorderLayout());
        this.myFilesToShow = filesToShow;
        this.initUI();
    }

    public JPanel getPanel() {
        return this.myPanel;
    }

    private void initUI() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        this.myJTree = new JTree(root);
        this.myJTree.setRootVisible(false);
        this.myJTree.setShowsRootHandles(false);
        this.myJTree.setCellRenderer((TreeCellRenderer)new ChangesBrowserNodeRenderer(this.myProject, true, false));
        TreeModelBuilder builder = new TreeModelBuilder(this.myProject, true);
        DefaultTreeModel treeModel = builder.buildModelFromFilePaths(this.myFilesToShow);
        this.myJTree.setModel(treeModel);
        this.myJTree.expandPath(new TreePath(root.getPath()));
        JLabel label = new JLabel(this.myText){

            @Override
            public Dimension getPreferredSize() {
                Dimension superValue = super.getPreferredSize();
                return new Dimension((int)superValue.getWidth(), (int)(superValue.getHeight() * 1.7));
            }
        };
        label.setUI((LabelUI)new MultiLineLabelUI());
        label.setBackground(UIUtil.getTextFieldBackground());
        label.setVerticalTextPosition(1);
        this.myPanel.setBackground(UIUtil.getTextFieldBackground());
        this.myPanel.add((Component)label, "North");
        this.myPanel.add((Component)this.myJTree, "Center");
        EditSourceOnDoubleClickHandler.install((JTree)this.myJTree);
        EditSourceOnEnterKeyHandler.install((JTree)this.myJTree);
        EditSourceAction editSourceAction = new EditSourceAction();
        editSourceAction.registerCustomShortcutSet(CommonShortcuts.getEditSource(), (JComponent)this.myPanel);
    }

    private Component getPrefferedFocusComponent() {
        return this.myJTree;
    }

    public static void showInVersionControlToolWindow(final Project project, String title, List<FilePath> filesToShow, String prompt) {
        final IntersectingLocalChangesPanel component = new IntersectingLocalChangesPanel(project, filesToShow, prompt);
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow(ToolWindowId.VCS);
        ContentManager contentManager = toolWindow.getContentManager();
        Content content = ContentFactory.SERVICE.getInstance().createContent((JComponent)component.getPanel(), title, true);
        ContentsUtil.addContent((ContentManager)contentManager, (Content)content, (boolean)true);
        toolWindow.activate(new Runnable(){

            @Override
            public void run() {
                IdeFocusManager.getInstance((Project)project).requestFocus(component.getPrefferedFocusComponent(), true);
            }
        });
    }

    private class MyPanel
    extends JPanel
    implements TypeSafeDataProvider {
        private MyPanel(LayoutManager layout) {
            super(layout);
        }

        public void calcData(DataKey key, DataSink sink) {
            if (PlatformDataKeys.NAVIGATABLE_ARRAY.equals(key)) {
                TreePath[] treePaths = IntersectingLocalChangesPanel.this.myJTree.getSelectionModel().getSelectionPaths();
                ArrayList<OpenFileDescriptor> navigatables = new ArrayList<OpenFileDescriptor>(treePaths.length);
                for (TreePath treePath : treePaths) {
                    List filePaths = ((ChangesBrowserNode)treePath.getLastPathComponent()).getAllFilePathsUnder();
                    for (FilePath filePath : filePaths) {
                        if (filePath.getVirtualFile() == null) continue;
                        navigatables.add(new OpenFileDescriptor(IntersectingLocalChangesPanel.this.myProject, filePath.getVirtualFile()));
                    }
                }
                sink.put(key, (Object)navigatables.toArray(new Navigatable[navigatables.size()]));
            }
        }
    }
}

