/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FilePathImpl;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.changes.ChangeListManagerGate;
import com.intellij.openapi.vcs.changes.ChangeProvider;
import com.intellij.openapi.vcs.changes.ChangelistBuilder;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.VcsDirtyScope;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EventDispatcher;
import java.io.File;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.NestedCopiesBuilder;
import org.jetbrains.idea.svn.StatusReceiver;
import org.jetbrains.idea.svn.StatusWalkerPartnerImpl;
import org.jetbrains.idea.svn.SvnChangeProviderContext;
import org.jetbrains.idea.svn.SvnChangedFile;
import org.jetbrains.idea.svn.SvnContentRevision;
import org.jetbrains.idea.svn.SvnFileUrlMappingImpl;
import org.jetbrains.idea.svn.SvnRecursiveStatusWalker;
import org.jetbrains.idea.svn.SvnScopeZipper;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.actions.CleanupWorker;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.wc.ISVNStatusFileProvider;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusType;

public class SvnChangeProvider
implements ChangeProvider {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.svn.SvnChangeProvider");
    public static final String ourDefaultListName = VcsBundle.message((String)"changes.default.changlist.name", (Object[])new Object[0]);
    private final SvnVcs myVcs;
    private final VcsContextFactory myFactory;
    private SvnFileUrlMappingImpl mySvnFileUrlMapping;

    public SvnChangeProvider(SvnVcs vcs) {
        this.myVcs = vcs;
        this.myFactory = VcsContextFactory.SERVICE.getInstance();
        this.mySvnFileUrlMapping = (SvnFileUrlMappingImpl)vcs.getSvnFileUrlMapping();
    }

    public void getChanges(VcsDirtyScope dirtyScope, ChangelistBuilder builder, ProgressIndicator progress, ChangeListManagerGate addGate) throws VcsException {
        SvnScopeZipper zipper = new SvnScopeZipper(dirtyScope);
        zipper.run();
        Map<String, SvnScopeZipper.MyDirNonRecursive> nonRecursiveMap = zipper.getNonRecursiveDirs();
        ISVNStatusFileProvider fileProvider = this.createFileProvider(nonRecursiveMap);
        try {
            SvnChangeProviderContext context = new SvnChangeProviderContext(this.myVcs, builder, progress);
            StatusWalkerPartnerImpl partner = new StatusWalkerPartnerImpl(this.myVcs, progress);
            NestedCopiesBuilder nestedCopiesBuilder = new NestedCopiesBuilder();
            EventDispatcher statusReceiver = EventDispatcher.create(StatusReceiver.class);
            statusReceiver.addListener((EventListener)context);
            statusReceiver.addListener((EventListener)nestedCopiesBuilder);
            SvnRecursiveStatusWalker walker = new SvnRecursiveStatusWalker((StatusReceiver)statusReceiver.getMulticaster(), partner);
            for (FilePath path : zipper.getRecursiveDirs()) {
                walker.go(path, SVNDepth.INFINITY);
            }
            partner.setFileProvider(fileProvider);
            for (SvnScopeZipper.MyDirNonRecursive item : nonRecursiveMap.values()) {
                walker.go(item.getDir(), SVNDepth.FILES);
            }
            this.processCopiedAndDeleted(context);
            this.mySvnFileUrlMapping.acceptNestedData(nestedCopiesBuilder.getSet());
        }
        catch (SVNException e) {
            throw new VcsException((Throwable)e);
        }
    }

    private ISVNStatusFileProvider createFileProvider(Map<String, SvnScopeZipper.MyDirNonRecursive> nonRecursiveMap) {
        final HashMap preparedMap = new HashMap();
        for (SvnScopeZipper.MyDirNonRecursive item : nonRecursiveMap.values()) {
            HashMap<String, File> result = new HashMap<String, File>();
            for (FilePath path : item.getChildrenList()) {
                result.put(path.getName(), path.getIOFile());
            }
            preparedMap.put(item.getDir().getIOFile().getAbsolutePath(), result);
        }
        return new ISVNStatusFileProvider(){

            public Map getChildrenFiles(File parent) {
                return (Map)preparedMap.get(parent.getAbsolutePath());
            }
        };
    }

    private void processCopiedAndDeleted(SvnChangeProviderContext context) throws SVNException {
        for (SvnChangedFile copiedFile : context.getCopiedFiles()) {
            if (context.isCanceled()) {
                throw new ProcessCanceledException();
            }
            this.processCopiedFile(copiedFile, context.getBuilder(), context);
        }
        for (SvnChangedFile deletedFile : context.getDeletedFiles()) {
            if (context.isCanceled()) {
                throw new ProcessCanceledException();
            }
            context.processStatus(deletedFile.getFilePath(), deletedFile.getStatus());
        }
    }

    public void getChanges(FilePath path, boolean recursive, ChangelistBuilder builder) throws SVNException {
        SvnChangeProviderContext context = new SvnChangeProviderContext(this.myVcs, builder, null);
        StatusWalkerPartnerImpl partner = new StatusWalkerPartnerImpl(this.myVcs, ProgressManager.getInstance().getProgressIndicator());
        SvnRecursiveStatusWalker walker = new SvnRecursiveStatusWalker(context, partner);
        walker.go(path, recursive ? SVNDepth.INFINITY : SVNDepth.IMMEDIATES);
        this.processCopiedAndDeleted(context);
    }

    @Nullable
    private String changeListNameFromStatus(SVNStatus status) {
        if (WorkingCopyFormat.getInstance(status.getWorkingCopyFormat()).supportsChangelists() && SVNNodeKind.FILE.equals(status.getKind())) {
            String clName = status.getChangelistName();
            return clName == null ? null : clName;
        }
        return null;
    }

    private void processCopiedFile(SvnChangedFile copiedFile, ChangelistBuilder builder, SvnChangeProviderContext context) throws SVNException {
        boolean foundRename = false;
        SVNStatus copiedStatus = copiedFile.getStatus();
        String copyFromURL = copiedFile.getCopyFromURL();
        FilePath copiedToPath = copiedFile.getFilePath();
        HashSet<SvnChangedFile> deletedToDelete = new HashSet<SvnChangedFile>();
        for (SvnChangedFile deletedFile : context.getDeletedFiles()) {
            SVNStatus deletedStatus = deletedFile.getStatus();
            if (deletedStatus == null || deletedStatus.getURL() == null || !Comparing.equal((String)copyFromURL, (String)deletedStatus.getURL().toString())) continue;
            String clName = this.changeListNameFromStatus(copiedFile.getStatus());
            builder.processChangeInList(context.createMovedChange(this.createBeforeRevision(deletedFile, true), CurrentContentRevision.create((FilePath)copiedFile.getFilePath()), copiedStatus, deletedStatus), clName, SvnVcs.getKey());
            deletedToDelete.add(deletedFile);
            for (SvnChangedFile deletedChild : context.getDeletedFiles()) {
                String childURL;
                SVNURL childUrl;
                SVNStatus childStatus = deletedChild.getStatus();
                if (childStatus == null || (childUrl = childStatus.getURL()) == null || !StringUtil.startsWithConcatenationOf((String)(childURL = childUrl.toString()), (String)copyFromURL, (String)"/")) continue;
                String relativePath = childURL.substring(copyFromURL.length());
                File newPath = new File(copiedFile.getFilePath().getIOFile(), relativePath);
                FilePath newFilePath = this.myFactory.createFilePathOn(newPath);
                if (context.isDeleted(newFilePath)) continue;
                builder.processChangeInList(context.createMovedChange(this.createBeforeRevision(deletedChild, true), CurrentContentRevision.create((FilePath)newFilePath), context.getTreeConflictStatus(newPath), childStatus), clName, SvnVcs.getKey());
                deletedToDelete.add(deletedChild);
            }
            foundRename = true;
            break;
        }
        List<SvnChangedFile> deletedFiles = context.getDeletedFiles();
        for (SvnChangedFile file : deletedToDelete) {
            deletedFiles.remove(file);
        }
        if (!foundRename && copiedStatus.getURL() != null) {
            SVNStatus status;
            File wcPath = SvnChangeProvider.guessWorkingCopyPath(copiedStatus.getFile(), copiedStatus.getURL(), copyFromURL);
            try {
                status = context.getClient().doStatus(wcPath, false);
            }
            catch (SVNException ex) {
                status = null;
            }
            if (status != null && status.getContentsStatus() == SVNStatusType.STATUS_DELETED) {
                FilePath filePath = this.myFactory.createFilePathOnDeleted(wcPath, false);
                SvnContentRevision beforeRevision = SvnContentRevision.create(this.myVcs, filePath, status.getCommittedRevision());
                ContentRevision afterRevision = CurrentContentRevision.create((FilePath)copiedFile.getFilePath());
                builder.processChangeInList(context.createMovedChange(beforeRevision, afterRevision, copiedStatus, status), this.changeListNameFromStatus(status), SvnVcs.getKey());
                foundRename = true;
            }
        }
        if (!foundRename) {
            LOG.info("Rename not found for " + copiedFile.getFilePath().getPresentableUrl());
            context.processStatus(copiedFile.getFilePath(), copiedStatus);
        }
    }

    private SvnContentRevision createBeforeRevision(SvnChangedFile changedFile, boolean forDeleted) {
        return SvnContentRevision.create(this.myVcs, (FilePath)(forDeleted ? FilePathImpl.createForDeletedFile((File)changedFile.getStatus().getFile(), (boolean)changedFile.getFilePath().isDirectory()) : changedFile.getFilePath()), changedFile.getStatus().getCommittedRevision());
    }

    private static File guessWorkingCopyPath(File file, @NotNull SVNURL url, String copyFromURL) throws SVNException {
        int i;
        if (url == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/idea/svn/SvnChangeProvider.guessWorkingCopyPath must not be null");
        }
        String copiedPath = url.getPath();
        String copyFromPath = SVNURL.parseURIEncoded((String)copyFromURL).getPath();
        String commonPathAncestor = SVNPathUtil.getCommonPathAncestor((String)copiedPath, (String)copyFromPath);
        int pathSegmentCount = SVNPathUtil.getSegmentsCount((String)copiedPath);
        int ancestorSegmentCount = SVNPathUtil.getSegmentsCount((String)commonPathAncestor);
        boolean startsWithSlash = file.getAbsolutePath().startsWith("/");
        List segments = StringUtil.split((String)file.getPath(), (String)File.separator);
        List copyFromPathSegments = StringUtil.split((String)copyFromPath, (String)"/");
        ArrayList resultSegments = new ArrayList();
        int keepSegments = segments.size() - pathSegmentCount + ancestorSegmentCount;
        for (i = 0; i < keepSegments; ++i) {
            resultSegments.add(segments.get(i));
        }
        for (i = ancestorSegmentCount; i < copyFromPathSegments.size(); ++i) {
            resultSegments.add(copyFromPathSegments.get(i));
        }
        String result = StringUtil.join(resultSegments, (String)"/");
        if (startsWithSlash) {
            result = "/" + result;
        }
        return new File(result);
    }

    public boolean isModifiedDocumentTrackingRequired() {
        return true;
    }

    public void doCleanup(List<VirtualFile> files) {
        new CleanupWorker(VfsUtil.toVirtualFileArray(files), this.myVcs.getProject(), "action.Subversion.cleanup.progress.title").execute();
    }
}

