/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.impl.VcsRootIterator;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.Node;
import org.jetbrains.idea.svn.Real;
import org.jetbrains.idea.svn.RootUrlPair;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNWCClient;

public class ForNestedRootChecker {
    public static <T extends RootUrlPair> void filterOutSuperfluousChildren(SvnVcs vcs, List<T> list, List<T> result) {
        UrlConstructor constructor = new UrlConstructor(vcs);
        Collections.sort(list, new Comparator<RootUrlPair>(){

            @Override
            public int compare(RootUrlPair o1, RootUrlPair o2) {
                return o1.getVirtualFile().getPath().compareTo(o2.getVirtualFile().getPath());
            }
        });
        for (int i = 0; i < list.size(); ++i) {
            RootUrlPair child = (RootUrlPair)list.get(i);
            boolean add = true;
            for (RootUrlPair parent : result) {
                String supposed;
                if (parent.getVirtualFile().getPath().equals(child.getVirtualFile().getPath())) {
                    add = false;
                    break;
                }
                List<String> subpath = ForNestedRootChecker.subpathIfAncestor(parent.getVirtualFile(), child.getVirtualFile());
                if (subpath == null || !(supposed = constructor.getSupposedUrl(parent.getUrl(), subpath)).equals(child.getUrl())) continue;
                add = false;
                break;
            }
            if (!add) continue;
            result.add(child);
        }
    }

    @Nullable
    private static List<String> subpathIfAncestor(VirtualFile parent, VirtualFile child) {
        if (!VfsUtil.isAncestor((VirtualFile)parent, (VirtualFile)child, (boolean)true)) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        String parentPath = parent.getPath();
        for (VirtualFile tmp = child; tmp != null && !tmp.getPath().equals(parentPath); tmp = tmp.getParent()) {
            result.add(tmp.getName());
        }
        Collections.reverse(result);
        return result;
    }

    public static List<Real> getAllNestedWorkingCopies(VirtualFile root, SvnVcs vcs, boolean goIntoNested, Getter<Boolean> cancelledGetter) {
        VcsRootIterator rootIterator = new VcsRootIterator(vcs.getProject(), (AbstractVcs)vcs);
        return ForNestedRootChecker.getForOne(root, vcs, goIntoNested, rootIterator, cancelledGetter);
    }

    private static List<Real> getForOne(VirtualFile root, SvnVcs vcs, boolean goIntoNested, VcsRootIterator rootIterator, Getter<Boolean> cancelledGetter) {
        UrlConstructor constructor = new UrlConstructor(vcs);
        LinkedList<Node> queue = new LinkedList<Node>();
        LinkedList<Real> result = new LinkedList<Real>();
        queue.add(constructor.createReplaceable(root));
        while (!queue.isEmpty()) {
            VirtualFile file;
            Node node = (Node)queue.removeFirst();
            if (Boolean.TRUE.equals(cancelledGetter.get())) {
                throw new ProcessCanceledException();
            }
            Real real = constructor.createReal(node.getFile(), root);
            if (real != null && constructor.replaceWithReal(real, node)) {
                result.add(real);
                if (!goIntoNested) continue;
            }
            if (!(file = node.getFile()).isDirectory() || SvnUtil.isAdminDirectory(file)) continue;
            for (VirtualFile child : file.getChildren()) {
                if (Boolean.TRUE.equals(cancelledGetter.get())) {
                    throw new ProcessCanceledException();
                }
                if (!rootIterator.acceptFolderUnderVcs(root, child)) continue;
                if (real == null) {
                    queue.add(constructor.createReplaceable(child));
                    continue;
                }
                queue.add(constructor.createSupposed(real, child));
            }
        }
        return result;
    }

    private static class UrlConstructor {
        final SvnVcs myVcs;
        final SVNWCClient myClient;

        private UrlConstructor(SvnVcs vcs) {
            this.myVcs = vcs;
            this.myClient = this.myVcs.createWCClient();
        }

        @Nullable
        public Real createReal(VirtualFile file, VirtualFile vcsRoot) {
            SVNInfo info = this.myVcs.getInfo(file);
            if (info == null || info.getRepositoryRootURL() == null || info.getURL() == null) {
                return null;
            }
            return new Real(file, info, vcsRoot);
        }

        public Node createReplaceable(VirtualFile file) {
            return new Node(file, null);
        }

        public Node createSupposed(Real parent, VirtualFile child) {
            return new Node(child, this.getForChild(parent.getUrl(), child.getName()));
        }

        public boolean replaceWithReal(Real real, Node supposed) {
            return supposed.getUrl() == null || supposed.getUrl() != null && !supposed.getUrl().equals(real.getUrl());
        }

        @Nullable
        private String getSupposedUrl(String parentUrl, List<String> subpath) {
            if (parentUrl == null) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            for (String s : subpath) {
                sb.append(s).append('/');
            }
            if (sb.length() > 0) {
                sb.deleteCharAt(sb.length() - 1);
            }
            return SVNPathUtil.append((String)parentUrl, (String)sb.toString());
        }

        public String getForChild(String parentUrl, String childName) {
            return parentUrl == null ? null : SVNPathUtil.append((String)parentUrl, (String)SVNEncodingUtil.uriEncode((String)childName));
        }
    }

    static class DirInfo {
        private final VirtualFile myFile;
        private final String myUrl;

        DirInfo(VirtualFile file, String url) {
            this.myFile = file;
            this.myUrl = url;
        }

        public VirtualFile getFile() {
            return this.myFile;
        }

        public String getUrl() {
            return this.myUrl;
        }
    }
}

