/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages;

import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.UsageGroup;
import com.intellij.usages.UsageView;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class PsiNamedElementUsageGroupBase<T extends PsiNamedElement & NavigationItem>
implements UsageGroup {
    private final SmartPsiElementPointer myElementPointer;
    private final String myName;
    private final Icon myIcon;

    public PsiNamedElementUsageGroupBase(@NotNull T element, Icon icon) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/usages/PsiNamedElementUsageGroupBase.<init> must not be null");
        }
        String myName = ((NavigationItem)element).getName();
        if (myName == null) {
            myName = "<anonymous>";
        }
        this.myName = myName;
        this.myElementPointer = SmartPointerManager.getInstance(element.getProject()).createLazyPointer(element);
        this.myIcon = icon;
    }

    public PsiNamedElementUsageGroupBase(@NotNull T element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/usages/PsiNamedElementUsageGroupBase.<init> must not be null");
        }
        this(element, element.getIcon(0));
    }

    @Override
    public Icon getIcon(boolean isOpen) {
        return this.myIcon;
    }

    public T getElement() {
        return (T)((PsiNamedElement)this.myElementPointer.getElement());
    }

    @Override
    @NotNull
    public String getText(UsageView view) {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/usages/PsiNamedElementUsageGroupBase.getText must not return null");
        }
        return string;
    }

    @Override
    public FileStatus getFileStatus() {
        return this.isValid() ? ((NavigationItem)this.getElement()).getFileStatus() : null;
    }

    @Override
    public boolean isValid() {
        T element = this.getElement();
        return element != null && element.isValid();
    }

    @Override
    public void navigate(boolean focus) throws UnsupportedOperationException {
        if (this.canNavigate()) {
            ((Navigatable)this.getElement()).navigate(focus);
        }
    }

    @Override
    public boolean canNavigate() {
        return this.isValid();
    }

    @Override
    public boolean canNavigateToSource() {
        return this.canNavigate();
    }

    @Override
    public void update() {
    }

    @Override
    public int compareTo(UsageGroup o) {
        return this.myName.compareTo(((PsiNamedElementUsageGroupBase)o).myName);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PsiNamedElementUsageGroupBase)) {
            return false;
        }
        PsiNamedElementUsageGroupBase group = (PsiNamedElementUsageGroupBase)obj;
        if (this.isValid() && group.isValid()) {
            return this.getElement().getManager().areElementsEquivalent((PsiElement)this.getElement(), (PsiElement)group.getElement());
        }
        return Comparing.equal((String)this.myName, (String)((PsiNamedElementUsageGroupBase)obj).myName);
    }

    public int hashCode() {
        return this.myName.hashCode();
    }

    public void calcData(DataKey key, DataSink sink) {
        T element;
        if (!this.isValid()) {
            return;
        }
        if (LangDataKeys.PSI_ELEMENT == key) {
            sink.put(LangDataKeys.PSI_ELEMENT, this.getElement());
        }
        if (UsageView.USAGE_INFO_KEY == key && (element = this.getElement()) != null) {
            sink.put(UsageView.USAGE_INFO_KEY, new UsageInfo((PsiElement)element));
        }
    }
}

