/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.filters.position;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.xml.XmlDoctype;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlProlog;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ReflectionCache;

public class NamespaceFilter
implements ElementFilter {
    private final String[] myNamespaces;

    public NamespaceFilter(String ... namespaces) {
        this.myNamespaces = namespaces;
    }

    @Override
    public boolean isClassAcceptable(Class hintClass) {
        return ReflectionCache.isAssignable(XmlTag.class, (Class)hintClass) || ReflectionCache.isAssignable(XmlDocument.class, (Class)hintClass);
    }

    @Override
    public boolean isAcceptable(Object element, PsiElement context) {
        if (element instanceof XmlTag) {
            String publicId;
            XmlDoctype doctype;
            XmlProlog prolog;
            XmlTag psiElement = (XmlTag)element;
            if (!psiElement.isValid()) {
                return false;
            }
            String ns = psiElement.getNamespace();
            for (String aMyValue : this.myNamespaces) {
                if (!aMyValue.equals(ns)) continue;
                return true;
            }
            PsiFile psiFile = psiElement.getContainingFile();
            if (psiFile instanceof XmlFile && (prolog = ((XmlFile)psiFile).getDocument().getProlog()) != null && (doctype = prolog.getDoctype()) != null && (publicId = doctype.getPublicId()) != null) {
                for (String aMyValue : this.myNamespaces) {
                    if (!aMyValue.equals(publicId)) continue;
                    return true;
                }
            }
        } else if (element instanceof XmlDocument) {
            return this.isAcceptable(((XmlDocument)element).getRootTag(), context);
        }
        return false;
    }
}

